/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.SnifferManager;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="deploy")
@I18n(value="deploy.command")
@Scoped(value=PerLookup.class)
public class DeployCommand
extends DeployCommandParameters
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeployCommand.class);
    private static final String INSTANCE_ROOT_URI_PROPERTY_NAME = "com.sun.aas.instanceRootURI";
    @Inject
    Applications apps;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Deployment deployment;
    @Inject
    SnifferManager snifferManager;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Domain domain;

    public DeployCommand() {
        this.origin = OpsParams.Origin.deploy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execute(AdminCommandContext context) {
        block37: {
            operationStartTime = Calendar.getInstance().getTimeInMillis();
            report = context.getActionReport();
            logger = context.getLogger();
            file = this.choosePathFile(context);
            if (!file.exists()) {
                report.setMessage(DeployCommand.localStrings.getLocalString("fnf", "File not found", new Object[]{file.getAbsolutePath()}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            this.deploymentplan = this.chooseDeploymentPlanFile(context);
            if (this.snifferManager.hasNoSniffers()) {
                msg = DeployCommand.localStrings.getLocalString("nocontainer", "No container services registered, done...");
                report.failure(logger, msg);
                return;
            }
            try {
                archive = this.archiveFactory.openArchive(file);
            }
            catch (IOException e) {
                if (this.logReportedErrors.booleanValue()) {
                    report.failure(logger, "Error opening deployable artifact : " + file.getAbsolutePath(), (Throwable)e);
                } else {
                    report.setMessage("Error opening deployable artifact : " + file.getAbsolutePath() + e.toString());
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                }
                return;
            }
            expansionDir = null;
            try {
                archiveHandler = this.deployment.getArchiveHandler(archive);
                if (archiveHandler == null) {
                    report.failure(logger, DeployCommand.localStrings.getLocalString("deploy.unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{file.getName()}));
                    return;
                }
                if (this.name == null) {
                    this.name = archiveHandler.getDefaultApplicationName(archive);
                }
                undeployProps = this.handleRedeploy(this.name, report);
                if (!this.keepreposdir.booleanValue()) {
                    FileUtils.whack((File)new File(this.env.getApplicationRepositoryPath(), this.name));
                }
                source = new File(archive.getURI().getSchemeSpecificPart());
                isDirectoryDeployed = true;
                if (!source.isDirectory()) {
                    isDirectoryDeployed = false;
                    file = expansionDir = new File(this.domain.getApplicationRoot(), this.name);
                }
                deploymentContext = this.deployment.getContext(logger, archive, (OpsParams)this);
                deploymentContext.setArchiveHandler(archiveHandler);
                if (undeployProps != null) {
                    deploymentContext.getProps().putAll((Map<?, ?>)undeployProps);
                }
                if (this.properties != null) {
                    deploymentContext.getProps().putAll((Map<?, ?>)this.properties);
                }
                deploymentContext.clean();
                moduleProps = deploymentContext.getProps();
                moduleProps.setProperty("name", this.name);
                instanceRootURI = new URI(System.getProperty("com.sun.aas.instanceRootURI"));
                appURI = instanceRootURI.relativize(deploymentContext.getSource().getURI());
                appLocation = appURI.isAbsolute() != false ? appURI.toString() : "${com.sun.aas.instanceRootURI}/" + appURI.toString();
                moduleProps.setProperty("location", appLocation);
                moduleProps.setProperty("object-type", "user");
                if (this.contextRoot != null) {
                    moduleProps.setProperty("context-root", this.contextRoot);
                }
                if (this.libraries != null) {
                    moduleProps.setProperty("libraries", this.libraries);
                }
                moduleProps.setProperty("enabled", this.enabled.toString());
                moduleProps.setProperty("directory-deployed", String.valueOf(isDirectoryDeployed));
                if (this.virtualservers != null) {
                    moduleProps.setProperty("virtual-servers", this.virtualservers);
                }
                if (this.description != null) {
                    moduleProps.setProperty("description", this.description);
                }
                appInfo = this.deployment.deploy(deploymentContext, report);
                if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                    this.deployment.registerAppInDomainXML(appInfo, (DeploymentContext)deploymentContext);
                }
                ** try [egrp 4[TRYBLOCK] [2 : 842->852)] { 
            }
            catch (Exception e) {
                report.failure(logger, "Error during deployment : " + e.getMessage(), (Throwable)e);
                break block37;
            }
            finally {
                try {
                    archive.close();
                }
                catch (IOException e) {
                    logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
                }
                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                    logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                } else if (expansionDir != null) {
                    FileUtils.whack(expansionDir);
                }
            }
lbl-1000:
            // 1 sources

            {
                archive.close();
            }
lbl80:
            // 1 sources

            catch (IOException e) {
                logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e);
            }
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                logger.info("Deployment of " + this.name + " done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
            } else if (expansionDir != null) {
                FileUtils.whack((File)expansionDir);
            }
        }
    }

    private File choosePathFile(AdminCommandContext context) {
        if (context.getUploadedFiles().size() >= 1) {
            return (File)context.getUploadedFiles().get(0);
        }
        return this.path;
    }

    private File chooseDeploymentPlanFile(AdminCommandContext context) {
        if (context.getUploadedFiles().size() >= 2) {
            return (File)context.getUploadedFiles().get(1);
        }
        return this.deploymentplan;
    }

    private Properties handleRedeploy(String name, ActionReport report) throws Exception {
        boolean isRegistered = this.deployment.isRegistered(name);
        if (isRegistered && !this.force.booleanValue()) {
            String msg = localStrings.getLocalString("application.alreadyreg.redeploy", "Application {0} already registered, please use deploy --force=true to redeploy", new Object[]{name});
            throw new Exception(msg);
        }
        if (isRegistered && this.force.booleanValue()) {
            Application app = (Application)this.apps.getModule(Application.class, name);
            this.settingsFromDomainXML(app);
            UndeployCommandParameters undeployParams = new UndeployCommandParameters(name);
            undeployParams.keepreposdir = this.keepreposdir;
            ActionReport subReport = report.addSubActionsReport();
            if (this.properties != null && this.properties.containsKey("keepSessions")) {
                undeployParams.properties = new Properties();
                undeployParams.properties.put("keepSessions", this.properties.getProperty("keepSessions"));
                subReport.setExtraProperties(new Properties());
            }
            this.commandRunner.doCommand("undeploy", (Object)undeployParams, subReport, null);
            return subReport.getExtraProperties();
        }
        return null;
    }

    private void settingsFromDomainXML(Application app) {
        if (this.name != null) {
            if (this.contextRoot == null) {
                this.contextRoot = app.getContextRoot();
                if (this.contextRoot != null) {
                    this.previousContextRoot = this.contextRoot;
                }
            }
            if (this.libraries == null) {
                this.libraries = app.getLibraries();
            }
            if (this.virtualservers == null) {
                this.virtualservers = ConfigBeansUtilities.getVirtualServers((String)this.target, (String)this.name);
            }
        }
    }
}

