/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loader.util;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.jvnet.hk2.component.Habitat;

public class ASClassLoaderUtil {
    private static final Logger _logger = Logger.getAnonymousLogger();
    private static String modulesClassPath = null;

    public static String getModuleClassPath(Habitat habitat, String moduleId, String deploymentLibs) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ASClassLoaderUtil.getModuleClassPath for module Id : " + moduleId);
        }
        StringBuilder classpath = new StringBuilder(ASClassLoaderUtil.getModulesClasspath(habitat));
        ClassLoaderHierarchy clh = (ClassLoaderHierarchy)habitat.getByContract(ClassLoaderHierarchy.class);
        String commonClassPath = clh.getCommonClassPath();
        if (commonClassPath != null && commonClassPath.length() > 0) {
            classpath.append(commonClassPath).append(File.pathSeparator);
        }
        ASClassLoaderUtil.addLibrariesForModule(classpath, moduleId, deploymentLibs, habitat);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Final classpath: " + classpath.toString());
        }
        return classpath.toString();
    }

    public static String getModuleClassPath(Habitat habitat, DeploymentContext context) {
        DeployCommandParameters params = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        return ASClassLoaderUtil.getModuleClassPath(habitat, params.name(), params.libraries());
    }

    private static void addLibrariesForModule(StringBuilder sb, String moduleId, String deploymentLibs, Habitat habitat) {
        URL[] libs;
        if (deploymentLibs == null) {
            ApplicationInfo appInfo = ((ApplicationRegistry)habitat.getComponent(ApplicationRegistry.class)).get(moduleId);
            if (appInfo == null) {
                return;
            }
            deploymentLibs = appInfo.getLibraries();
        }
        if ((libs = ASClassLoaderUtil.getLibrariesAsURLs(deploymentLibs, habitat)) != null) {
            for (URL u : libs) {
                sb.append(u.getPath());
                sb.append(File.pathSeparator);
            }
        }
    }

    private static URL[] getLibrariesAsURLs(String librariesStr, Habitat habitat) {
        return ASClassLoaderUtil.getLibrariesAsURLs(librariesStr, (ServerEnvironment)habitat.getComponent(ServerEnvironment.class));
    }

    public static URL[] getLibrariesAsURLs(String librariesStr, ServerEnvironment env) {
        if (librariesStr == null) {
            return null;
        }
        String[] librariesStrArray = librariesStr.split(",");
        if (librariesStrArray == null) {
            return null;
        }
        URL[] urls = new URL[librariesStrArray.length];
        String appLibsDir = env.getLibPath() + File.separator + "applibs";
        int i = 0;
        for (String libraryStr : librariesStrArray) {
            try {
                File f = new File(libraryStr);
                if (!f.isAbsolute()) {
                    f = new File(appLibsDir, libraryStr);
                }
                URL url = f.toURI().toURL();
                urls[i++] = url;
            }
            catch (MalformedURLException malEx) {
                _logger.log(Level.WARNING, "Cannot convert classpath to URL", libraryStr);
                _logger.log(Level.WARNING, malEx.getMessage(), malEx);
            }
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String getModulesClasspath(Habitat habitat) {
        Class<ASClassLoaderUtil> clazz = ASClassLoaderUtil.class;
        synchronized (ASClassLoaderUtil.class) {
            if (modulesClassPath == null) {
                StringBuilder tmpString = new StringBuilder();
                ModulesRegistry mr = (ModulesRegistry)habitat.getComponent(ModulesRegistry.class);
                if (mr != null) {
                    for (Module module : mr.getModules()) {
                        for (URI uri : module.getModuleDefinition().getLocations()) {
                            tmpString.append(uri.getPath());
                            tmpString.append(File.pathSeparator);
                        }
                    }
                }
                modulesClassPath = tmpString.toString();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return modulesClassPath;
        }
    }
}

