/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.lang.instrument.ClassFileTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.component.PreDestroy;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleInfo {
    private static final Logger logger = LogDomains.getLogger(ApplicationInfo.class, (String)"javax.enterprise.system.core");
    private final Set<EngineRef> engines = new LinkedHashSet<EngineRef>();
    private final String name;

    public ModuleInfo(String name, Collection<EngineRef> refs) {
        this.name = name;
        for (EngineRef ref : refs) {
            this.engines.add(ref);
        }
    }

    public Set<EngineRef> getEngineRefs() {
        LinkedHashSet<EngineRef> copy = new LinkedHashSet<EngineRef>();
        copy.addAll(this._getEngineRefs());
        return copy;
    }

    protected Set<EngineRef> _getEngineRefs() {
        return this.engines;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
        for (EngineRef engine : this._getEngineRefs()) {
            sniffers.add(engine.getContainerInfo().getSniffer());
        }
        return sniffers;
    }

    public void load(ExtendedDeploymentContext context, ActionReport report, ProgressTracker tracker) throws Exception {
        context.setPhase(ExtendedDeploymentContext.Phase.LOAD);
        if (!context.getTransformers().isEmpty()) {
            try {
                InstrumentableClassLoader icl = (InstrumentableClassLoader)InstrumentableClassLoader.class.cast(context.getFinalClassLoader());
                for (ClassFileTransformer transformer : context.getTransformers()) {
                    icl.addTransformer(transformer);
                }
            }
            catch (Exception e) {
                report.failure(logger, "Class loader used for loading application cannot handle bytecode enhancer", (Throwable)e);
                throw e;
            }
        }
        for (EngineRef engine : this._getEngineRefs()) {
            EngineInfo engineInfo = engine.getContainerInfo();
            Deployer deployer = engineInfo.getDeployer();
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(context.getClassLoader());
                ApplicationContainer appCtr = deployer.load(engineInfo.getContainer(), (DeploymentContext)context);
                if (appCtr == null) {
                    String msg = "Cannot load application in " + engineInfo.getContainer().getName() + " container";
                    report.failure(logger, msg, null);
                    throw new Exception(msg);
                }
                tracker.add("loaded", EngineRef.class, engine);
                engine.load(context);
                engine.setApplicationContainer(appCtr);
            }
            catch (Exception e) {
                report.failure(logger, "Exception while invoking " + deployer.getClass() + " load method", (Throwable)e);
                throw e;
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }

    public <T extends Container> EngineRef getEngineRefForContainer(Class<T> type) {
        for (EngineRef engine : this._getEngineRefs()) {
            Container container = null;
            try {
                container = (Container)type.cast(engine.getContainerInfo().getContainer());
            }
            catch (Exception e) {
                // empty catch block
            }
            if (container == null) continue;
            return engine;
        }
        return null;
    }

    public void start(DeploymentContext context, ActionReport report, ProgressTracker tracker) throws Exception {
        for (EngineRef engine : this._getEngineRefs()) {
            try {
                if (engine.start((ApplicationContext)context, tracker)) continue;
                report.failure(logger, "Module not started " + engine.getApplicationContainer().toString());
                throw new Exception("Module not started " + engine.getApplicationContainer().toString());
            }
            catch (Exception e) {
                report.failure(logger, "Exception while invoking " + engine.getApplicationContainer().getClass() + " start method", (Throwable)e);
                throw e;
            }
        }
    }

    public void stop(ApplicationContext context, Logger logger) {
        for (EngineRef module : this._getEngineRefs()) {
            try {
                module.stop(context, logger);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot stop module " + module.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
    }

    public void unload(ExtendedDeploymentContext context, ActionReport report) {
        this.stop((ApplicationContext)context, logger);
        HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
        for (EngineRef engine : this._getEngineRefs()) {
            if (engine.getApplicationContainer() != null && engine.getApplicationContainer().getClassLoader() != null) {
                classLoaders.add(engine.getApplicationContainer().getClassLoader());
            }
            try {
                engine.unload(context, report);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to unload from container type : " + engine.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
        for (ClassLoader cloader : classLoaders) {
            try {
                ((PreDestroy)PreDestroy.class.cast(cloader)).preDestroy();
            }
            catch (Exception e) {}
        }
    }

    public void clean(ExtendedDeploymentContext context) throws Exception {
        for (EngineRef ref : this._getEngineRefs()) {
            ref.clean(context, logger);
        }
    }

    public boolean suspend(Logger logger) {
        boolean isSuccess = true;
        for (EngineRef engine : this._getEngineRefs()) {
            try {
                engine.getApplicationContainer().suspend();
            }
            catch (Exception e) {
                isSuccess = false;
                logger.log(Level.SEVERE, "Error suspending module " + engine.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
        return isSuccess;
    }

    public boolean resume(Logger logger) {
        boolean isSuccess = true;
        for (EngineRef module : this._getEngineRefs()) {
            try {
                module.getApplicationContainer().resume();
            }
            catch (Exception e) {
                isSuccess = false;
                logger.log(Level.SEVERE, "Error resuming module " + module.getContainerInfo().getSniffer().getModuleType(), e);
            }
        }
        return isSuccess;
    }

    public void save(Module module) throws TransactionFailure, PropertyVetoException {
        module.setName(this.name);
        for (EngineRef ref : this._getEngineRefs()) {
            Engine engine = (Engine)module.createChild(Engine.class);
            module.getEngines().add(engine);
            ref.save(engine);
        }
    }
}

