/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.branding;

import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import org.glassfish.api.branding.Branding;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class GlassFishBranding
implements Branding,
PostConstruct {
    private String product_name = "GlassFish";
    private String abbrev_product_name = "glassfish";
    private String full_version = "3.0-b38";
    private String major_version = "3";
    private String minor_version = "0";
    private String build_id = "java_re-private";
    private String version_prefix = "v";
    private String version_suffix = "";
    private boolean fullVersionSet = false;

    public void postConstruct() {
        try {
            PropertyResourceBundle vRes = (PropertyResourceBundle)PropertyResourceBundle.getBundle("BrandingVersion");
            String str = vRes.getString("product_name");
            if (str != null && str.length() > 0) {
                this.product_name = str;
            }
            if ((str = vRes.getString("abbrev_product_name")) != null && str.length() > 0) {
                this.abbrev_product_name = vRes.getString("abbrev_product_name");
            }
            if ((str = vRes.getString("full_version")) != null && str.length() > 0) {
                this.full_version = vRes.getString("full_version");
                this.fullVersionSet = true;
            }
            if ((str = vRes.getString("major_version")) != null && str.length() > 0) {
                this.major_version = vRes.getString("major_version");
            }
            if ((str = vRes.getString("minor_version")) != null && str.length() > 0) {
                this.minor_version = vRes.getString("minor_version");
            }
            if ((str = vRes.getString("build_id")) != null && str.length() > 0) {
                this.build_id = vRes.getString("build_id");
            }
            if ((str = vRes.getString("version_prefix")) != null && str.length() > 0) {
                this.version_prefix = vRes.getString("version_prefix");
            }
            if ((str = vRes.getString("version_suffix")) != null && str.length() > 0) {
                this.version_suffix = vRes.getString("version_suffix");
            }
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        if (!this.fullVersionSet && this.minor_version != null && this.minor_version.length() > 0) {
            try {
                this.full_version = Integer.parseInt(this.minor_version) > 0 ? this.major_version + "." + this.minor_version : this.major_version;
            }
            catch (NumberFormatException nfe) {
                this.full_version = this.major_version;
            }
        }
    }

    public String getVersion() {
        StringBuffer sb = new StringBuffer("");
        if (this.product_name == null) {
            return null;
        }
        sb.append(this.product_name);
        if (this.version_prefix != null) {
            sb.append(" " + this.version_prefix);
        }
        if (this.full_version != null) {
            sb.append(this.full_version);
        }
        if (this.version_suffix != null) {
            sb.append(" " + this.version_suffix);
        }
        return sb.toString();
    }

    public String getFullVersion() {
        return this.getVersion() + " (build " + this.build_id + ")";
    }

    public String getAbbreviatedVersion() {
        return this.abbrev_product_name;
    }

    public String getMajorVersion() {
        return this.major_version;
    }

    public String getMinorVersion() {
        return this.minor_version;
    }

    public String getBuildVersion() {
        return this.build_id;
    }

    public String getVersionPrefix() {
        return this.version_prefix;
    }

    public String getVersionSuffix() {
        return this.version_suffix;
    }

    public String getProductName() {
        return this.product_name;
    }

    public String getAbbrevProductName() {
        return this.abbrev_product_name;
    }
}

