/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SSLConfig {
    public static final String TRUST_STORE_FILE = "javax.net.ssl.trustStore";
    public static final String KEY_STORE_FILE = "javax.net.ssl.keyStore";
    public static final String TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String TRUST_STORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    private static Logger logger = Logger.getLogger("grizzly");
    public static SSLConfig DEFAULT_CONFIG = new SSLConfig();
    private String trustStoreType;
    private String keyStoreType;
    private char[] trustStorePass;
    private char[] keyStorePass;
    private String trustStoreFile;
    private String keyStoreFile;
    private String trustStoreAlgorithm;
    private String keyStoreAlgorithm;
    private String securityProtocol;
    private boolean clientMode = false;
    private boolean needClientAuth = false;
    private boolean wantClientAuth = false;

    public SSLConfig() {
        this(true);
    }

    public SSLConfig(boolean readSystemProperties) {
        if (readSystemProperties) {
            this.retrieve(System.getProperties());
        }
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getTrustStorePass() {
        return new String(this.trustStorePass);
    }

    public void setTrustStorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass.toCharArray();
    }

    public String getKeyStorePass() {
        return new String(this.keyStorePass);
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass.toCharArray();
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getTrustStoreAlgorithm() {
        return this.trustStoreAlgorithm;
    }

    public void setTrustStoreAlgorithm(String trustStoreAlgorithm) {
        this.trustStoreAlgorithm = trustStoreAlgorithm;
    }

    public String getKeyStoreAlgorithm() {
        return this.keyStoreAlgorithm;
    }

    public void setKeyStoreAlgorithm(String keyStoreAlgorithm) {
        this.keyStoreAlgorithm = keyStoreAlgorithm;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public SSLContext createSSLContext() {
        SSLContext sslContext = null;
        try {
            TrustManagerFactory trustManagerFactory = null;
            KeyManagerFactory keyManagerFactory = null;
            if (this.trustStoreFile != null) {
                try {
                    KeyStore trustStore = KeyStore.getInstance(this.trustStoreType);
                    trustStore.load(new FileInputStream(this.trustStoreFile), this.trustStorePass);
                    trustManagerFactory = TrustManagerFactory.getInstance(this.trustStoreAlgorithm);
                    trustManagerFactory.init(trustStore);
                }
                catch (KeyStoreException e) {
                    logger.log(Level.FINE, "Error initializing trust store", e);
                }
                catch (CertificateException e) {
                    logger.log(Level.FINE, "Trust store certificate exception.", e);
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.FINE, "Can't find trust store file: " + this.trustStoreFile, e);
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "Error loading trust store from file: " + this.trustStoreFile, e);
                }
            }
            if (this.keyStoreFile != null) {
                try {
                    KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
                    keyStore.load(new FileInputStream(this.keyStoreFile), this.keyStorePass);
                    keyManagerFactory = KeyManagerFactory.getInstance(this.keyStoreAlgorithm);
                    keyManagerFactory.init(keyStore, this.keyStorePass);
                }
                catch (KeyStoreException e) {
                    logger.log(Level.FINE, "Error initializing key store", e);
                }
                catch (CertificateException e) {
                    logger.log(Level.FINE, "Key store certificate exception.", e);
                }
                catch (UnrecoverableKeyException e) {
                    logger.log(Level.FINE, "Key store unrecoverable exception.", e);
                }
                catch (FileNotFoundException e) {
                    logger.log(Level.FINE, "Can't find key store file: " + this.keyStoreFile, e);
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "Error loading key store from file: " + this.keyStoreFile, e);
                }
            }
            sslContext = SSLContext.getInstance(this.securityProtocol);
            sslContext.init(keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null, trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null, null);
        }
        catch (KeyManagementException e) {
            logger.log(Level.FINE, "Key management error.", e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.FINE, "Error initializing algorithm.", e);
        }
        return sslContext;
    }

    public void retrieve(Properties props) {
        this.trustStoreType = System.getProperty(TRUST_STORE_TYPE, "JKS");
        this.keyStoreType = System.getProperty(KEY_STORE_TYPE, "JKS");
        this.trustStorePass = System.getProperty(TRUST_STORE_PASSWORD, "changeit").toCharArray();
        this.keyStorePass = System.getProperty(KEY_STORE_PASSWORD, "changeit").toCharArray();
        this.trustStoreFile = System.getProperty(TRUST_STORE_FILE);
        this.keyStoreFile = System.getProperty(KEY_STORE_FILE);
        this.trustStoreAlgorithm = "SunX509";
        this.keyStoreAlgorithm = "SunX509";
        this.securityProtocol = "TLS";
    }

    public void publish(Properties props) {
        props.setProperty(TRUST_STORE_FILE, this.trustStoreFile);
        props.setProperty(KEY_STORE_FILE, this.keyStoreFile);
        props.setProperty(TRUST_STORE_PASSWORD, new String(this.trustStorePass));
        props.setProperty(KEY_STORE_PASSWORD, new String(this.keyStorePass));
        props.setProperty(TRUST_STORE_TYPE, this.trustStoreType);
        props.setProperty(KEY_STORE_TYPE, this.keyStoreType);
    }
}

