/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.util.ConcurrentLinkedQueuePool;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;

public class SelectionKeyOP {
    private int op;
    private SelectionKey key;
    private SelectableChannel channel;
    private static ConcurrentLinkedQueuePool<SelectionKeyOP> readWritePool = new ConcurrentLinkedQueuePool<SelectionKeyOP>(){

        public SelectionKeyOP newInstance() {
            return new SelectionKeyOP();
        }
    };
    private static ConcurrentLinkedQueuePool<SelectionKeyOP> connectPool = new ConcurrentLinkedQueuePool<SelectionKeyOP>(){

        public SelectionKeyOP newInstance() {
            return new ConnectSelectionKeyOP();
        }
    };

    public static SelectionKeyOP aquireSelectionKeyOP(int op) {
        if (op == 1 || op == 4 || op == 5) {
            SelectionKeyOP operation = (SelectionKeyOP)readWritePool.poll();
            return operation;
        }
        if (op == 8) {
            SelectionKeyOP operation = (SelectionKeyOP)connectPool.poll();
            return operation;
        }
        throw new IllegalStateException("Unknown operation or operation is not supported");
    }

    public static void releaseSelectionKeyOP(SelectionKeyOP operation) {
        int op = operation.op;
        operation.recycle();
        if (op == 1 || op == 4 || op == 5) {
            readWritePool.offer((Object)operation);
            return;
        }
        if (op == 8) {
            connectPool.offer((Object)operation);
            return;
        }
        throw new IllegalStateException("Unknown operation or operation is not supported");
    }

    private SelectionKeyOP() {
    }

    public int getOp() {
        return this.op;
    }

    public void setOp(int op) {
        this.op = op;
    }

    public SelectionKey getSelectionKey() {
        return this.key;
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    public SelectableChannel getChannel() {
        return this.channel;
    }

    public void setChannel(SelectableChannel channel) {
        this.channel = channel;
    }

    protected void recycle() {
        this.op = 0;
        this.key = null;
        this.channel = null;
    }

    public static class ConnectSelectionKeyOP
    extends SelectionKeyOP {
        private SocketAddress localAddress;
        private SocketAddress remoteAddress;
        private CallbackHandler callbackHandler;

        public SocketAddress getLocalAddress() {
            return this.localAddress;
        }

        public void setLocalAddress(SocketAddress localAddress) {
            this.localAddress = localAddress;
        }

        public SocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }

        public void setRemoteAddress(SocketAddress remoteAddress) {
            this.remoteAddress = remoteAddress;
        }

        public CallbackHandler getCallbackHandler() {
            return this.callbackHandler;
        }

        public void setCallbackHandler(CallbackHandler callbackHandler) {
            this.callbackHandler = callbackHandler;
        }

        protected void recycle() {
            this.localAddress = null;
            this.remoteAddress = null;
            this.callbackHandler = null;
        }
    }
}

