/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.services.impl;

import com.sun.enterprise.v3.services.impl.GlassfishProtocolChain;
import com.sun.enterprise.v3.services.impl.GrizzlyEmbeddedHttp;
import com.sun.enterprise.v3.services.impl.GrizzlyService;
import com.sun.enterprise.v3.services.impl.HttpParserState;
import com.sun.enterprise.v3.services.impl.HttpUtils;
import com.sun.enterprise.v3.services.impl.SnifferAdapter;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.http.DefaultProcessorTask;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.WorkerThread;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.buf.UDecoder;
import com.sun.grizzly.util.http.HttpRequestURIDecoder;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.grizzly.util.http.mapper.MappingData;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.internal.grizzly.V3Mapper;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerMapper
extends StaticResourcesAdapter {
    private static final String ROOT = "";
    private Mapper mapper;
    private GrizzlyEmbeddedHttp grizzlyEmbeddedHttp;
    private String defaultHostName = "server";
    private UDecoder urlDecoder = new UDecoder();
    private final Habitat habitat;
    private final GrizzlyService grizzlyService;
    private ConcurrentLinkedQueue<HttpParserState> parserStates;
    protected static final int MAPPING_DATA = 12;
    protected static final int MAPPED_ADAPTER = 13;
    private static byte[] errorBody = HttpUtils.getErrorPage("Glassfish/v3", "HTTP Status 404");

    public ContainerMapper(GrizzlyService grizzlyService, GrizzlyEmbeddedHttp grizzlyEmbeddedHttp) {
        this.grizzlyEmbeddedHttp = grizzlyEmbeddedHttp;
        this.grizzlyService = grizzlyService;
        this.habitat = grizzlyService.habitat;
        this.parserStates = new ConcurrentLinkedQueue();
        this.logger = GrizzlyEmbeddedHttp.logger();
        this.setRootFolder(GrizzlyEmbeddedHttp.getWebAppRootPath());
    }

    protected void setDefaultHost(String defaultHost) {
        this.defaultHostName = defaultHost;
    }

    protected void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    protected synchronized void configureMapper() {
        this.mapper.setDefaultHostName(this.defaultHostName);
        Mapper.setAllowReplacement(true);
    }

    @Override
    public void service(Request req, Response res) throws IOException {
        block14: {
            MappingData mappingData = null;
            try {
                MessageBytes decodedURI = req.decodedURI();
                decodedURI.duplicate(req.requestURI());
                mappingData = (MappingData)req.getNote(12);
                if (mappingData == null) {
                    mappingData = new MappingData();
                    req.setNote(12, mappingData);
                } else {
                    mappingData.recycle();
                }
                Adapter adapter = null;
                ByteChunk uriBB = decodedURI.getByteChunk();
                int start = uriBB.getStart();
                int end = uriBB.getEnd();
                int semicolon = uriBB.indexOf(';', 0);
                if (semicolon > 0) {
                    decodedURI.setBytes(uriBB.getBuffer(), uriBB.getStart(), semicolon);
                }
                HttpRequestURIDecoder.decode(decodedURI, this.urlDecoder, null, null);
                adapter = this.map(req, decodedURI, mappingData);
                if (adapter == null || adapter instanceof ContainerMapper) {
                    String ext = decodedURI.toString();
                    if (ext.indexOf(".") > 0) {
                        ext = "*" + ext.substring(ext.lastIndexOf("."));
                    }
                    this.initializeFileURLPattern(ext);
                    mappingData.recycle();
                    adapter = this.map(req, decodedURI, mappingData);
                }
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Request: " + decodedURI.toString() + " was mapped to Adapter: " + adapter);
                }
                if (adapter == null || adapter instanceof ContainerMapper) {
                    super.service(req, res);
                } else {
                    if (semicolon > 0 && end != 0) {
                        decodedURI.setBytes(uriBB.getBuffer(), start, end);
                    }
                    req.setNote(13, adapter);
                    adapter.service(req, res);
                }
            }
            catch (Exception ex) {
                try {
                    res.setStatus(404);
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, "Invalid URL: " + req.decodedURI(), ex);
                    }
                    this.customizedErrorPage(req, res);
                }
                catch (Exception ex2) {
                    if (!this.logger.isLoggable(Level.WARNING)) break block14;
                    this.logger.log(Level.WARNING, "Unable to error page", ex2);
                }
            }
        }
    }

    public synchronized void initializeFileURLPattern(String ext) {
        boolean match = false;
        for (Sniffer sniffer : this.grizzlyService.habitat.getAllByContract(Sniffer.class)) {
            if (sniffer.getURLPatterns() == null) continue;
            for (String pattern : sniffer.getURLPatterns()) {
                if (!pattern.equalsIgnoreCase(ext)) continue;
                match = true;
                break;
            }
            Adapter adapter = this;
            if (match) {
                adapter = (Adapter)this.grizzlyService.habitat.getComponent(SnifferAdapter.class);
                ((SnifferAdapter)adapter).initialize(sniffer, this);
                this.unregister(ROOT);
            }
            ContextRootInfo c = new ContextRootInfo(adapter, null, null);
            this.register(ROOT, this.grizzlyService.hosts, adapter, null, null);
            if (match) {
                for (String pattern : sniffer.getURLPatterns()) {
                    for (String host : this.grizzlyService.hosts) {
                        this.mapper.addWrapper(host, ROOT, pattern, c, "*.jsp".equals(pattern) || "*.jspx".equals(pattern));
                    }
                }
                continue;
            }
            for (String host : this.grizzlyService.hosts) {
                this.mapper.addWrapper(host, ROOT, ext, c, false);
            }
        }
    }

    Adapter map(Request req, MessageBytes decodedURI, MappingData mappingData) throws Exception {
        if (mappingData == null) {
            mappingData = (MappingData)req.getNote(12);
        }
        this.mapper.map(req.serverName(), decodedURI, mappingData);
        ContextRootInfo contextRootInfo = null;
        if (mappingData.context != null && mappingData.context instanceof ContextRootInfo) {
            contextRootInfo = (ContextRootInfo)mappingData.context;
            return contextRootInfo.getAdapter();
        }
        if (mappingData.context != null && mappingData.context.getClass().getName().equals("com.sun.enterprise.web.WebModule")) {
            return ((V3Mapper)this.mapper).getAdapter();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterService(Request req, Response res) throws Exception {
        try {
            Adapter adapter = (Adapter)req.getNote(13);
            if (adapter != null) {
                adapter.afterService(req, res);
            }
            super.afterService(req, res);
        }
        finally {
            req.setNote(13, null);
        }
    }

    @Override
    protected void customizedErrorPage(Request req, Response res) throws Exception {
        ByteChunk chunk = new ByteChunk();
        chunk.setBytes(errorBody, 0, errorBody.length);
        res.setContentLength(errorBody.length);
        res.sendHeaders();
        res.doWrite(chunk);
    }

    public void register(String contextRoot, Collection<String> vs, Adapter adapter, ApplicationContainer container, List<ProtocolFilter> contextProtocolFilters) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("MAPPER(" + this + ") REGISTER contextRoot: " + contextRoot + " adapter: " + adapter + " container: " + container + " port: " + this.grizzlyEmbeddedHttp.getPort());
        }
        if (adapter.getClass().getName().equals("org.apache.catalina.connector.CoyoteAdapter")) {
            return;
        }
        for (String host : vs) {
            this.mapper.addContext(host, contextRoot, new ContextRootInfo(adapter, container, contextProtocolFilters), new String[0], null);
        }
    }

    public void unregister(String contextRoot) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("MAPPER (" + this + ") UNREGISTER contextRoot: " + contextRoot);
        }
        for (String host : this.grizzlyService.hosts) {
            this.mapper.removeContext(host, contextRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean map(SelectionKey selectionKey, ByteBuffer byteBuffer, GlassfishProtocolChain protocolChain, List<ProtocolFilter> defaultProtocolFilters, ContextRootInfo fallbackContextRootInfo) throws Exception {
        List<ProtocolFilter> fallbackProtocolFilters;
        HttpParserState state = this.parserStates.poll();
        if (state == null) {
            state = new HttpParserState();
        } else {
            state.reset();
        }
        state.setBuffer(byteBuffer);
        byte[] contextBytes = null;
        byte[] hostBytes = null;
        try {
            contextBytes = HttpUtils.readRequestLine(selectionKey, state, InputReader.getDefaultReadTimeout());
            if (contextBytes != null) {
                state.setState(0);
                hostBytes = HttpUtils.readHost(selectionKey, state, InputReader.getDefaultReadTimeout());
            }
        }
        finally {
            this.parserStates.offer(state);
        }
        if (contextBytes == null) {
            return false;
        }
        MessageBytes decodedURI = MessageBytes.newInstance();
        decodedURI.setBytes(contextBytes, 0, contextBytes.length);
        MessageBytes hostMB = MessageBytes.newInstance();
        if (hostBytes != null) {
            hostMB.setBytes(hostBytes, 0, hostBytes.length);
        }
        try {
            HttpRequestURIDecoder.decode(decodedURI, this.urlDecoder, (String)this.grizzlyEmbeddedHttp.getProperty("uriEncoding"), null);
        }
        catch (Exception ex) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, "Invalid url", ex);
            }
            return false;
        }
        HttpUtils.parseHost(hostMB, ((SocketChannel)selectionKey.channel()).socket());
        MappingData mappingData = new MappingData();
        this.mapper.map(hostMB, decodedURI, mappingData);
        Adapter adapter = null;
        ContextRootInfo contextRootInfo = null;
        if (mappingData.context != null && mappingData.context instanceof ContextRootInfo) {
            contextRootInfo = (ContextRootInfo)mappingData.context;
            adapter = contextRootInfo.getAdapter();
        } else if (mappingData.context != null && mappingData.context.getClass().getName().equals("com.sun.enterprise.web.WebModule")) {
            MessageBytes fullDecodedUri = MessageBytes.newInstance();
            fullDecodedUri.duplicate(decodedURI);
            fullDecodedUri.toBytes();
            WorkerThread workerThread = (WorkerThread)Thread.currentThread();
            workerThread.getAttachment().setAttribute("mappingData", mappingData);
            workerThread.getAttachment().setAttribute("decodedURI", fullDecodedUri);
            adapter = ((V3Mapper)this.mapper).getAdapter();
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("MAP (" + this + ") contextRoot: " + new String(contextBytes) + " defaultProtocolFilters: " + defaultProtocolFilters + " fallback: " + fallbackContextRootInfo + " adapter: " + adapter + " mappingData.context " + mappingData.context);
        }
        if (adapter == null && fallbackContextRootInfo != null) {
            adapter = fallbackContextRootInfo.getAdapter();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Fallback adapter is taken: " + adapter);
            }
        }
        if (adapter == null) {
            return false;
        }
        this.bindAdapter(adapter);
        List<ProtocolFilter> filtersToInject = null;
        if (contextRootInfo != null && contextRootInfo.getContainer() != null) {
            List<ProtocolFilter> contextRootProtocolFilters = contextRootInfo.getProtocolFilters();
            List<ProtocolFilter> list = filtersToInject = contextRootProtocolFilters != null ? contextRootProtocolFilters : defaultProtocolFilters;
            if (filtersToInject != null) {
                protocolChain.setDynamicProtocolFilters(filtersToInject);
            }
        } else if (fallbackContextRootInfo != null && (fallbackProtocolFilters = fallbackContextRootInfo.getProtocolFilters()) != null && !fallbackProtocolFilters.isEmpty()) {
            protocolChain.setDynamicProtocolFilters(fallbackProtocolFilters);
        }
        return true;
    }

    private Adapter bindAdapter(Adapter adapter) {
        this.bindProcessorTask(adapter);
        return adapter;
    }

    private void bindProcessorTask(Adapter adapter) {
        HttpWorkerThread workerThread = (HttpWorkerThread)Thread.currentThread();
        DefaultProcessorTask processorTask = (DefaultProcessorTask)workerThread.getProcessorTask();
        if (processorTask == null) {
            try {
                processorTask = (DefaultProcessorTask)this.grizzlyEmbeddedHttp.getProcessorTask();
            }
            catch (ClassCastException ex) {
                this.logger.log(Level.SEVERE, "Invalid ProcessorTask instance", ex);
            }
            workerThread.setProcessorTask(processorTask);
        }
        processorTask.setAdapter(adapter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContextRootInfo {
        protected Adapter adapter;
        protected ApplicationContainer container;
        protected List<ProtocolFilter> protocolFilters;

        public ContextRootInfo() {
        }

        public ContextRootInfo(Adapter adapter, ApplicationContainer container, List<ProtocolFilter> protocolFilters) {
            this.adapter = adapter;
            this.container = container;
            this.protocolFilters = protocolFilters;
        }

        public Adapter getAdapter() {
            return this.adapter;
        }

        public void setAdapter(Adapter adapter) {
            this.adapter = adapter;
        }

        public ApplicationContainer getContainer() {
            return this.container;
        }

        public void setContainer(ApplicationContainer container) {
            this.container = container;
        }

        public List<ProtocolFilter> getProtocolFilters() {
            return this.protocolFilters;
        }

        public void setProtocolFilters(List<ProtocolFilter> protocolFilters) {
            this.protocolFilters = protocolFilters;
        }
    }
}

