/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.http.KeepAliveStats;
import com.sun.grizzly.http.Task;
import com.sun.grizzly.http.ThreadPoolStatistic;
import java.nio.channels.SelectionKey;
import java.util.concurrent.ConcurrentHashMap;

public class KeepAliveCountManager {
    public static final int KEEP_ALIVE_RULE = 0;
    private int maxThreads = 1;
    private int priority = 5;
    private int port = 8080;
    private String name;
    private boolean isStarted = false;
    private int firstReadTimeout = 30;
    private int keepAliveTimeoutInSeconds = 30;
    protected ConcurrentHashMap<SelectionKey, Integer> keepAliveCounts;
    protected int maxKeepAliveRequests = -1;
    protected ThreadPoolStatistic threadPoolStat;
    private KeepAliveStats keepAliveStats;

    public KeepAliveCountManager() {
        this.initPipeline();
    }

    public void initPipeline() {
        if (this.isStarted) {
            return;
        }
        this.isStarted = true;
        this.keepAliveCounts = new ConcurrentHashMap();
    }

    public void startPipeline() {
        if (this.isStarted) {
            return;
        }
    }

    public void stopPipeline() {
        if (!this.isStarted) {
            return;
        }
        this.isStarted = false;
        this.keepAliveCounts.clear();
    }

    public void addTask(Task task) {
        throw new UnsupportedOperationException();
    }

    public Task getTask() {
        return null;
    }

    public int size() {
        return 0;
    }

    public int getWaitingThread() {
        return 0;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public int getCurrentThreadCount() {
        return 1;
    }

    public int getCurrentThreadsBusy() {
        return 1;
    }

    public int getMaxSpareThreads() {
        return 0;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name + this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMinThreads(int minThreads) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "name: " + this.name + " maxThreads: " + this.maxThreads;
    }

    public void setQueueSizeInBytes(int maxQueueSizeInBytes) {
        throw new UnsupportedOperationException();
    }

    public void setThreadsIncrement(int threadsIncrement) {
        throw new UnsupportedOperationException();
    }

    public void setThreadsTimeout(int threadsTimeout) {
        this.firstReadTimeout = threadsTimeout;
    }

    public int getMinSpareThreads() {
        throw new UnsupportedOperationException();
    }

    public void setMinSpareThreads(int minSpareThreads) {
        throw new UnsupportedOperationException();
    }

    public boolean trap(SelectionKey key) {
        if (this.maxKeepAliveRequests == -1) {
            return true;
        }
        Integer count = this.keepAliveCounts.get(key);
        if (count == null) {
            count = 0;
            if (this.keepAliveStats != null) {
                this.keepAliveStats.incrementCountConnections();
            }
        }
        if ((count = Integer.valueOf(count + 1)) > this.maxKeepAliveRequests) {
            if (this.keepAliveStats != null) {
                this.keepAliveStats.incrementCountRefusals();
            }
            return false;
        }
        this.keepAliveCounts.put(key, count);
        if (this.keepAliveStats != null) {
            this.keepAliveStats.incrementCountHits();
        }
        return true;
    }

    public void untrap(SelectionKey key) {
        if (this.maxKeepAliveRequests == -1) {
            return;
        }
        Integer count = this.keepAliveCounts.remove(key);
        if (this.keepAliveStats != null && count != null) {
            this.keepAliveStats.decrementCountConnections();
        }
    }

    public int getMaxKeepAliveRequests() {
        return this.maxKeepAliveRequests;
    }

    public void setMaxKeepAliveRequests(int maxKeepAliveRequests) {
        this.maxKeepAliveRequests = maxKeepAliveRequests;
    }

    public void setKeepAliveTimeoutInSeconds(int keepAliveTimeout) {
        this.keepAliveTimeoutInSeconds = keepAliveTimeout;
    }

    public int getKeepAliveTimeoutInSeconds() {
        return this.keepAliveTimeoutInSeconds;
    }

    public boolean dropConnection() {
        return this.keepAliveTimeoutInSeconds == 0 || this.firstReadTimeout == 0 || this.maxKeepAliveRequests == 0;
    }

    public void setThreadPoolStatistic(ThreadPoolStatistic threadPoolStatistic) {
        this.threadPoolStat = threadPoolStatistic;
    }

    public ThreadPoolStatistic getThreadPoolStatistic() {
        return this.threadPoolStat;
    }

    public void setKeepAliveStats(KeepAliveStats keepAliveStats) {
        this.keepAliveStats = keepAliveStats;
    }

    public boolean interruptThread(long threadId) {
        return false;
    }
}

