/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.server.logging.LoggingConfig;
import com.sun.enterprise.server.logging.LoggingXMLNames;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class LoggingConfigImpl
implements LoggingConfig,
PostConstruct {
    @Inject
    Logger logger;
    @Inject
    ServerEnvironmentImpl env;
    Properties props = null;
    FileInputStream fis;
    String loggingPropertiesName;
    LogManager logMgr = null;

    public void postConstruct() {
        this.logMgr = LogManager.getLogManager();
        this.loggingPropertiesName = "logging.properties";
    }

    private void openPropFile() throws IOException {
        try {
            this.fis = new FileInputStream(new File(this.env.getConfigDirPath(), this.loggingPropertiesName));
            this.props = new Properties();
            this.props.load(this.fis);
            this.fis.close();
        }
        catch (FileNotFoundException e) {
            this.logger.log(Level.SEVERE, "Cannot read logging.properties file : ", e);
            throw new IOException();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Cannot read logging.properties file : ", e);
            throw new IOException();
        }
    }

    private void closePropFile() throws IOException {
        try {
            FileOutputStream ois = new FileOutputStream(new File(this.env.getConfigDirPath(), this.loggingPropertiesName));
            this.props.store(ois, "GlassFish logging.properties list");
            ois.close();
        }
        catch (FileNotFoundException e) {
            this.logger.log(Level.SEVERE, "Cannot close logging.properties file : ", e);
            throw new IOException();
        }
        catch (IOException e) {
            System.out.println("some other exception");
            this.logger.log(Level.SEVERE, "Cannot close logging.properties file : ", e);
            throw new IOException();
        }
    }

    @Override
    public String setLoggingProperty(String propertyName, String propertyValue) throws IOException {
        this.openPropFile();
        if (propertyValue == null) {
            return null;
        }
        String key = LoggingXMLNames.xmltoPropsMap.get(propertyName);
        if (key == null) {
            key = propertyName;
        }
        String property = (String)this.props.setProperty(key, propertyValue);
        this.closePropFile();
        return property;
    }

    @Override
    public Map<String, String> updateLoggingProperties(Map<String, String> properties) throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            this.openPropFile();
            String key = null;
            for (Map.Entry<String, String> e : properties.entrySet()) {
                if (e.getValue() == null) continue;
                key = LoggingXMLNames.xmltoPropsMap.get(e.getKey());
                if (key == null) {
                    key = e.getKey();
                }
                String property = (String)this.props.setProperty(key, e.getValue());
                m.put(key, property);
            }
            this.closePropFile();
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return m;
    }

    @Override
    public Map<String, String> getLoggingProperties() throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        this.openPropFile();
        Enumeration<?> e = this.props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (LoggingXMLNames.xmltoPropsMap.get(key) != null) {
                key = LoggingXMLNames.xmltoPropsMap.get(key);
            }
            m.put(key, this.props.getProperty(key));
        }
        this.closePropFile();
        return m;
    }

    @Override
    public void removeLoggingProperties(Set<String> properties) throws IOException {
        this.openPropFile();
        Iterator<String> i = properties.iterator();
        while (i.hasNext()) {
            try {
                String p = i.next();
                this.logger.log(Level.FINER, "Remove from logging.properties file property ", p);
                this.props.remove(p);
            }
            catch (NoSuchElementException e) {
                this.logger.log(Level.WARNING, "Attempt to remove nonexistent property ", e);
            }
        }
        this.closePropFile();
        try {
            this.logMgr.readConfiguration();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Cannot reconfigure LogManager : ", e);
            throw new IOException();
        }
    }
}

