/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deploy.shared;

import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.loader.util.ASClassLoaderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArchiveHandler
implements ArchiveHandler {
    protected final Logger _logger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expand(ReadableArchive source, WritableArchive target, DeploymentContext context) throws IOException {
        Enumeration e = source.entries();
        while (e.hasMoreElements()) {
            String entryName = (String)e.nextElement();
            BufferedInputStream is = new BufferedInputStream(source.getEntry(entryName));
            OutputStream os = null;
            try {
                os = target.putNextEntry(entryName);
                FileUtils.copy((InputStream)is, (OutputStream)os, (long)source.getEntrySize(entryName));
            }
            finally {
                if (os != null) {
                    target.closeEntry();
                }
                ((InputStream)is).close();
            }
        }
        Manifest m = source.getManifest();
        if (m != null) {
            OutputStream os = target.putNextEntry("META-INF/MANIFEST.MF");
            m.write(os);
            target.closeEntry();
        }
    }

    public String getDefaultApplicationName(ReadableArchive archive) {
        String appName = archive.getName();
        int lastDot = appName.lastIndexOf(46);
        if (lastDot != -1 && appName.substring(lastDot).equalsIgnoreCase("." + this.getArchiveType())) {
            appName = appName.substring(0, lastDot);
        }
        return appName;
    }

    public Manifest getManifest(ReadableArchive archive) throws IOException {
        return archive.getManifest();
    }

    public List<URL> getManifestLibraries(DeploymentContext context) {
        try {
            Manifest manifest = this.getManifest(context.getSource());
            return ASClassLoaderUtil.getManifestClassPathAsURLs(manifest, context.getSourceDir().getParent());
        }
        catch (IOException ioe) {
            this._logger.log(Level.WARNING, "Exception while getting manifest classpath: ", ioe);
            return new ArrayList<URL>();
        }
    }
}

