/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.loader.util;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASClassLoaderUtil {
    private static final Logger _logger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");
    private static String modulesClassPath = null;
    private static final String MANIFEST_ENTRY = "META-INF" + File.separator + "MANIFEST.MF";

    public static String getModuleClassPath(Habitat habitat, String moduleId, String deploymentLibs) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ASClassLoaderUtil.getModuleClassPath for module Id : " + moduleId);
        }
        StringBuilder classpath = new StringBuilder(ASClassLoaderUtil.getModulesClasspath(habitat));
        ClassLoaderHierarchy clh = (ClassLoaderHierarchy)habitat.getByContract(ClassLoaderHierarchy.class);
        String commonClassPath = clh.getCommonClassPath();
        if (commonClassPath != null && commonClassPath.length() > 0) {
            classpath.append(commonClassPath).append(File.pathSeparator);
        }
        ASClassLoaderUtil.addDeployTimeLibrariesForModule(classpath, moduleId, deploymentLibs, habitat);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Final classpath: " + classpath.toString());
        }
        return classpath.toString();
    }

    public static String getModuleClassPath(Habitat habitat, DeploymentContext context) {
        DeployCommandParameters params = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        return ASClassLoaderUtil.getModuleClassPath(habitat, params.name(), params.libraries());
    }

    private static void addDeployTimeLibrariesForModule(StringBuilder sb, String moduleId, String deploymentLibs, Habitat habitat) {
        URL[] libs;
        if (deploymentLibs == null) {
            ApplicationInfo appInfo = ((ApplicationRegistry)habitat.getComponent(ApplicationRegistry.class)).get(moduleId);
            if (appInfo == null) {
                return;
            }
            deploymentLibs = appInfo.getLibraries();
        }
        if ((libs = ASClassLoaderUtil.getLibrariesAsURLs(deploymentLibs, habitat)) != null) {
            for (URL u : libs) {
                sb.append(u.getPath());
                sb.append(File.pathSeparator);
            }
        }
    }

    private static URL[] getLibrariesAsURLs(String librariesStr, Habitat habitat) {
        return ASClassLoaderUtil.getLibrariesAsURLs(librariesStr, (ServerEnvironment)habitat.getComponent(ServerEnvironment.class));
    }

    public static URL[] getLibrariesAsURLs(String librariesStr, ServerEnvironment env) {
        if (librariesStr == null) {
            return null;
        }
        String[] librariesStrArray = librariesStr.split(",");
        if (librariesStrArray == null) {
            return null;
        }
        URL[] urls = new URL[librariesStrArray.length];
        String appLibsDir = env.getLibPath() + File.separator + "applibs";
        int i = 0;
        for (String libraryStr : librariesStrArray) {
            try {
                File f = new File(libraryStr);
                if (!f.isAbsolute()) {
                    f = new File(appLibsDir, libraryStr);
                }
                URL url = f.toURI().toURL();
                urls[i++] = url;
            }
            catch (MalformedURLException malEx) {
                _logger.log(Level.WARNING, "Cannot convert classpath to URL", libraryStr);
                _logger.log(Level.WARNING, malEx.getMessage(), malEx);
            }
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized String getModulesClasspath(Habitat habitat) {
        Class<ASClassLoaderUtil> clazz = ASClassLoaderUtil.class;
        synchronized (ASClassLoaderUtil.class) {
            if (modulesClassPath == null) {
                StringBuilder tmpString = new StringBuilder();
                ModulesRegistry mr = (ModulesRegistry)habitat.getComponent(ModulesRegistry.class);
                if (mr != null) {
                    for (Module module : mr.getModules()) {
                        for (URI uri : module.getModuleDefinition().getLocations()) {
                            tmpString.append(uri.getPath());
                            tmpString.append(File.pathSeparator);
                        }
                    }
                }
                modulesClassPath = tmpString.toString();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return modulesClassPath;
        }
    }

    public static URL[] getURLs(File[] dirs, File[] jarDirs, boolean ignoreZip) throws IOException {
        int i;
        URL[] urls = new URL[]{};
        ArrayList<URL> list = new ArrayList<URL>();
        if (dirs != null) {
            for (i = 0; i < dirs.length; ++i) {
                File dir = dirs[i];
                if (!dir.isDirectory() && !dir.canRead()) continue;
                URL url = dir.toURI().toURL();
                list.add(url);
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, "Adding directory to class path:" + url.toString());
            }
        }
        if (jarDirs != null) {
            for (i = 0; i < jarDirs.length; ++i) {
                File jarDir = jarDirs[i];
                if (!jarDir.isDirectory() && !jarDir.canRead()) continue;
                File[] files = jarDir.listFiles();
                for (int j = 0; j < files.length; ++j) {
                    File jar = files[j];
                    if (!FileUtils.isJar((File)jar) && (ignoreZip || !FileUtils.isZip((File)jar))) continue;
                    list.add(jar.toURI().toURL());
                    if (!_logger.isLoggable(Level.FINE)) continue;
                    _logger.log(Level.FINE, "Adding jar to class path:" + jar.toURL());
                }
            }
        }
        if (list.size() > 0) {
            urls = new URL[list.size()];
            urls = list.toArray(urls);
        }
        return urls;
    }

    public static List<URL> getURLsFromClasspath(String classpath, String delimiter, String rootPath) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (classpath == null || classpath.length() == 0) {
            return urls;
        }
        StringTokenizer st = new StringTokenizer(classpath, delimiter);
        while (st.hasMoreTokens()) {
            try {
                String path = st.nextToken();
                if (rootPath != null && rootPath.length() != 0) {
                    path = rootPath + File.separator + path;
                }
                File f = new File(path);
                urls.add(f.toURI().toURL());
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "unexpected error in getting urls", e);
            }
        }
        return urls;
    }

    public static List<URL> getManifestClassPathAsURLs(Manifest manifest, String rootPath) {
        List<URL> urlList = new ArrayList<URL>();
        if (manifest != null) {
            Attributes mainAttributes = manifest.getMainAttributes();
            for (Attributes.Name name : mainAttributes.keySet()) {
                if (!name.equals(Attributes.Name.CLASS_PATH)) continue;
                String classpathString = (String)mainAttributes.get(name);
                urlList = ASClassLoaderUtil.getURLsFromClasspath(classpathString, " ", rootPath);
            }
        }
        return urlList;
    }
}

