/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.payload;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.glassfish.admin.payload.TextPayloadImpl;
import org.glassfish.admin.payload.ZipPayloadImpl;
import org.glassfish.api.admin.Payload;

public class PayloadImpl
implements Payload {

    public static abstract class Part
    implements Payload.Part {
        private String name;
        private String contentType;
        private Properties props;

        Part(String contentType, String name, Properties props) {
            this.contentType = contentType;
            this.name = name;
            this.props = new Properties();
            if (props != null) {
                this.props.putAll((Map<?, ?>)props);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getContentType() {
            return this.contentType;
        }

        public Properties getProperties() {
            return this.props;
        }

        public static Part newInstance(String contentType, String name, Properties props, InputStream is) {
            return new Streamed(contentType, name, props, is);
        }

        public static Part newInstance(String contentType, String name, Properties props, String content) {
            return new Buffered(contentType, name, props, content);
        }

        public void copy(OutputStream os) throws IOException {
            int bytesRead;
            byte[] buffer = new byte[1024];
            InputStream is = this.getInputStream();
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }

        static class Buffered
        extends Part {
            private final String content;
            private InputStream is = null;

            Buffered(String contentType, String name, Properties props, String content) {
                super(contentType, name, props);
                this.content = content;
            }

            public InputStream getInputStream() {
                if (this.is == null) {
                    this.is = new ByteArrayInputStream(this.content.getBytes());
                }
                return this.is;
            }
        }

        static class Streamed
        extends Part {
            private final InputStream is;

            Streamed(String contentType, String name, Properties props, InputStream is) {
                super(contentType, name, props);
                this.is = is;
            }

            public InputStream getInputStream() {
                return this.is;
            }
        }
    }

    public static abstract class Inbound
    implements Payload.Inbound {
        private static final Inbound EMPTY_PAYLOAD = new Inbound(){

            public Iterator<Payload.Part> parts() {
                return Collections.EMPTY_LIST.iterator();
            }
        };

        public static Inbound newInstance(String payloadContentType, InputStream is) throws IOException {
            if (payloadContentType == null) {
                return EMPTY_PAYLOAD;
            }
            if (payloadContentType.startsWith("text")) {
                return TextPayloadImpl.Inbound.newInstance(payloadContentType, is);
            }
            return ZipPayloadImpl.Inbound.newInstance(payloadContentType, is);
        }

        public String getHeaderName() {
            return "org.glassfish.payload.admin.data";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Outbound
    implements Payload.Outbound {
        private final ArrayList<Payload.Part> parts = new ArrayList();

        public void addPart(String contentType, String name, Properties props, String content) throws IOException {
            this.parts.add(Part.newInstance(contentType, name, props, content));
        }

        public void addPart(String contentType, String name, Properties props, InputStream content) throws IOException {
            this.parts.add(Part.newInstance(contentType, name, props, content));
        }

        public void addPart(int index, String contentType, String name, Properties props, InputStream content) throws IOException {
            this.parts.add(index, Part.newInstance(contentType, name, props, content));
        }

        public void attachFile(String contentType, URI fileURI, String dataRequestName, File file) throws IOException {
            this.attachFile(contentType, fileURI, dataRequestName, file);
        }

        public void attachFile(String contentType, URI fileURI, String dataRequestName, Properties props, File file) throws IOException {
            Properties enhancedProps = new Properties();
            if (props != null) {
                enhancedProps.putAll((Map<?, ?>)props);
            }
            enhancedProps.setProperty("data-request-type", "file-xfer");
            enhancedProps.setProperty("data-request-name", dataRequestName);
            enhancedProps.setProperty("last-modified", Long.toString(file.lastModified()));
            this.parts.add(Part.newInstance(contentType, fileURI.getPath(), enhancedProps, new BufferedInputStream(new FileInputStream(file))));
        }

        public String getHeaderName() {
            return "org.glassfish.payload.admin.data";
        }

        public String getContentType() {
            return this.isComplex() ? this.getComplexContentType() : this.getSinglePartContentType();
        }

        ArrayList<Payload.Part> getParts() {
            return this.parts;
        }

        abstract void writePartsTo(OutputStream var1) throws IOException;

        public void writeTo(OutputStream os) throws IOException {
            if (this.isComplex()) {
                this.writePartsTo(os);
            } else {
                this.parts.get(0).copy(os);
            }
        }

        public abstract String getComplexContentType();

        private boolean isComplex(String partType) {
            return this.parts.size() > 1 || !partType.startsWith("text");
        }

        private boolean isComplex() {
            return this.isComplex(this.parts.get(0).getContentType());
        }

        String getSinglePartContentType() {
            String partType = this.parts.get(0).getContentType();
            if (this.isComplex(partType)) {
                return this.getComplexContentType();
            }
            return partType;
        }

        public static Outbound newInstance() {
            return ZipPayloadImpl.Outbound.newInstance();
        }
    }
}

