/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.grizzly;

import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.util.http.mapper.Mapper;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractProvided(value=Mapper.class)
public class V3Mapper
extends Mapper {
    private static final String ADMIN_LISTENER = "admin-listener";
    private static final String ADMIN_VS = "__asadmin";
    private final Logger logger;
    private Adapter adapter;
    private String id;

    public V3Mapper() {
        this(Logger.getAnonymousLogger());
    }

    public V3Mapper(Logger logger) {
        this.logger = logger;
    }

    public void addWrapper(String hostName, String contextPath, String path, Object wrapper, boolean jspWildCard) {
        super.addWrapper(hostName, contextPath, path, wrapper, jspWildCard);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Wrapper-Host: " + hostName + " contextPath " + contextPath + " wrapper " + wrapper + " path " + path + " jspWildcard " + jspWildCard);
        }
    }

    public synchronized void addHost(String name, String[] aliases, Object host) {
        if (ADMIN_LISTENER.equals(this.id) && !ADMIN_VS.equals(name) || !ADMIN_LISTENER.equals(this.id) && ADMIN_VS.equals(name)) {
            return;
        }
        super.addHost(name, aliases, host);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Host-Host: " + name + " aliases " + aliases + " host " + host);
        }
    }

    public void addContext(String hostName, String path, Object context, String[] welcomeResources, Context resources) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Context-Host: " + hostName + " path " + path + " context " + context + " port " + this.getPort());
        }
        if (ADMIN_LISTENER.equals(this.id) && !ADMIN_VS.equals(hostName) || !ADMIN_LISTENER.equals(this.id) && ADMIN_VS.equals(hostName)) {
            return;
        }
        if (this.adapter != null && this.adapter.getClass().getName().equals("org.apache.catalina.connector.CoyoteAdapter")) {
            super.removeContext(hostName, path);
        }
        super.addContext(hostName, path, context, welcomeResources, resources);
    }

    public synchronized void removeHost(String name) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Faking removal of host: " + name);
        }
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public void setId(String id) {
        this.id = id;
    }
}

