/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.AuditModule;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.util.List;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.Property;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-audit-module")
@Scoped(value=PerLookup.class)
@I18n(value="create.audit.module")
public class CreateAuditModule
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateAuditModule.class);
    @Param(name="classname")
    String className;
    @Param(name="auditmodulename", primary=true)
    String auditModuleName;
    @Param(optional=true, name="property")
    Properties properties;
    @Param(optional=true)
    String target;
    @Inject
    Configs configs;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        List configList = this.configs.getConfig();
        Config config = (Config)configList.get(0);
        SecurityService securityService = config.getSecurityService();
        List ams = securityService.getAuditModule();
        for (AuditModule am : ams) {
            if (!am.getName().equals(this.auditModuleName)) continue;
            report.setMessage(localStrings.getLocalString("create.audit.module.duplicatefound", "AuditModule named {0} exists. Cannot add duplicate AuditModule.", new Object[]{this.auditModuleName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SecurityService>(){

                public Object run(SecurityService param) throws PropertyVetoException, TransactionFailure {
                    AuditModule newAuditModule = (AuditModule)param.createChild(AuditModule.class);
                    CreateAuditModule.this.populateAuditModuleElement(newAuditModule);
                    param.getAuditModule().add(newAuditModule);
                    return newAuditModule;
                }
            }, (ConfigBeanProxy)securityService);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.audit.module.fail", "Creation of AuditModule {0} failed", new Object[]{this.auditModuleName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        report.setMessage(localStrings.getLocalString("create.audit.module.success", "Creation of AuditModule {0} completed successfully", new Object[]{this.auditModuleName}));
    }

    private void populateAuditModuleElement(AuditModule newAuditModule) throws PropertyVetoException, TransactionFailure {
        newAuditModule.setName(this.auditModuleName);
        newAuditModule.setClassname(this.className);
        if (this.properties != null) {
            for (Object propname : this.properties.keySet()) {
                Property newprop = (Property)newAuditModule.createChild(Property.class);
                newprop.setName((String)propname);
                newprop.setValue(this.properties.getProperty((String)propname));
                newAuditModule.getProperty().add(newprop);
            }
        }
    }
}

