/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationConfig;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.server.AppServerStartup;
import com.sun.enterprise.v3.server.CompositeArchive;
import com.sun.enterprise.v3.server.ContainerStarter;
import com.sun.enterprise.v3.server.SnifferManagerImpl;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.Property;
import org.glassfish.api.container.Container;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.ApplicationMetaDataProvider;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.CompositeHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.ComponentException;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Scoped(value=Singleton.class)
public class ApplicationLifecycle
implements Deployment {
    @Inject
    protected SnifferManagerImpl snifferManager;
    @Inject
    Habitat habitat;
    @Inject
    ContainerRegistry containerRegistry;
    @Inject
    public ApplicationRegistry appRegistry;
    @Inject
    ModulesRegistry modulesRegistry;
    @Inject
    protected ArchiveFactory archiveFactory;
    @Inject
    protected Applications applications;
    @Inject
    protected Domain domain;
    @Inject(name="default-instance-name")
    protected Server server;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    protected ClassLoaderHierarchy clh;
    @Inject
    Events events;
    protected Logger logger = LogDomains.getLogger(AppServerStartup.class, (String)"javax.enterprise.system.core");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ApplicationLifecycle.class);
    private static final String IS_COMPOSITE = "isComposite";

    protected <T extends Container, U extends ApplicationContainer> Deployer<T, U> getDeployer(EngineInfo<T, U> engineInfo) {
        return engineInfo.getDeployer();
    }

    public ArchiveHandler getArchiveHandler(ReadableArchive archive) throws IOException {
        for (CompositeHandler handler : this.habitat.getAllByContract(CompositeHandler.class)) {
            if (!handler.handles(archive)) continue;
            return handler;
        }
        for (CompositeHandler handler : this.habitat.getAllByContract(ArchiveHandler.class)) {
            if (handler instanceof CompositeHandler || "DEFAULT".equals(handler.getClass().getAnnotation(Service.class).name()) || !handler.handles(archive)) continue;
            return handler;
        }
        return (ArchiveHandler)this.habitat.getComponent(ArchiveHandler.class, "DEFAULT");
    }

    public ApplicationInfo deploy(ExtendedDeploymentContext context, ActionReport report) {
        return this.deploy(null, context, report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApplicationInfo deploy(Collection<Sniffer> sniffers, final ExtendedDeploymentContext context, final ActionReport report) {
        block29: {
            block28: {
                this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_START, (Object)context));
                tracker = new ProgressTracker(){

                    public void actOn(Logger logger) {
                        for (EngineRef module : this.get("started", EngineRef.class)) {
                            module.stop((ApplicationContext)context, logger);
                        }
                        for (EngineRef module : this.get("loaded", EngineRef.class)) {
                            module.unload(context, report);
                        }
                        for (EngineRef module : this.get("prepared", EngineRef.class)) {
                            module.clean(context, logger);
                        }
                    }
                };
                commandParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
                context.setPhase(ExtendedDeploymentContext.Phase.PREPARE);
                appInfo = null;
                handler = context.getArchiveHandler();
                if (handler == null) {
                    handler = this.getArchiveHandler(context.getSource());
                    context.setArchiveHandler(handler);
                }
                if (handler != null) ** GOTO lbl28
                report.setMessage(ApplicationLifecycle.localStrings.getLocalString("unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{context.getSource()}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                var8_9 = null;
                if (appInfo == null) {
                }
                ** GOTO lbl26
                {
                    catch (Exception e) {
                        report.failure(this.logger, "Exception while deploying the app", (Throwable)e);
                        tracker.actOn(this.logger);
                        return null;
                    }
                    catch (Throwable var17_23) {
                        throw var17_23;
                    }
                    this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_FAILURE, (Object)context));
                    return var8_9;
lbl26:
                    // 1 sources

                    this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_SUCCESS, appInfo));
                    return var8_9;
lbl28:
                    // 1 sources

                    context.createClassLoaders(this.clh, handler);
                    cloader = context.getClassLoader();
                    currentCL = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(cloader);
                        sortedEngineInfos = this.setupContainerInfos(handler, sniffers, (DeploymentContext)context, report);
                        if (sortedEngineInfos == null || sortedEngineInfos.isEmpty()) {
                            report.failure(this.logger, ApplicationLifecycle.localStrings.getLocalString("unknowncontainertype", "There is no installed container capable of handling this application {0}", new Object[]{context.getSource()}));
                            tracker.actOn(this.logger);
                            var11_13 = null;
                            Thread.currentThread().setContextClassLoader(currentCL);
                            if (appInfo != null) break block28;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var16_22) {}
                    {
                        Thread.currentThread().setContextClassLoader(currentCL);
                        throw var16_22;
                    }
                }
                this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_FAILURE, (Object)context));
                return var11_13;
            }
            this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_SUCCESS, (Object)appInfo));
            return var11_13;
lbl-1000:
            // 1 sources

            {
                appName = commandParams.name();
                appInfo = this.appRegistry.get(appName);
                v0 = alreadyRegistered = appInfo != null;
                if (alreadyRegistered) ** GOTO lbl77
                moduleInfo = null;
                try {
                    moduleInfo = this.prepareModule(sortedEngineInfos, appName, (DeploymentContext)context, report, tracker);
                }
                catch (Exception prepareException) {
                    report.failure(this.logger, "Exception while preparing the app");
                    tracker.actOn(this.logger);
                    var15_20 = null;
                    Thread.currentThread().setContextClassLoader(currentCL);
                    if (appInfo == null) {
                        this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_FAILURE, (Object)context));
                        return var15_20;
                    }
                    this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_SUCCESS, (Object)appInfo));
                    return var15_20;
                }
            }
            {
                block30: {
                    appInfo = (ApplicationInfo)context.getModuleMetaData(ApplicationInfo.class);
                    if (appInfo == null) {
                        appInfo = new ApplicationInfo(this.events, context.getSource(), appName);
                        appInfo.addModule(moduleInfo);
                        for (E m : context.getModuleMetadata()) {
                            appInfo.addMetaData(m);
                        }
                    }
                    this.appRegistry.add(appName, appInfo);
                    break block30;
lbl77:
                    // 1 sources

                    context.addModuleMetaData((Object)appInfo);
                }
                if (this.events != null) {
                    this.events.send(new EventListener.Event(Deployment.APPLICATION_PREPARED, (Object)context), false);
                }
                if (!commandParams.enabled.booleanValue()) ** GOTO lbl-1000
                appInfo.setLibraries(commandParams.libraries());
                try {
                    appInfo.load(context, report, tracker);
                    appInfo.start((DeploymentContext)context, report, tracker);
                }
                catch (Exception loadException) {
                    report.failure(this.logger, "Exception while loading the app", (Throwable)loadException);
                    tracker.actOn(this.logger);
                    if (!alreadyRegistered) {
                        this.appRegistry.remove(appName);
                    }
                    var14_19 = null;
                    Thread.currentThread().setContextClassLoader(currentCL);
                    if (appInfo == null) {
                        this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_FAILURE, (Object)context));
                        return var14_19;
                    }
                    this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_SUCCESS, (Object)appInfo));
                    return var14_19;
                }
            }
lbl-1000:
            // 2 sources

            {
                var13_16 = appInfo;
                Thread.currentThread().setContextClassLoader(currentCL);
                if (appInfo != null) break block29;
            }
            this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_FAILURE, (Object)context));
            return var13_16;
        }
        this.events.send(new EventListener.Event(Deployment.DEPLOYMENT_SUCCESS, (Object)appInfo));
        return var13_16;
    }

    public boolean suspend(String appName) {
        boolean isSuccess = true;
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            isSuccess = appInfo.suspend(this.logger);
        }
        return isSuccess;
    }

    public boolean resume(String appName) {
        boolean isSuccess = true;
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        if (appInfo != null) {
            isSuccess = appInfo.resume(this.logger);
        }
        return isSuccess;
    }

    public LinkedList<EngineInfo> setupContainerInfos(DeploymentContext context, ActionReport report) throws Exception {
        return this.setupContainerInfos(null, null, context, report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<EngineInfo> setupContainerInfos(ArchiveHandler handler, Collection<Sniffer> sniffers, DeploymentContext context, ActionReport report) throws Exception {
        if (sniffers == null) {
            Object source = context.getSource();
            if (handler instanceof CompositeHandler) {
                source = new CompositeArchive(context.getSource(), (CompositeHandler)handler);
                context.getProps().setProperty(IS_COMPOSITE, "true");
            }
            sniffers = this.snifferManager.getSniffers((ReadableArchive)source, context.getClassLoader());
        }
        if (sniffers.size() == 0) {
            report.failure(this.logger, localStrings.getLocalString("deploy.unknownmoduletpe", "Module type not recognized"));
            return null;
        }
        HashMap<Deployer, EngineInfo> containerInfosByDeployers = new HashMap<Deployer, EngineInfo>();
        for (Sniffer sniffer : sniffers) {
            if (sniffer.getContainersNames() == null || sniffer.getContainersNames().length == 0) {
                report.failure(this.logger, "no container associated with application of type : " + sniffer.getModuleType(), null);
                return null;
            }
            Module snifferModule = this.modulesRegistry.find(sniffer.getClass());
            if (snifferModule == null) {
                report.failure(this.logger, "cannot find container module from service implementation " + sniffer.getClass(), null);
                return null;
            }
            String containerName = sniffer.getContainersNames()[0];
            EngineInfo engineInfo = this.containerRegistry.getContainer(containerName);
            if (engineInfo == null) {
                Collection<EngineInfo> containersInfo = null;
                ContainerRegistry containerRegistry = this.containerRegistry;
                synchronized (containerRegistry) {
                    if (this.containerRegistry.getContainer(containerName) == null && ((containersInfo = this.setupContainer(sniffer, snifferModule, this.logger, report)) == null || containersInfo.size() == 0)) {
                        String msg = "Cannot start container(s) associated to application of type : " + sniffer.getModuleType();
                        report.failure(this.logger, msg, null);
                        throw new Exception(msg);
                    }
                }
                if (!this.startContainers(containersInfo, this.logger, report)) {
                    String msg = "Aborting, Failed to start container " + containerName;
                    report.failure(this.logger, msg, null);
                    throw new Exception(msg);
                }
            }
            if ((engineInfo = this.containerRegistry.getContainer(sniffer.getContainersNames()[0])) == null) {
                String msg = "Aborting, Failed to start container " + containerName;
                report.failure(this.logger, msg, null);
                throw new Exception(msg);
            }
            Deployer deployer = this.getDeployer(engineInfo);
            if (deployer == null) {
                report.failure(this.logger, "Got a null deployer out of the " + engineInfo.getContainer().getClass() + " container, is it annotated with @Service ?");
                return null;
            }
            containerInfosByDeployers.put(deployer, engineInfo);
        }
        LinkedList providers = new LinkedList();
        providers.addAll(this.habitat.getAllByContract(ApplicationMetaDataProvider.class));
        LinkedList<EngineInfo> sortedEngineInfos = new LinkedList<EngineInfo>();
        HashMap<Class, ApplicationMetaDataProvider> typeByProvider = new HashMap<Class, ApplicationMetaDataProvider>();
        for (ApplicationMetaDataProvider provider : this.habitat.getAllByContract(ApplicationMetaDataProvider.class)) {
            if (provider.getMetaData() == null) continue;
            for (Class provided : provider.getMetaData().provides()) {
                typeByProvider.put(provided, provider);
            }
        }
        for (ApplicationMetaDataProvider provider : this.habitat.getAllByContract(ApplicationMetaDataProvider.class)) {
            if (provider.getMetaData() == null) continue;
            for (Class dependency : provider.getMetaData().requires()) {
                if (typeByProvider.containsKey(dependency)) continue;
                report.failure(this.logger, "ApplicationMetaDataProvider " + provider + " requires " + dependency + " but no other ApplicationMetaDataProvider provides it", null);
                return null;
            }
        }
        HashMap<Class, Deployer> typeByDeployer = new HashMap<Class, Deployer>();
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            if (deployer.getMetaData() == null) continue;
            for (Class provided : deployer.getMetaData().provides()) {
                typeByDeployer.put(provided, deployer);
            }
        }
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            if (deployer.getMetaData() == null) continue;
            for (Class dependency : deployer.getMetaData().requires()) {
                if (typeByDeployer.containsKey(dependency) || typeByProvider.containsKey(dependency)) continue;
                report.failure(this.logger, "Deployer " + dependency + " requires " + deployer + " but no other deployer provides it", null);
                return null;
            }
        }
        LinkedList<Deployer> orderedDeployers = new LinkedList<Deployer>();
        for (Deployer deployer : containerInfosByDeployers.keySet()) {
            this.loadDeployer(orderedDeployers, deployer, typeByDeployer, typeByProvider, context);
        }
        for (Deployer deployer : orderedDeployers) {
            MetaData metadata = deployer.getMetaData();
            try {
                if (metadata != null) {
                    if (metadata.provides() == null || metadata.provides().length == 0) {
                        deployer.loadMetaData(null, context);
                    } else {
                        for (Class provide : metadata.provides()) {
                            if (context.getModuleMetaData(provide) != null) continue;
                            context.addModuleMetaData(deployer.loadMetaData(provide, context));
                        }
                    }
                } else {
                    deployer.loadMetaData(null, context);
                }
            }
            catch (Exception e) {
                report.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", (Throwable)e);
                throw e;
            }
            sortedEngineInfos.add((EngineInfo)containerInfosByDeployers.get(deployer));
        }
        return sortedEngineInfos;
    }

    private void loadDeployer(LinkedList<Deployer> results, Deployer deployer, Map<Class, Deployer> typeByDeployer, Map<Class, ApplicationMetaDataProvider> typeByProvider, DeploymentContext dc) throws IOException {
        if (results.contains(deployer)) {
            return;
        }
        results.addFirst(deployer);
        if (deployer.getMetaData() != null) {
            for (Class required : deployer.getMetaData().requires()) {
                if (dc.getModuleMetaData(required) != null) continue;
                if (typeByDeployer.containsKey(required)) {
                    this.loadDeployer(results, typeByDeployer.get(required), typeByDeployer, typeByProvider, dc);
                    continue;
                }
                ApplicationMetaDataProvider provider = typeByProvider.get(required);
                if (provider == null) {
                    this.logger.severe("I don't get it, file a bug, no-one is providing " + required + " yet it passed validation");
                    continue;
                }
                LinkedList<ApplicationMetaDataProvider> providers = new LinkedList<ApplicationMetaDataProvider>();
                this.addRecursively(providers, typeByProvider, provider);
                for (ApplicationMetaDataProvider p : providers) {
                    dc.addModuleMetaData(p.load(dc));
                }
            }
        }
    }

    private void addRecursively(LinkedList<ApplicationMetaDataProvider> results, Map<Class, ApplicationMetaDataProvider> providers, ApplicationMetaDataProvider provider) {
        results.addFirst(provider);
        for (Class type : provider.getMetaData().requires()) {
            if (!providers.containsKey(type)) continue;
            this.addRecursively(results, providers, providers.get(type));
        }
    }

    public ModuleInfo prepareModule(LinkedList<EngineInfo> sortedEngineInfos, String moduleName, DeploymentContext context, ActionReport report, ProgressTracker tracker) throws Exception {
        LinkedList<EngineRef> addedEngines = new LinkedList<EngineRef>();
        for (EngineInfo engineInfo : sortedEngineInfos) {
            Deployer deployer = engineInfo.getDeployer();
            try {
                deployer.prepare(context);
                EngineRef engineRef = new EngineRef(engineInfo, null);
                addedEngines.add(engineRef);
                tracker.add("prepared", EngineRef.class, (Object)engineRef);
                tracker.add(Deployer.class, (Object)deployer);
            }
            catch (Exception e) {
                report.failure(this.logger, "Exception while invoking " + deployer.getClass() + " prepare method", (Throwable)e);
                throw e;
            }
        }
        if (this.events != null) {
            this.events.send(new EventListener.Event(Deployment.MODULE_PREPARED, (Object)context), false);
        }
        return new ModuleInfo(this.events, moduleName, addedEngines, context.getProps());
    }

    protected Collection<EngineInfo> setupContainer(Sniffer sniffer, Module snifferModule, Logger logger, ActionReport report) {
        ContainerStarter starter = (ContainerStarter)this.habitat.getComponent(ContainerStarter.class);
        Collection<EngineInfo> containersInfo = starter.startContainer(sniffer, snifferModule);
        if (containersInfo == null || containersInfo.size() == 0) {
            report.failure(logger, "Cannot start container(s) associated to application of type : " + sniffer.getModuleType(), null);
            return null;
        }
        return containersInfo;
    }

    protected boolean startContainers(Collection<EngineInfo> containersInfo, Logger logger, ActionReport report) {
        for (EngineInfo engineInfo : containersInfo) {
            Container container;
            try {
                container = engineInfo.getContainer();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot start container  " + engineInfo.getSniffer().getModuleType(), e);
                return false;
            }
            Class deployerClass = container.getDeployer();
            try {
                Deployer deployer = (Deployer)this.habitat.getComponent(deployerClass);
                engineInfo.setDeployer(deployer);
            }
            catch (ComponentException e) {
                report.failure(logger, "Cannot instantiate or inject " + deployerClass, (Throwable)e);
                engineInfo.stop(logger);
                return false;
            }
            catch (ClassCastException e) {
                engineInfo.stop(logger);
                report.failure(logger, deployerClass + " does not implement " + " the org.jvnet.glassfish.api.deployment.Deployer interface", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    protected void stopContainers(EngineInfo[] ctrInfos, Logger logger) {
        for (EngineInfo ctrInfo : ctrInfos) {
            try {
                ctrInfo.stop(logger);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Cannot release container " + ctrInfo.getSniffer().getModuleType(), e);
            }
        }
    }

    protected ApplicationInfo unload(String appName, ExtendedDeploymentContext context, ActionReport report) {
        ApplicationInfo info = this.appRegistry.get(appName);
        if (info == null) {
            report.failure(context.getLogger(), "Application " + appName + " not registered", null);
            return null;
        }
        info.stop((ApplicationContext)context, context.getLogger());
        info.unload(context, report);
        return info;
    }

    public void undeploy(String appName, ExtendedDeploymentContext context, ActionReport report) {
        ApplicationInfo info;
        if (report.getExtraProperties() != null) {
            context.getProps().put("ActionReportProperties", report.getExtraProperties());
        }
        if ((info = this.appRegistry.get(appName)) == null) {
            report.failure(context.getLogger(), "Application " + appName + " not registered", null);
            this.events.send(new EventListener.Event(Deployment.UNDEPLOYMENT_FAILURE, (Object)context));
            return;
        }
        this.events.send(new EventListener.Event(Deployment.UNDEPLOYMENT_START, (Object)info));
        this.unload(appName, context, report);
        try {
            info.clean(context);
        }
        catch (Exception e) {
            report.failure(context.getLogger(), "Exception while cleaning application artifacts", (Throwable)e);
            this.events.send(new EventListener.Event(Deployment.UNDEPLOYMENT_FAILURE, (Object)context));
            return;
        }
        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
            this.events.send(new EventListener.Event(Deployment.UNDEPLOYMENT_SUCCESS, (Object)context));
        } else {
            this.events.send(new EventListener.Event(Deployment.UNDEPLOYMENT_FAILURE, (Object)context));
        }
        this.appRegistry.remove(appName);
    }

    public void registerAppInDomainXML(final ApplicationInfo applicationInfo, DeploymentContext context) throws TransactionFailure {
        final Properties appProps = context.getProps();
        final DeployCommandParameters deployParams = (DeployCommandParameters)context.getCommandParameters(DeployCommandParameters.class);
        ConfigSupport.apply((ConfigCode)new ConfigCode(){

            public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
                Applications apps = (Applications)params[0];
                Server servr = (Server)params[1];
                Application app = (Application)params[0].createChild(Application.class);
                app.setName(deployParams.name);
                if (deployParams.libraries != null) {
                    app.setLibraries(deployParams.libraries);
                }
                if (deployParams.description != null) {
                    app.setDescription(deployParams.description);
                }
                if (appProps.getProperty("context-root") != null) {
                    app.setContextRoot(appProps.getProperty("context-root"));
                }
                app.setLocation(appProps.getProperty("location"));
                app.setObjectType(appProps.getProperty("object-type"));
                app.setDirectoryDeployed(appProps.getProperty("directory-deployed"));
                app.setEnabled(String.valueOf(true));
                apps.getModules().add(app);
                applicationInfo.save(app);
                for (String string : appProps.keySet()) {
                    if (string.equals("location") || string.equals("object-type") || string.equals("directory-deployed") || string.startsWith("appConfig")) continue;
                    Property prop = (Property)app.createChild(Property.class);
                    app.getProperty().add(prop);
                    prop.setName(string);
                    prop.setValue(appProps.getProperty(string));
                }
                ApplicationRef appRef = (ApplicationRef)params[1].createChild(ApplicationRef.class);
                appRef.setRef(deployParams.name);
                if (deployParams.virtualservers != null) {
                    appRef.setVirtualServers(deployParams.virtualservers);
                } else {
                    HttpService httpService = (HttpService)ApplicationLifecycle.this.habitat.getComponent(HttpService.class);
                    StringBuilder sb = new StringBuilder();
                    for (VirtualServer s : httpService.getVirtualServer()) {
                        if (s.getId().equals("__asadmin")) continue;
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        sb.append(s.getId());
                    }
                    appRef.setVirtualServers(sb.toString());
                }
                appRef.setEnabled(deployParams.enabled.toString());
                List list = (List)appProps.get("appConfig");
                if (list != null) {
                    for (ApplicationConfig ac : list) {
                        app.getApplicationConfigs().add(ac);
                    }
                }
                servr.getApplicationRef().add(appRef);
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy[])new ConfigBeanProxy[]{this.applications, this.server});
    }

    public void unregisterAppFromDomainXML(final String appName) throws TransactionFailure {
        ConfigSupport.apply((ConfigCode)new ConfigCode(){

            public Object run(ConfigBeanProxy ... params) throws PropertyVetoException, TransactionFailure {
                Applications apps = (Applications)params[0];
                Server servr = (Server)params[1];
                for (ApplicationRef appRef : servr.getApplicationRef()) {
                    if (!appRef.getRef().equals(appName)) continue;
                    ((Server)params[1]).getApplicationRef().remove(appRef);
                    break;
                }
                for (Named module : apps.getModules()) {
                    if (!module.getName().equals(appName)) continue;
                    ((Applications)params[0]).getModules().remove(module);
                    break;
                }
                return Boolean.TRUE;
            }
        }, (ConfigBeanProxy[])new ConfigBeanProxy[]{this.applications, this.server});
    }

    public boolean isRegistered(String appName) {
        return ConfigBeansUtilities.getModule((String)appName) != null;
    }

    public ApplicationInfo get(String appName) {
        return this.appRegistry.get(appName);
    }

    public ExtendedDeploymentContext getContext(Logger logger, File source, OpsParams params) throws IOException {
        ReadableArchive archive = null;
        if (source != null && (archive = this.archiveFactory.openArchive(source)) == null) {
            throw new IOException("Invalid archive type : " + source.getAbsolutePath());
        }
        return this.getContext(logger, archive, params);
    }

    public ExtendedDeploymentContext getContext(Logger logger, ReadableArchive source, OpsParams params) throws IOException {
        DeploymentContextImpl context = new DeploymentContextImpl(logger, source, params, (ServerEnvironment)this.env);
        if (source != null && !new File(source.getURI().getSchemeSpecificPart()).isDirectory()) {
            File expansionDir = new File(this.domain.getApplicationRoot(), params.name());
            if (!expansionDir.mkdirs()) {
                logger.fine(localStrings.getLocalString("deploy.cannotcreateexpansiondir", "Error while creating directory for jar expansion: {0}", new Object[]{expansionDir}));
            }
            try {
                ArchiveHandler archiveHandler = this.getArchiveHandler(source);
                Long start = System.currentTimeMillis();
                archiveHandler.expand(source, this.archiveFactory.createArchive(expansionDir), (DeploymentContext)context);
                System.out.println("Deployment expansion took " + (System.currentTimeMillis() - start));
                try {
                    source.close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, localStrings.getLocalString("deploy.errorclosingarchive", "Error while closing deployable artifact {0}", new Object[]{source.getURI().getSchemeSpecificPart()}), e);
                    throw e;
                }
                source = this.archiveFactory.openArchive(expansionDir);
                context.setSource(source);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, localStrings.getLocalString("deploy.errorexpandingjar", "Error while expanding archive file"), e);
                throw e;
            }
        }
        return context;
    }
}

