/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.common.HTMLActionReporter;
import com.sun.enterprise.v3.server.AppServerStartup;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.ContainerRegistry;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PostConstruct;
import org.jvnet.hk2.component.PreDestroy;

@Service(name="ApplicationLoaderService")
public class ApplicationLoaderService
implements Startup,
PreDestroy,
PostConstruct {
    final Logger logger = LogDomains.getLogger(AppServerStartup.class, (String)"javax.enterprise.system.core");
    @Inject
    Deployment deployment;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    SnifferManager snifferManager;
    @Inject
    ContainerRegistry containerRegistry;
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    Events events;
    @Inject
    protected Applications applications;
    @Inject(name="default-instance-name")
    Server server;
    @Inject
    ServerEnvironment env;
    @Inject(name="ResourceManager", optional=true)
    Startup resourceManager;
    private static final String IS_COMPOSITE = "isComposite";

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postConstruct() {
        File sourceFile;
        assert (this.env != null);
        block11: for (Named m : this.applications.getModules()) {
            if (!(m instanceof Application)) continue;
            Application module = (Application)m;
            for (ApplicationRef appRef : this.server.getApplicationRef()) {
                if (!appRef.getRef().equals(module.getName())) continue;
                if (!appRef.getEnabled().equals(String.valueOf(Boolean.TRUE))) continue block11;
                this.processApplication(module, appRef, this.logger);
                continue block11;
            }
        }
        String defaultParam = this.env.getStartupContext().getArguments().getProperty("default");
        if (defaultParam != null && (sourceFile = defaultParam.equals(".") ? new File(System.getProperty("user.dir")) : new File(defaultParam)).exists()) {
            sourceFile = sourceFile.getAbsoluteFile();
            ReadableArchive sourceArchive = null;
            try {
                ApplicationInfo appInfo;
                sourceArchive = this.archiveFactory.openArchive(sourceFile);
                DeployCommandParameters parameters = new DeployCommandParameters(sourceFile);
                parameters.name = sourceFile.getName();
                parameters.enabled = Boolean.TRUE;
                parameters.origin = OpsParams.Origin.deploy;
                ExtendedDeploymentContext depContext = this.deployment.getContext(this.logger, sourceArchive, (OpsParams)parameters);
                HTMLActionReporter report = new HTMLActionReporter();
                if (!sourceFile.isDirectory()) {
                    final File tmpFile = File.createTempFile(sourceFile.getName(), "");
                    String path = tmpFile.getAbsolutePath();
                    tmpFile.delete();
                    File tmpDir = new File(path);
                    tmpDir.deleteOnExit();
                    this.events.register(new EventListener(){

                        public void event(EventListener.Event event) {
                            if (event.is(EventTypes.SERVER_SHUTDOWN) && tmpFile.exists()) {
                                FileUtils.whack((File)tmpFile);
                            }
                        }
                    });
                    if (tmpDir.mkdirs()) {
                        ArchiveHandler handler = this.deployment.getArchiveHandler(sourceArchive);
                        String appName = handler.getDefaultApplicationName(sourceArchive);
                        handler.expand(sourceArchive, this.archiveFactory.createArchive(tmpDir), (DeploymentContext)depContext);
                        sourceArchive = this.archiveFactory.openArchive(tmpDir);
                        depContext.setSource(sourceArchive);
                        this.logger.info("Source is not a directory, using temporary location " + tmpDir.getAbsolutePath());
                        this.logger.warning("Using " + appName + " as context root for application");
                    }
                }
                if ((appInfo = this.deployment.deploy(depContext, (ActionReport)report)) == null) {
                    this.logger.severe("Cannot find the application type for the artifact at : " + sourceFile.getAbsolutePath());
                    this.logger.severe("Was the container or sniffer removed ?");
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "IOException while deploying", e);
            }
            finally {
                if (sourceArchive != null) {
                    try {
                        sourceArchive.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processApplication(Application app, ApplicationRef appRef, Logger logger) {
        long operationStartTime = Calendar.getInstance().getTimeInMillis();
        String source = app.getLocation();
        String appName = app.getName();
        ArrayList<String> snifferTypes = new ArrayList<String>();
        for (Module module : app.getModule()) {
            for (Engine engine : module.getEngines()) {
                snifferTypes.add(engine.getSniffer());
            }
        }
        if (snifferTypes.isEmpty()) {
            logger.severe("Cannot determine application type at " + source);
            return;
        }
        URI uri = null;
        try {
            uri = new URI(source);
        }
        catch (URISyntaxException e) {
            logger.severe("Cannot determine original location for application : " + e.getMessage());
            return;
        }
        File sourceFile = new File(uri);
        if (sourceFile.exists()) {
            try {
                ReadableArchive archive = null;
                try {
                    DeployCommandParameters deploymentParams = app.getDeployParameters(appRef);
                    deploymentParams.origin = OpsParams.Origin.load;
                    archive = this.archiveFactory.openArchive(sourceFile, deploymentParams);
                    ExtendedDeploymentContext depContext = this.deployment.getContext(logger, archive, (OpsParams)deploymentParams);
                    depContext.getProps().putAll((Map<?, ?>)app.getDeployProperties());
                    depContext.setModulePropsMap(app.getModulePropertiesMap());
                    HTMLActionReporter report = new HTMLActionReporter();
                    ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>();
                    if (!Boolean.valueOf(depContext.getProps().getProperty(IS_COMPOSITE)).booleanValue()) {
                        for (String snifferType : snifferTypes) {
                            Sniffer sniffer = this.snifferManager.getSniffer(snifferType);
                            if (sniffer != null) {
                                sniffers.add(sniffer);
                                continue;
                            }
                            logger.severe("Cannot find sniffer for module type : " + snifferType);
                        }
                        if (sniffers.isEmpty()) {
                            logger.severe("Cannot find any sniffer for deployed app " + appName);
                            return;
                        }
                    } else {
                        sniffers = null;
                    }
                    this.deployment.deploy(sniffers, depContext, (ActionReport)report);
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        logger.info("Loading " + appName + " Application done is " + (Calendar.getInstance().getTimeInMillis() - operationStartTime) + " ms");
                    } else {
                        logger.severe(report.getMessage());
                    }
                }
                finally {
                    if (archive != null) {
                        try {
                            archive.close();
                        }
                        catch (IOException e) {
                            logger.log(Level.FINE, e.getMessage(), e);
                        }
                    }
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "IOException while opening deployed artifact", e);
            }
        } else {
            logger.severe("Application previously deployed is not at its original location any more : " + source);
        }
    }

    public String toString() {
        return "Application Loader";
    }

    public void preDestroy() {
        HTMLActionReporter dummy = new HTMLActionReporter();
        for (Application app : this.applications.getApplications()) {
            ApplicationInfo appInfo = this.deployment.get(app.getName());
            if (appInfo == null) continue;
            UndeployCommandParameters parameters = new UndeployCommandParameters(appInfo.getName());
            parameters.origin = OpsParams.Origin.unload;
            try {
                ExtendedDeploymentContext depContext = this.deployment.getContext(this.logger, appInfo.getSource(), (OpsParams)parameters);
                appInfo.stop((ApplicationContext)depContext, depContext.getLogger());
                appInfo.unload(depContext, (ActionReport)dummy);
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Cannot create unloading context for " + app.getName(), e);
            }
            this.appRegistry.remove(appInfo.getName());
        }
        for (EngineInfo engineInfo : this.containerRegistry.getContainers()) {
            engineInfo.stop(this.logger);
        }
    }
}

