/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.deploy.shared.AbstractReadableArchive;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Manifest;
import org.glassfish.api.deployment.archive.CompositeHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeArchive
extends AbstractReadableArchive {
    final ReadableArchive delegate;
    final CompositeHandler filter;

    public CompositeArchive(ReadableArchive delegate, CompositeHandler filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    public InputStream getEntry(String name) throws IOException {
        if (this.filter.accept(this.delegate, name)) {
            return this.delegate.getEntry(name);
        }
        return null;
    }

    public boolean exists(String name) throws IOException {
        if (this.filter.accept(this.delegate, name)) {
            return this.delegate.exists(name);
        }
        return false;
    }

    public long getEntrySize(String name) {
        if (this.filter.accept(this.delegate, name)) {
            return this.delegate.getEntrySize(name);
        }
        return 0L;
    }

    public void open(URI uri) throws IOException {
        this.delegate.open(uri);
    }

    public ReadableArchive getSubArchive(String name) throws IOException {
        if (this.filter.accept(this.delegate, name)) {
            return this.delegate.getSubArchive(name);
        }
        return null;
    }

    public boolean exists() {
        return this.delegate.exists();
    }

    public boolean delete() {
        return this.delegate.delete();
    }

    public boolean renameTo(String name) {
        return this.delegate.renameTo(name);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public Enumeration<String> entries() {
        Enumeration original = this.delegate.entries();
        Vector<String> results = new Vector<String>();
        while (original.hasMoreElements()) {
            String entryName = (String)original.nextElement();
            if (!this.filter.accept(this.delegate, entryName)) continue;
            results.add(entryName);
        }
        return results.elements();
    }

    public Enumeration<String> entries(String prefix) {
        Enumeration original = this.delegate.entries(prefix);
        Vector<String> results = new Vector<String>();
        while (original.hasMoreElements()) {
            String entryName = (String)original.nextElement();
            if (!this.filter.accept(this.delegate, entryName)) continue;
            results.add(entryName);
        }
        return results.elements();
    }

    public boolean isDirectory(String name) {
        if (this.filter.accept(this.delegate, name)) {
            return this.delegate.isDirectory(name);
        }
        return false;
    }

    public Manifest getManifest() throws IOException {
        return this.delegate.getManifest();
    }

    public URI getURI() {
        return this.delegate.getURI();
    }

    public long getArchiveSize() throws SecurityException {
        return this.delegate.getArchiveSize();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Collection<String> getDirectories() throws IOException {
        return this.delegate.getDirectories();
    }
}

