/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.payload;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.Payload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PayloadFilesManager {
    private static final String XFER_DIR_PREFIX = "xfer-";
    public static final LocalStringManagerImpl strings = new LocalStringManagerImpl(PayloadFilesManager.class);
    private final File targetDir;
    protected final Logger logger;
    private final ActionReport report;

    private PayloadFilesManager(File targetDir, ActionReport report, Logger logger) {
        this.targetDir = targetDir;
        this.report = report;
        this.logger = logger;
    }

    protected File getTargetDir() {
        return this.targetDir;
    }

    protected abstract void postExtract(File var1);

    protected abstract URI getOutputFileURI(Payload.Part var1, String var2) throws IOException;

    public File extractFile(Payload.Part part) throws IOException {
        return this.extractFile(part, part.getName());
    }

    public File extractFile(Payload.Part part, String outputName) throws IOException {
        OutputStream os = null;
        InputStream is = null;
        try {
            int bytesRead;
            File extractedFile = new File(this.getOutputFileURI(part, outputName));
            File immediateParent = extractedFile.getParentFile();
            immediateParent.mkdirs();
            if (extractedFile.exists() && !extractedFile.delete()) {
                this.logger.warning(strings.getLocalString("payload.overwrite", "Overwriting previously-uploaded file because the attempt to delete it failed: {0}", extractedFile.getAbsolutePath()));
            }
            os = new BufferedOutputStream(new FileOutputStream(extractedFile));
            is = part.getInputStream();
            byte[] buffer = new byte[65536];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
            os.close();
            String lastModifiedString = part.getProperties().getProperty("last-modified");
            long lastModified = lastModifiedString != null ? Long.parseLong(lastModifiedString) : System.currentTimeMillis();
            extractedFile.setLastModified(lastModified);
            this.postExtract(extractedFile);
            this.logger.fine("Extracted transferred entry " + part.getName() + " to " + extractedFile.getAbsolutePath());
            this.reportExtractionSuccess();
            File file = extractedFile;
            return file;
        }
        catch (Exception e) {
            this.reportExtractionFailure(part.getName(), e);
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            if (os != null) {
                os.close();
                os = null;
            }
        }
    }

    public List<File> extractFiles(Payload.Inbound inboundPayload) throws IOException {
        if (inboundPayload == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<File> result = new ArrayList<File>();
        Object os = null;
        InputStream is = null;
        try {
            StringBuilder uploadedEntryNames = new StringBuilder();
            Object partIt = inboundPayload.parts();
            while (partIt.hasNext()) {
                Payload.Part part = (Payload.Part)partIt.next();
                result.add(this.extractFile(part));
                uploadedEntryNames.append(part.getName()).append(" ");
            }
            partIt = result;
            return partIt;
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            if (is != null) {
                is.close();
                is = null;
            }
        }
    }

    private void reportExtractionSuccess() {
        if (this.report != null) {
            this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }

    private void reportExtractionFailure(String partName, Exception e) {
        if (this.report != null) {
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(strings.getLocalString("payload.errExtracting", "Error extracting tranferred file {0}", partName));
            this.report.setFailureCause((Throwable)e);
        }
    }

    private static void ensureDirExists(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException(strings.getLocalString("payload.command.errorCreatingDir", "Unknown error creating directory {0}", dir.getAbsolutePath()));
        }
    }

    private static File createTempFolder(File parent, String prefix, Logger logger) throws IOException {
        PayloadFilesManager.ensureDirExists(parent);
        File result = File.createTempFile(prefix, "", parent);
        try {
            if (!result.delete()) {
                throw new IOException(strings.getLocalString("payload.command.errorDeletingTempFile", "Unknown error deleting temporary file {0}", result.getAbsolutePath()));
            }
            if (!result.mkdir()) {
                throw new IOException(strings.getLocalString("payload.command.errorCreatingDir", "Unknown error creating directory {0}", result.getAbsolutePath()));
            }
            logger.fine("Created temporary upload folder " + result.getAbsolutePath());
            return result;
        }
        catch (Exception e) {
            IOException ioe = new IOException(strings.getLocalString("payload.command.errorCreatingXferFolder", "Error creating temporary file transfer folder"));
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static File createTempFolder(File parent, Logger logger) throws IOException {
        return PayloadFilesManager.createTempFolder(parent, XFER_DIR_PREFIX, logger);
    }

    public static class Temp
    extends PayloadFilesManager {
        private static final String GFV3 = "gfv3";
        private boolean isCleanedUp = false;
        private Map<String, File> pathToTempSubdir = new HashMap<String, File>();

        public Temp(ActionReport report, Logger logger) throws IOException {
            super(PayloadFilesManager.createTempFolder(new File(System.getProperty("java.io.tmpdir"), GFV3), logger), report, logger);
        }

        public Temp(Logger logger) throws IOException {
            this(null, logger);
        }

        public void cleanup() {
            if (!this.isCleanedUp) {
                FileUtils.whack(((PayloadFilesManager)this).targetDir);
                this.isCleanedUp = true;
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.cleanup();
        }

        protected void postExtract(File extractedFile) {
            extractedFile.deleteOnExit();
        }

        protected URI getOutputFileURI(Payload.Part part, String name) throws IOException {
            File tempFile;
            String parentPath = this.getParentPath(name);
            if (parentPath != null) {
                URI parentURI = this.getTempSubDirForPath(parentPath);
                tempFile = new File(new File(parentURI), this.getNameAndType(name));
            } else {
                tempFile = new File(this.getTargetDir(), this.getNameAndType(name));
            }
            return tempFile.toURI();
        }

        private String getParentPath(String partName) {
            int lastSlash = partName.lastIndexOf(47);
            if (lastSlash != -1) {
                return partName.substring(0, lastSlash);
            }
            return null;
        }

        URI getTempSubDirForPath(String parentPath) throws IOException {
            File tempSubDir = this.pathToTempSubdir.get(parentPath);
            if (tempSubDir == null) {
                String tempDirPrefix = parentPath.replaceAll("[/:\\\\]", "-") + "---";
                tempSubDir = PayloadFilesManager.createTempFolder(this.getTargetDir(), tempDirPrefix, this.logger);
                this.pathToTempSubdir.put(parentPath, tempSubDir);
            }
            return tempSubDir.toURI();
        }

        private String getNameAndType(String path) {
            int lastSlash = path.lastIndexOf(47);
            return path.substring(lastSlash + 1);
        }
    }

    public static class Perm
    extends PayloadFilesManager {
        public Perm(File targetDir, ActionReport report, Logger logger) {
            super(targetDir, report, logger);
        }

        public Perm(ActionReport report, Logger logger) {
            super(new File(System.getProperty("user.dir")), report, logger);
        }

        public Perm(Logger logger) {
            this(null, logger);
        }

        public Perm() {
            this(null, Logger.getLogger(Perm.class.getName()));
        }

        protected void postExtract(File extractedFile) {
        }

        private URI getParentURI(Payload.Part part) {
            Properties partProps = part.getProperties();
            String parentPathFromPart = partProps.getProperty("file-xfer-root");
            URI parentURI = this.getTargetDir().toURI();
            if (parentPathFromPart != null) {
                if (!parentPathFromPart.endsWith("/")) {
                    parentPathFromPart = parentPathFromPart + "/";
                }
                parentURI = parentURI.resolve(parentPathFromPart);
            }
            return parentURI;
        }

        protected URI getOutputFileURI(Payload.Part part, String name) throws IOException {
            URI targetURI = this.getParentURI(part).resolve(name);
            return targetURI;
        }
    }
}

