/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.cli.AbstractCommand;
import com.sun.enterprise.admin.cli.remote.CommandInvoker;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;

public final class VersionCommand
extends AbstractCommand {
    public void runCommand() throws CommandException, CommandValidationException {
        super.validateOptions();
        try {
            this.invokeRemote();
        }
        catch (Exception e) {
            this.printRemoteException(e);
            this.invokeLocal();
        }
    }

    private void invokeRemote() throws CommandException {
        CommandInvoker in = new CommandInvoker(super.getName());
        in.put("host", this.getOption("host"));
        in.put("port", this.getOption("port"));
        in.put("user", this.getOption("user"));
        in.put("passwordfile", this.getOption("passwordfile"));
        in.put("secure", this.getOption("secure"));
        in.put("terse", this.getOption("terse"));
        in.invoke();
    }

    private void invokeLocal() {
        String fv = Version.getFullVersion();
        String cn = Version.class.getName();
        String msg = super.getLocalizedString("version.local", new String[]{cn, fv});
        CLILogger.getInstance().printMessage(msg);
    }

    private void printRemoteException(Exception e) {
        String host = this.getOption("host") == null ? "localhost" : this.getOption("host");
        String ports = this.getOption("port") == null ? "4848" : this.getOption("port");
        String msg = super.getLocalizedString("remote.version.failed", new String[]{host, ports});
        CLILogger.getInstance().printMessage(msg);
        CLILogger.getInstance().printDebugMessage(e.getMessage());
    }
}

