/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.ssl;

import com.sun.grizzly.http.FileCache;
import com.sun.grizzly.http.FileCacheFactory;
import com.sun.grizzly.util.SSLOutputWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;

public class SSLFileCacheFactory
extends FileCacheFactory {
    public static FileCacheFactory newInstance(int currentPort) {
        SSLFileCacheFactory fileCacheFactory = new SSLFileCacheFactory();
        fileCacheFactory.port = currentPort;
        cache.put(currentPort, fileCacheFactory);
        ConcurrentLinkedQueue<FileCache.FileCacheEntry> cacheManager = new ConcurrentLinkedQueue<FileCache.FileCacheEntry>();
        fileCacheFactory.setCacheManager(cacheManager);
        return fileCacheFactory;
    }

    public static FileCacheFactory getFactory(int currentPort) {
        FileCacheFactory fileCacheFactory = (FileCacheFactory)cache.get(currentPort);
        if (fileCacheFactory == null) {
            fileCacheFactory = SSLFileCacheFactory.newInstance(currentPort);
        }
        return fileCacheFactory;
    }

    public FileCache getFileCache() {
        if (this.fileCache == null) {
            this.fileCache = new FileCache(){

                protected void sendCache(SocketChannel socketChannel, FileCache.FileCacheEntry entry, boolean keepAlive) throws IOException {
                    SSLOutputWriter.flushChannel((SelectableChannel)socketChannel, (ByteBuffer)entry.headerBuffer.slice());
                    ByteBuffer keepAliveBuf = keepAlive ? connectionKaBB.slice() : connectionCloseBB.slice();
                    SSLOutputWriter.flushChannel((SelectableChannel)socketChannel, (ByteBuffer)keepAliveBuf);
                    SSLOutputWriter.flushChannel((SelectableChannel)socketChannel, (ByteBuffer)entry.bb.slice());
                }
            };
            this.fileCache.setIsEnabled(isEnabled);
            this.fileCache.setLargeFileCacheEnabled(this.isLargeFileCacheEnabled);
            this.fileCache.setSecondsMaxAge(this.secondsMaxAge);
            this.fileCache.setMaxCacheEntries(this.maxCacheEntries);
            this.fileCache.setMinEntrySize(this.minEntrySize);
            this.fileCache.setMaxEntrySize(this.maxEntrySize);
            this.fileCache.setMaxLargeCacheSize(this.maxLargeFileCacheSize);
            this.fileCache.setMaxSmallCacheSize(this.maxSmallFileCacheSize);
            this.fileCache.setCacheManager(this.cacheManager);
            FileCache.setIsMonitoringEnabled(this.isMonitoringEnabled);
        }
        return this.fileCache;
    }
}

