/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.UndeployCommandParameters;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DownloadableArtifacts;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="deploy")
@I18n(value="deploy.command")
@Scoped(value=PerLookup.class)
public class DeployCommand
extends DeployCommandParameters
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeployCommand.class);
    private static final String INSTANCE_ROOT_URI_PROPERTY_NAME = "com.sun.aas.instanceRootURI";
    @Inject
    Applications apps;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Deployment deployment;
    @Inject
    SnifferManager snifferManager;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Domain domain;
    @Inject
    DownloadableArtifacts downloadableArtifacts;
    private PayloadFilesManager.Temp payloadFilesMgr = null;
    private List<File> payloadFiles = null;

    public DeployCommand() {
        this.origin = OpsParams.Origin.deploy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(AdminCommandContext context) {
        block46: {
            ReadableArchive archive;
            File file;
            Logger logger;
            ActionReport report;
            long operationStartTime;
            block41: {
                block40: {
                    try {
                        operationStartTime = Calendar.getInstance().getTimeInMillis();
                        report = context.getActionReport();
                        logger = context.getLogger();
                        try {
                            this.payloadFilesMgr = new PayloadFilesManager.Temp(context.getActionReport(), logger);
                            this.payloadFiles = this.payloadFilesMgr.extractFiles(context.getInboundPayload());
                        }
                        catch (Exception e) {
                            report.setFailureCause((Throwable)e);
                            report.failure(logger, localStrings.getLocalString("adapter.command.errorPrepUploadedFiles", "Error preparing uploaded files"), (Throwable)e);
                            if (this.payloadFilesMgr == null) return;
                            this.payloadFilesMgr.cleanup();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var23_24 = null;
                        if (this.payloadFilesMgr == null) throw throwable;
                        this.payloadFilesMgr.cleanup();
                        throw throwable;
                    }
                    file = this.choosePathFile(context);
                    if (file.exists()) break block40;
                    report.setMessage(localStrings.getLocalString("fnf", "File not found", new Object[]{file.getAbsolutePath()}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    if (this.payloadFilesMgr == null) return;
                    this.payloadFilesMgr.cleanup();
                    return;
                }
                this.deploymentplan = this.chooseDeploymentPlanFile(context);
                if (!this.snifferManager.hasNoSniffers()) break block41;
                String msg = localStrings.getLocalString("nocontainer", "No container services registered, done...");
                report.failure(logger, msg);
                if (this.payloadFilesMgr == null) return;
                this.payloadFilesMgr.cleanup();
                return;
            }
            try {
                archive = this.archiveFactory.openArchive(file, (DeployCommandParameters)this);
            }
            catch (IOException e) {
                String msg = localStrings.getLocalString("deploy.errOpeningArtifact", "deploy.errOpeningArtifact", new Object[]{file.getAbsolutePath()});
                if (this.logReportedErrors.booleanValue()) {
                    report.failure(logger, msg, (Throwable)e);
                } else {
                    report.setMessage(msg + file.getAbsolutePath() + e.toString());
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                }
                if (this.payloadFilesMgr == null) return;
                this.payloadFilesMgr.cleanup();
                return;
            }
            File expansionDir = null;
            ArchiveHandler archiveHandler = this.deployment.getArchiveHandler(archive);
            if (archiveHandler != null) break block42;
            report.failure(logger, localStrings.getLocalString("deploy.unknownarchivetype", "Archive type of {0} was not recognized", new Object[]{file.getName()}));
            Object var20_14 = null;
            try {
                archive.close();
            }
            catch (IOException e2) {
                logger.log(Level.INFO, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{file.getAbsolutePath()}), e2);
            }
            if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, Calendar.getInstance().getTimeInMillis() - operationStartTime}));
            } else if (expansionDir != null) {
                FileUtils.whack(expansionDir);
            }
            Object var23_22 = null;
            if (this.payloadFilesMgr == null) return;
            this.payloadFilesMgr.cleanup();
            {
                block44: {
                    block42: {
                        return;
                    }
                    if (this.name == null) {
                        this.name = archiveHandler.getDefaultApplicationName(archive);
                    }
                    Properties undeployProps = this.handleRedeploy(this.name, report);
                    if (!this.keepreposdir.booleanValue()) {
                        FileUtils.whack((File)new File(this.env.getApplicationRepositoryPath(), this.name));
                    }
                    File source = new File(archive.getURI().getSchemeSpecificPart());
                    boolean isDirectoryDeployed = true;
                    if (!source.isDirectory()) {
                        isDirectoryDeployed = false;
                        file = expansionDir = new File(this.domain.getApplicationRoot(), this.name);
                    }
                    ExtendedDeploymentContext deploymentContext = this.deployment.getContext(logger, archive, (OpsParams)this);
                    deploymentContext.setArchiveHandler(archiveHandler);
                    if (undeployProps != null) {
                        deploymentContext.getProps().putAll((Map<?, ?>)undeployProps);
                    }
                    if (this.properties != null) {
                        deploymentContext.getProps().putAll((Map<?, ?>)this.properties);
                    }
                    deploymentContext.clean();
                    Properties appProps = deploymentContext.getProps();
                    URI instanceRootURI = new URI(System.getProperty(INSTANCE_ROOT_URI_PROPERTY_NAME));
                    URI appURI = instanceRootURI.relativize(deploymentContext.getSource().getURI());
                    String appLocation = appURI.isAbsolute() ? appURI.toString() : "${com.sun.aas.instanceRootURI}/" + appURI.toString();
                    appProps.setProperty("location", appLocation);
                    appProps.setProperty("object-type", "user");
                    if (this.contextRoot != null) {
                        appProps.setProperty("context-root", this.contextRoot);
                    }
                    appProps.setProperty("directory-deployed", String.valueOf(isDirectoryDeployed));
                    ApplicationInfo appInfo = this.deployment.deploy(deploymentContext, report);
                    if (report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                        this.deployment.registerAppInDomainXML(appInfo, (DeploymentContext)deploymentContext);
                    }
                    if (this.retrieve == null) break block44;
                    this.retrieveArtifacts(context);
                }
                Object var20_15 = null;
                try {
                    archive.close();
                }
                catch (IOException e2) {
                    logger.log(Level.INFO, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{file.getAbsolutePath()}), e2);
                }
                if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                    logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, Calendar.getInstance().getTimeInMillis() - operationStartTime}));
                } else if (expansionDir != null) {
                    FileUtils.whack((File)expansionDir);
                }
                break block46;
                {
                    catch (Exception e) {
                        report.failure(logger, localStrings.getLocalString("errDuringDepl", "Error during deployment : ") + e.getMessage(), (Throwable)e);
                        Object var20_16 = null;
                        try {
                            archive.close();
                        }
                        catch (IOException e2) {
                            logger.log(Level.INFO, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{file.getAbsolutePath()}), e2);
                        }
                        if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                            logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, Calendar.getInstance().getTimeInMillis() - operationStartTime}));
                        } else if (expansionDir != null) {
                            FileUtils.whack(expansionDir);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var20_17 = null;
                    try {
                        archive.close();
                    }
                    catch (IOException e2) {
                        logger.log(Level.INFO, localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{file.getAbsolutePath()}), e2);
                    }
                    if (report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        logger.info(localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, Calendar.getInstance().getTimeInMillis() - operationStartTime}));
                        throw throwable;
                    } else {
                        if (expansionDir == null) throw throwable;
                        FileUtils.whack(expansionDir);
                    }
                    throw throwable;
                }
            }
        }
        Object var23_23 = null;
        if (this.payloadFilesMgr == null) return;
        this.payloadFilesMgr.cleanup();
    }

    private File choosePathFile(AdminCommandContext context) {
        if (this.payloadFiles.size() >= 1) {
            return this.payloadFiles.get(0);
        }
        return this.path;
    }

    private File chooseDeploymentPlanFile(AdminCommandContext context) {
        if (this.payloadFiles.size() >= 2) {
            return this.payloadFiles.get(1);
        }
        return this.deploymentplan;
    }

    private Properties handleRedeploy(String name, ActionReport report) throws Exception {
        boolean isRegistered = this.deployment.isRegistered(name);
        if (isRegistered && !this.force.booleanValue()) {
            String msg = localStrings.getLocalString("application.alreadyreg.redeploy", "Application {0} already registered, please use deploy --force=true to redeploy", new Object[]{name});
            throw new Exception(msg);
        }
        if (isRegistered && this.force.booleanValue()) {
            Application app = (Application)this.apps.getModule(Application.class, name);
            this.settingsFromDomainXML(app);
            UndeployCommandParameters undeployParams = new UndeployCommandParameters(name);
            undeployParams.keepreposdir = this.keepreposdir;
            undeployParams.droptables = this.dropandcreatetables;
            ActionReport subReport = report.addSubActionsReport();
            if (this.properties != null && this.properties.containsKey("keepSessions")) {
                undeployParams.properties = new Properties();
                undeployParams.properties.put("keepSessions", this.properties.getProperty("keepSessions"));
                subReport.setExtraProperties(new Properties());
            }
            this.commandRunner.doCommand("undeploy", (Object)undeployParams, subReport, null, null);
            return subReport.getExtraProperties();
        }
        return null;
    }

    private void retrieveArtifacts(AdminCommandContext context) {
        Logger logger = context.getLogger();
        ActionReport report = context.getActionReport();
        report.setMessage("File download results");
        try {
            Payload.Outbound outboundPayload = context.getOutboundPayload();
            Properties props = new Properties();
            props.setProperty("file-xfer-root", this.retrieve);
            for (DownloadableArtifacts.FullAndPartURIs uriPair : this.downloadableArtifacts.getArtifacts(this.name)) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "About to download artifact " + uriPair.getFull());
                }
                outboundPayload.attachFile("application/octet-stream", uriPair.getPart(), "files", props, new File(uriPair.getFull().getSchemeSpecificPart()));
                ActionReport subReport = report.addSubActionsReport();
                subReport.setActionDescription("Downloading " + uriPair.getPart());
                subReport.setMessage("Success");
                subReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to download artifacts.", e);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void settingsFromDomainXML(Application app) {
        if (this.name != null) {
            if (this.contextRoot == null) {
                this.contextRoot = app.getContextRoot();
                if (this.contextRoot != null) {
                    this.previousContextRoot = this.contextRoot;
                }
            }
            if (this.libraries == null) {
                this.libraries = app.getLibraries();
            }
            if (this.virtualservers == null) {
                this.virtualservers = ConfigBeansUtilities.getVirtualServers((String)this.target, (String)this.name);
            }
        }
    }
}

