/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.StateCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="enable")
@I18n(value="enable.command")
@Scoped(value=PerLookup.class)
public class EnableCommand
extends StateCommandParameters
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnableCommand.class);
    @Inject
    Deployment deployment;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    Applications applications;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject(name="default-instance-name")
    protected Server server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(AdminCommandContext context) {
        block19: {
            ReadableArchive archive;
            File file;
            Logger logger;
            ActionReport report;
            block18: {
                report = context.getActionReport();
                logger = context.getLogger();
                if (!this.deployment.isRegistered(this.name())) {
                    report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", new Object[]{this.name()}));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                if (Boolean.valueOf(ConfigBeansUtilities.getEnabled((String)this.target, (String)this.name())).booleanValue()) {
                    logger.fine("The application is already enabled");
                    return;
                }
                file = null;
                ApplicationRef appRef = null;
                DeployCommandParameters commandParams = null;
                Properties contextProps = new Properties();
                Map modulePropsMap = null;
                try {
                    Application app = null;
                    for (Named module : this.applications.getModules()) {
                        if (!module.getName().equals(this.name())) continue;
                        app = (Application)module;
                        break;
                    }
                    for (ApplicationRef ref : this.server.getApplicationRef()) {
                        if (!ref.getRef().equals(this.name())) continue;
                        appRef = ref;
                        break;
                    }
                    if (app != null) {
                        commandParams = app.getDeployParameters(appRef);
                        commandParams.origin = OpsParams.Origin.load;
                        commandParams.target = this.target;
                        contextProps = app.getDeployProperties();
                        modulePropsMap = app.getModulePropertiesMap();
                    }
                    if (commandParams == null) {
                        report.setMessage(localStrings.getLocalString("bug", "invalid domain.xml entries, please file a bug"));
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        return;
                    }
                    URI uri = new URI(app.getLocation());
                    file = new File(uri);
                    if (!file.exists()) {
                        report.setMessage(localStrings.getLocalString("fnf", "File not found", new Object[]{file.getAbsolutePath()}));
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        return;
                    }
                    archive = this.archiveFactory.openArchive(file);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error opening deployable artifact : " + file.getAbsolutePath(), e);
                    report.setMessage(localStrings.getLocalString("unknownarchiveformat", "Archive format not recognized"));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                ExtendedDeploymentContext deploymentContext = this.deployment.getContext(logger, archive, (OpsParams)commandParams);
                deploymentContext.getProps().putAll((Map<?, ?>)contextProps);
                if (modulePropsMap != null) {
                    deploymentContext.setModulePropsMap(modulePropsMap);
                }
                this.deployment.deploy(deploymentContext, report);
                if (!report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS) || appRef == null) break block18;
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<ApplicationRef>(){

                    public Object run(ApplicationRef param) throws PropertyVetoException, TransactionFailure {
                        param.setEnabled(String.valueOf(true));
                        return null;
                    }
                }, (ConfigBeanProxy)appRef);
            }
            Object var14_15 = null;
            try {
                archive.close();
            }
            catch (IOException e2) {
                logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e2);
            }
            break block19;
            {
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error during enabling: ", e);
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    report.setMessage(e.getMessage());
                    Object var14_16 = null;
                    try {
                        archive.close();
                    }
                    catch (IOException e2) {
                        logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                try {
                    archive.close();
                }
                catch (IOException e2) {
                    logger.log(Level.INFO, "Error while closing deployable artifact : " + file.getAbsolutePath(), e2);
                }
                throw throwable;
            }
        }
    }
}

