/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.deploy.shared;

import com.sun.enterprise.deployment.deploy.shared.JarArchive;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="jar")
@Scoped(value=PerLookup.class)
public class InputJarArchive
extends JarArchive
implements ReadableArchive {
    static final Logger logger = LogDomains.getLogger(DeploymentUtils.class, (String)"javax.enterprise.system.tools.deployment");
    protected JarFile jarFile = null;
    protected JarInputStream jarIS = null;
    private URI uri;
    private InputJarArchive parentArchive = null;
    private StringManager localStrings = StringManager.getManager(this.getClass());

    public long getArchiveSize() throws NullPointerException, SecurityException {
        if (this.uri == null) {
            return -1L;
        }
        File tmpFile = new File(this.uri);
        return tmpFile.length();
    }

    public OutputStream addEntry(String name) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
            this.jarFile = null;
        }
        if (this.jarIS != null) {
            this.jarIS.close();
            this.jarIS = null;
        }
    }

    public Collection<String> getDirectories() throws IOException {
        return this.entries(true);
    }

    public void create(URI uri) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    public Enumeration<String> entries() {
        return this.entries(false).elements();
    }

    private Vector<String> entries(boolean directory) {
        Vector<String> entries = new Vector<String>();
        if (this.parentArchive != null) {
            try {
                JarEntry ze;
                this.jarIS = new JarInputStream(this.parentArchive.jarFile.getInputStream(this.parentArchive.jarFile.getJarEntry(this.uri.getSchemeSpecificPart())));
                do {
                    if ((ze = this.jarIS.getNextJarEntry()) == null || ze.isDirectory() != directory) continue;
                    entries.add(ze.getName());
                } while (ze != null);
                this.jarIS.close();
                this.jarIS = null;
            }
            catch (IOException ioe) {
                return null;
            }
        }
        try {
            if (this.jarFile == null) {
                this.getJarFile(this.uri);
            }
        }
        catch (IOException ioe) {
            return entries;
        }
        if (this.jarFile == null) {
            return entries;
        }
        Enumeration<JarEntry> e = this.jarFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry ze = e.nextElement();
            if (ze.isDirectory() != directory || ze.getName().equals("META-INF/MANIFEST.MF")) continue;
            entries.add(ze.getName());
        }
        return entries;
    }

    public Enumeration entries(Enumeration embeddedArchives) {
        return this.entries();
    }

    @Override
    public JarEntry getJarEntry(String name) {
        if (this.jarFile != null) {
            return this.jarFile.getJarEntry(name);
        }
        return null;
    }

    @Override
    public boolean exists(String name) throws IOException {
        ZipEntry ze;
        return this.jarFile != null && (ze = this.jarFile.getEntry(name)) != null;
    }

    public InputStream getEntry(String entryName) throws IOException {
        if (this.jarFile != null) {
            ZipEntry ze = this.jarFile.getEntry(entryName);
            if (ze != null) {
                return new BufferedInputStream(this.jarFile.getInputStream(ze));
            }
            return null;
        }
        if (this.parentArchive != null && this.parentArchive.jarFile != null) {
            JarEntry je;
            JarEntry archiveJarEntry;
            if (this.jarIS != null) {
                this.jarIS.close();
            }
            JarEntry jarEntry = archiveJarEntry = this.uri != null ? this.parentArchive.jarFile.getJarEntry(this.uri.getSchemeSpecificPart()) : null;
            if (archiveJarEntry == null) {
                return null;
            }
            this.jarIS = new JarInputStream(this.parentArchive.jarFile.getInputStream(archiveJarEntry));
            while ((je = this.jarIS.getNextJarEntry()) != null && !je.getName().equals(entryName)) {
            }
            if (je != null) {
                return new BufferedInputStream(this.jarIS);
            }
            return null;
        }
        return null;
    }

    public long getEntrySize(String name) {
        ZipEntry ze;
        if (this.jarFile != null && (ze = this.jarFile.getEntry(name)) != null) {
            return ze.getSize();
        }
        return 0L;
    }

    public void open(URI uri) throws IOException {
        this.uri = uri;
        this.jarFile = this.getJarFile(uri);
    }

    protected JarFile getJarFile(URI uri) throws IOException {
        if (!uri.getScheme().equals("jar")) {
            throw new IOException("Wrong scheme for InputJarArchive : " + uri.getScheme());
        }
        this.jarFile = null;
        try {
            File file = new File(uri.getSchemeSpecificPart());
            if (file.exists()) {
                this.jarFile = new JarFile(file);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "enterprise.deployment.backend.fileOpenFailure", new Object[]{uri});
            String additionalInfo = this.localStrings.getString("enterprise.deployment.invalid_zip_file", (Object)uri);
            IOException ioe = new IOException(e.getLocalizedMessage() + " --  " + additionalInfo);
            ioe.initCause(e);
            throw ioe;
        }
        return this.jarFile;
    }

    public Manifest getManifest() throws IOException {
        if (this.jarFile != null) {
            return this.jarFile.getManifest();
        }
        if (this.parentArchive != null) {
            InputStream is;
            Manifest m;
            if (this.jarIS != null) {
                this.jarIS.close();
            }
            if (this.jarIS == null) {
                this.jarIS = new JarInputStream(this.parentArchive.jarFile.getInputStream(this.parentArchive.jarFile.getJarEntry(this.uri.getSchemeSpecificPart())));
            }
            if ((m = this.jarIS.getManifest()) == null && (is = this.getEntry("META-INF/MANIFEST.MF")) != null) {
                m = new Manifest();
                m.read(is);
                is.close();
            }
            return m;
        }
        return null;
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean exists() {
        return this.jarFile != null;
    }

    public boolean delete() {
        if (this.jarFile == null) {
            return false;
        }
        try {
            this.jarFile.close();
            this.jarFile = null;
        }
        catch (IOException ioe) {
            return false;
        }
        return FileUtils.deleteFile((File)new File(this.uri));
    }

    public boolean renameTo(String name) {
        if (this.jarFile == null) {
            return false;
        }
        try {
            this.jarFile.close();
            this.jarFile = null;
        }
        catch (IOException ioe) {
            return false;
        }
        return FileUtils.renameFile((File)new File(this.uri), (File)new File(name));
    }

    public ReadableArchive getSubArchive(String name) throws IOException {
        if (this.jarFile != null) {
            InputJarArchive ija = new InputJarArchive();
            JarEntry je = this.jarFile.getJarEntry(name);
            if (je != null) {
                JarInputStream jis = new JarInputStream(new BufferedInputStream(this.jarFile.getInputStream(je)));
                try {
                    ija.uri = new URI("jar", name, null);
                }
                catch (URISyntaxException e) {
                    // empty catch block
                }
                ija.jarIS = jis;
                ija.parentArchive = this;
                return ija;
            }
        }
        return null;
    }
}

