/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.data;

import com.sun.enterprise.config.serverbeans.Engine;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.internal.data.EngineInfo;
import org.glassfish.internal.data.ProgressTracker;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.config.TransactionFailure;

public class EngineRef {
    private final EngineInfo ctrInfo;
    private ApplicationContainer appCtr;

    public EngineRef(EngineInfo container, ApplicationContainer appCtr) {
        this.ctrInfo = container;
        this.appCtr = appCtr;
    }

    public EngineInfo getContainerInfo() {
        return this.ctrInfo;
    }

    public void setApplicationContainer(ApplicationContainer appCtr) {
        this.appCtr = appCtr;
    }

    public ApplicationContainer getApplicationContainer() {
        return this.appCtr;
    }

    public void load(ExtendedDeploymentContext context) {
        this.getContainerInfo().load(context);
    }

    public boolean start(ApplicationContext context, ProgressTracker tracker) throws Exception {
        if (this.appCtr == null) {
            return true;
        }
        if (!this.appCtr.start(context)) {
            return false;
        }
        tracker.add("started", EngineRef.class, this);
        return true;
    }

    public boolean unload(ExtendedDeploymentContext context) {
        ActionReport report = context.getActionReport();
        Deployer deployer = this.ctrInfo.getDeployer();
        try {
            deployer.unload(this.appCtr, (DeploymentContext)context);
            this.ctrInfo.unload(context);
        }
        catch (Exception e) {
            report.failure(context.getLogger(), "Exception while shutting down application container", (Throwable)e);
            return false;
        }
        this.appCtr = null;
        return true;
    }

    public boolean stop(ApplicationContext context, Logger logger) {
        return this.appCtr.stop(context);
    }

    public void clean(ExtendedDeploymentContext context, Logger logger) {
        try {
            this.getContainerInfo().clean(context);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while cleaning module '" + this + "'" + e, e);
        }
    }

    public void save(Engine engine) throws TransactionFailure, PropertyVetoException {
        engine.setSniffer(this.getContainerInfo().getSniffer().getModuleType());
    }
}

