/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="get-host-and-port")
@Scoped(value=PerLookup.class)
public class GetHostAndPortCommand
implements AdminCommand {
    @Param(optional=true)
    public String target = "server";
    @Param(optional=true)
    public String virtualServer = null;
    @Param(optional=true, defaultValue="false")
    public Boolean securityEnabled = false;
    @Param(optional=true)
    public String moduleId = null;
    @Inject
    Configs configs;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(GetHostAndPortCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        HttpService httpService = null;
        HostAndPort hostAndPort = null;
        try {
            Server server = ConfigBeansUtilities.getServerNamed((String)this.target);
            if (server == null) {
                throw new Exception("Target : " + this.target + " does not exist");
            }
            Config config = this.configs.getConfigByName(server.getConfigRef());
            httpService = config.getHttpService();
            if (httpService != null) {
                hostAndPort = this.getHostAndPortForRequest(httpService);
            }
        }
        catch (Exception e) {
            report.setMessage(e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (hostAndPort != null) {
            part.setMessage(hostAndPort.getHost() + ":" + hostAndPort.getPort());
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private HostAndPort getHostAndPortForRequest(HttpService httpService) throws Exception {
        if (this.moduleId == null) {
            if (this.virtualServer == null) {
                return this.getHostAndPort(httpService, this.securityEnabled);
            }
            VirtualServer vs = httpService.getVirtualServerByName(this.virtualServer);
            if (vs == null) {
                throw new Exception("Virtual server: " + this.virtualServer + " does not exist!");
            }
            return this.getHostAndPort(httpService, vs, this.securityEnabled);
        }
        ApplicationRef appRef = ConfigBeansUtilities.getApplicationRefInServer((String)this.target, (String)this.moduleId);
        if (appRef == null) {
            throw new Exception("Application : " + appRef.getRef() + " does not exist on target " + this.target);
        }
        List vsList = StringUtils.parseStringList((String)appRef.getVirtualServers(), (String)" ,");
        if (vsList == null) {
            return this.getHostAndPort(httpService, this.securityEnabled);
        }
        for (String virtualServer : vsList) {
            HostAndPort hp = this.getHostAndPort(httpService, httpService.getVirtualServerByName(virtualServer), this.securityEnabled);
            if (hp == null) continue;
            return hp;
        }
        return null;
    }

    private HostAndPort getHostAndPort(HttpService httpService, VirtualServer vs, boolean securityEnabled) {
        List virtualServerList = httpService.getVirtualServer();
        List httpListenerList = httpService.getHttpListener();
        for (VirtualServer virtualServer : virtualServerList) {
            if (!virtualServer.getId().equals(vs.getId())) continue;
            String vsHttpListeners = virtualServer.getHttpListeners();
            List vsHttpListenerList = StringUtils.parseStringList((String)vsHttpListeners, (String)" ,");
            for (String vsHttpListener : vsHttpListenerList) {
                for (HttpListener httpListener : httpListenerList) {
                    if (!httpListener.getId().equals(vsHttpListener) || !Boolean.valueOf(httpListener.getEnabled()).booleanValue() || Boolean.valueOf(httpListener.getSecurityEnabled()) != securityEnabled) continue;
                    String serverName = httpListener.getServerName();
                    if (serverName == null || serverName.trim().equals("")) {
                        serverName = this.getDefaultHostName();
                    }
                    String portStr = httpListener.getPort();
                    String redirPort = httpListener.getRedirectPort();
                    if (redirPort != null && !redirPort.trim().equals("")) {
                        portStr = redirPort;
                    }
                    int port = Integer.parseInt(portStr);
                    return new HostAndPort(serverName, port, securityEnabled);
                }
            }
        }
        return null;
    }

    private HostAndPort getHostAndPort(HttpService httpService, boolean securityEnabled) {
        List httpListenerList = httpService.getHttpListener();
        for (HttpListener httpListener : httpListenerList) {
            if (!Boolean.valueOf(httpListener.getEnabled()).booleanValue() || httpListener.getDefaultVirtualServer().equals("__asadmin") || Boolean.valueOf(httpListener.getSecurityEnabled()) != securityEnabled) continue;
            String serverName = httpListener.getServerName();
            if (serverName == null || serverName.trim().equals("")) {
                serverName = this.getDefaultHostName();
            }
            String portStr = httpListener.getPort();
            String redirPort = httpListener.getRedirectPort();
            if (redirPort != null && !redirPort.trim().equals("")) {
                portStr = redirPort;
            }
            int port = Integer.parseInt(portStr);
            return new HostAndPort(serverName, port, securityEnabled);
        }
        return null;
    }

    private HostAndPort getHostAndPort(HttpService httpService) {
        return this.getHostAndPort(httpService, false);
    }

    private String getDefaultHostName() {
        String defaultHostName = "localhost";
        try {
            InetAddress host = InetAddress.getLocalHost();
            defaultHostName = host.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return defaultHostName;
    }
}

