/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.AbstractCommand;
import com.sun.enterprise.admin.cli.AsadminMain;
import com.sun.enterprise.admin.cli.Log;
import com.sun.enterprise.admin.cli.remote.CLIRemoteCommand;
import com.sun.enterprise.admin.cli.remote.CommandInvoker;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherFactory;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StartDomainCommand
extends AbstractCommand {
    private GFLauncherInfo info;

    @Override
    public void runCommand() throws CommandException, CommandValidationException {
        String gfejar = System.getenv("GFE_JAR");
        if (gfejar != null && gfejar.length() > 0) {
            this.runCommandEmbedded();
        } else {
            this.runCommandNotEmbedded();
        }
    }

    private void runCommandNotEmbedded() throws CommandException, CommandValidationException {
        try {
            String parent;
            this.validateOptions();
            GFLauncher launcher = GFLauncherFactory.getInstance((GFLauncherFactory.ServerType)GFLauncherFactory.ServerType.domain);
            this.info = launcher.getInfo();
            if (!this.operands.isEmpty()) {
                this.info.setDomainName((String)this.operands.firstElement());
            }
            if ((parent = this.getOption("domaindir")) != null) {
                this.info.setDomainParentDir(parent);
            }
            boolean verbose = this.getBooleanOption("verbose");
            boolean watchdog = !this.getBooleanOption("nowatchdog");
            this.info.setVerbose(verbose);
            this.info.setWatchdog(watchdog);
            this.info.setDebug(this.getBooleanOption("debug"));
            launcher.setup();
            if (this.isServerAlive(this.info.getAdminPorts())) {
                String port = this.info.getAdminPorts().toArray(new Integer[0])[0] + "";
                String msg = this.getLocalizedString("ServerRunning", new String[]{this.info.getDomainName(), port});
                throw new CommandException(msg);
            }
            if (watchdog && !verbose && System.getProperty("GF_FINAL_WATCHDOG_PROCESS") == null) {
                Log.info("watchdog_launch", new Object[0]);
                this.runWatchdogProcess(launcher);
                this.waitForDAS(this.info.getAdminPorts());
                this.report(this.info);
                return;
            }
            if (watchdog) {
                Log.info("watchdog_running", new Object[0]);
            }
            launcher.launch();
            if (watchdog) {
                Log.info("watchdog_running", new Object[0]);
                while (launcher.getExitValue() == 10) {
                    Log.info("restart", new Object[0]);
                    launcher.launch();
                }
            } else if (!verbose) {
                this.waitForDAS(this.info.getAdminPorts());
                this.report(this.info);
            }
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
        catch (MiniXmlParserException me) {
            throw new CommandException(me);
        }
    }

    private void runCommandEmbedded() throws CommandException, CommandValidationException {
        try {
            GFLauncher launcher = null;
            launcher = GFLauncherFactory.getInstance((GFLauncherFactory.ServerType)GFLauncherFactory.ServerType.embedded);
            this.info = launcher.getInfo();
            if (!this.operands.isEmpty()) {
                this.info.setDomainName((String)this.operands.firstElement());
            } else {
                this.info.setDomainName("domain1");
            }
            String parent = this.getOption("domaindir");
            if (parent != null) {
                this.info.setDomainParentDir(parent);
            } else {
                this.info.setDomainParentDir(System.getenv("S1AS_HOME") + "/domains");
            }
            boolean verbose = this.getBooleanOption("verbose");
            this.info.setVerbose(verbose);
            this.info.setDebug(this.getBooleanOption("debug"));
            launcher.setup();
            Set ports = this.info.getAdminPorts();
            if (this.isServerAlive(ports)) {
                throw new CommandException("The Admin port is already taken: ");
            }
            launcher.launch();
            this.waitForDAS(ports);
            this.report(this.info);
        }
        catch (GFLauncherException gfle) {
            throw new CommandException(gfle.getMessage());
        }
        catch (MiniXmlParserException me) {
            throw new CommandException(me);
        }
    }

    private void runWatchdogProcess(GFLauncher launcher) throws GFLauncherException {
        String[] args;
        LinkedList<String> cmdline = new LinkedList<String>();
        cmdline.add("-cp");
        cmdline.add(System.getProperty("java.class.path"));
        cmdline.add("-DGF_FINAL_WATCHDOG_PROCESS=true");
        cmdline.add(this.getClass().getPackage().getName() + ".ASWatchdog");
        for (String arg : args = AsadminMain.getArgs()) {
            cmdline.add(arg);
        }
        launcher.launchJVM(cmdline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForDAS(Set<Integer> ports) throws CommandException {
        try {
            CLILogger.getInstance().pushAndLockLevel(Level.WARNING);
            if (ports == null || ports.size() <= 0) {
                String msg = this.getLocalizedString("noPorts");
                throw new CommandException(this.getLocalizedString("CommandUnSuccessfulWithArg", new Object[]{this.name, msg}));
            }
            long startWait = System.currentTimeMillis();
            Log.info("WaitDAS", new Object[0]);
            boolean alive = false;
            block5: while (!this.timedOut(startWait)) {
                for (int port : ports) {
                    if (!this.isServerAlive(port)) continue;
                    alive = true;
                    break block5;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {}
            }
            if (!alive) {
                Object[] objs = new Object[]{this.info.getDomainName(), 90L};
                String msg = this.getLocalizedString("dasNoStart", objs);
                throw new CommandException(msg);
            }
        }
        finally {
            CLILogger.getInstance().popAndUnlockLevel();
        }
    }

    private boolean isServerAlive(int port) {
        CommandInvoker invoker = new CommandInvoker("version");
        invoker.put("port", "" + port);
        invoker.put("user", this.getOption("user"));
        invoker.put("passwordfile", this.getOption("passwordfile"));
        return CLIRemoteCommand.pingDASQuietly(invoker);
    }

    private boolean isServerAlive(Set<Integer> ports) {
        if (ports == null || ports.size() == 0) {
            return false;
        }
        return this.isServerAlive(ports.toArray(new Integer[0])[0]);
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 90000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void report(GFLauncherInfo info) {
        CLILogger lg = CLILogger.getInstance();
        try {
            lg.pushAndLockLevel(Level.INFO);
            String msg = this.getLocalizedString("DomainLocation", new String[]{info.getDomainName(), info.getDomainRootDir().getAbsolutePath()});
            lg.printMessage(msg);
            Integer ap = -1;
            try {
                ap = info.getAdminPorts().toArray(new Integer[0])[0];
            }
            catch (Exception e) {
                // empty catch block
            }
            msg = this.getLocalizedString("DomainAdminPort", new String[]{"" + ap});
            lg.printMessage(msg);
        }
        finally {
            lg.popAndUnlockLevel();
        }
    }
}

