/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.ApplicationConfig;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.WebServiceEndpoint;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.admin.config.Property;
import org.glassfish.api.admin.config.PropertyBag;
import org.glassfish.api.amx.AMXConfigInfo;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.component.Injectable;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@AMXConfigInfo(amxInterfaceName="com.sun.appserv.management.config.ApplicationConfig")
@Configured
public interface Application
extends ConfigBeanProxy,
Injectable,
Named,
PropertyBag {
    @Attribute(required=true)
    public String getContextRoot();

    public void setContextRoot(String var1) throws PropertyVetoException;

    @Attribute(required=true)
    public String getLocation();

    public void setLocation(String var1) throws PropertyVetoException;

    @Attribute
    public String getObjectType();

    public void setObjectType(String var1) throws PropertyVetoException;

    @Attribute
    public String getEnabled();

    public void setEnabled(String var1) throws PropertyVetoException;

    @Attribute
    public String getLibraries();

    public void setLibraries(String var1) throws PropertyVetoException;

    @Attribute
    public String getAvailabilityEnabled();

    public void setAvailabilityEnabled(String var1) throws PropertyVetoException;

    @Attribute
    public String getDirectoryDeployed();

    public void setDirectoryDeployed(String var1) throws PropertyVetoException;

    @Attribute
    public String getDescription();

    public void setDescription(String var1) throws PropertyVetoException;

    @Element(value="*")
    public List<Module> getModule();

    @Element(required=true)
    public List<Engine> getEngine();

    @Element
    public List<WebServiceEndpoint> getWebServiceEndpoint();

    @Element(value="*")
    public List<ApplicationConfig> getApplicationConfigs();

    @DuckTyped
    public <T extends ApplicationConfig> T getApplicationConfig(Class<T> var1);

    @DuckTyped
    public Module getModule(String var1);

    @DuckTyped
    public Properties getDeployProperties();

    @DuckTyped
    public DeployCommandParameters getDeployParameters(ApplicationRef var1);

    @DuckTyped
    public Map<String, Properties> getModulePropertiesMap();

    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Duck {
        public static <T extends ApplicationConfig> T getApplicationConfig(Application me, Class<T> type) {
            return Duck.getApplicationConfig(me.getApplicationConfigs(), type);
        }

        public static <T extends ApplicationConfig> T getApplicationConfig(List<ApplicationConfig> candidates, Class<T> type) {
            for (ApplicationConfig ac : candidates) {
                if (!type.isInstance(ac)) continue;
                return (T)ac;
            }
            return null;
        }

        public static Module getModule(Application instance, String name) {
            for (Module module : instance.getModule()) {
                if (!module.getName().equals(name)) continue;
                return module;
            }
            return null;
        }

        public static Properties getDeployProperties(Application instance) {
            Properties deploymentProps = new Properties();
            for (Property prop : instance.getProperty()) {
                deploymentProps.put(prop.getName(), prop.getValue());
            }
            deploymentProps.setProperty("object-type", instance.getObjectType());
            return deploymentProps;
        }

        public static DeployCommandParameters getDeployParameters(Application app, ApplicationRef appRef) {
            if (appRef == null) {
                throw new IllegalArgumentException("Null appRef passed");
            }
            DeployCommandParameters deploymentParams = new DeployCommandParameters(new File(app.getLocation()));
            deploymentParams.name = app.getName();
            deploymentParams.enabled = Boolean.parseBoolean(app.getEnabled());
            deploymentParams.contextRoot = app.getContextRoot();
            deploymentParams.libraries = app.getLibraries();
            deploymentParams.virtualservers = appRef.getVirtualServers();
            return deploymentParams;
        }

        public static Map<String, Properties> getModulePropertiesMap(Application me) {
            HashMap<String, Properties> modulePropertiesMap = new HashMap<String, Properties>();
            for (Module module : me.getModule()) {
                if (module.getProperty() == null) continue;
                Properties moduleProps = new Properties();
                for (Property property : module.getProperty()) {
                    moduleProps.put(property.getName(), property.getValue());
                }
                modulePropertiesMap.put(module.getName(), moduleProps);
            }
            return modulePropertiesMap;
        }
    }
}

