/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.PersistenceArchivist;
import com.sun.enterprise.deployment.util.XModuleType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXParseException;

@Service
public class WarPersistenceArchivist
extends PersistenceArchivist {
    public boolean supportsModuleType(XModuleType moduleType) {
        return XModuleType.WAR == moduleType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object open(Archivist main, ReadableArchive archive, RootDeploymentDescriptor descriptor) throws IOException, SAXParseException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.logp(Level.FINE, "EjbArchivist", "readPersistenceDeploymentDescriptors", "archive = {0}", archive.getURI());
        }
        HashMap<String, ReadableArchive> subArchives = new HashMap<String, ReadableArchive>();
        Enumeration entries = archive.entries();
        String CLASSES_DIR = "WEB-INF/classes/";
        String LIB_DIR = "WEB-INF/lib/";
        String JAR_EXT = ".jar";
        try {
            ReadableArchive libArchive = archive.getSubArchive("WEB-INF/lib/");
            if (libArchive != null) {
                Enumeration libEntries = libArchive.entries();
                while (libEntries.hasMoreElements()) {
                    String path = (String)libEntries.nextElement();
                    if (!path.endsWith(".jar")) continue;
                    if (path.indexOf(47) == -1) {
                        try {
                            subArchives.put("WEB-INF/lib//" + path, libArchive.getSubArchive(path));
                        }
                        catch (IOException ioe) {
                            this.logger.log(Level.SEVERE, ioe.getMessage(), ioe);
                        }
                        continue;
                    }
                    if (!this.logger.isLoggable(Level.FINE)) continue;
                    this.logger.logp(Level.FINE, "EjbArchivist", "readPersistenceDeploymentDescriptors", "skipping {0} as it exists inside a directory in {1}.", new Object[]{path, "WEB-INF/lib/"});
                }
            }
            String pathOfPersistenceXMLInsideClassesDir = "WEB-INF/classes/META-INF/persistence.xml";
            InputStream is = archive.getEntry("WEB-INF/classes/META-INF/persistence.xml");
            if (is != null) {
                is.close();
                subArchives.put("WEB-INF/classes/", archive.getSubArchive("WEB-INF/classes/"));
            }
            for (Map.Entry pathToArchiveEntry : subArchives.entrySet()) {
                this.readPersistenceDeploymentDescriptor(main, (ReadableArchive)pathToArchiveEntry.getValue(), (String)pathToArchiveEntry.getKey(), descriptor);
            }
        }
        finally {
            for (ReadableArchive subArchive : subArchives.values()) {
                subArchive.close();
            }
        }
        return null;
    }
}

