/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.StopDomainCommand;
import java.util.Collection;
import org.glassfish.api.Async;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;

@Service(name="restart-domain")
@Async
@I18n(value="restart.domain.command")
public class RestartDomainCommand
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(StopDomainCommand.class);
    @Inject
    ModulesRegistry registry;

    public void execute(AdminCommandContext context) {
        if (!this.isRestartAllowed()) {
            context.getLogger().severe(localStrings.getLocalString("restart.domain.not_enabled", "The server was not started with a watchdog. Restart is not possible.  Try stopping and then locally starting the server."));
            return;
        }
        context.getLogger().info(localStrings.getLocalString("restart.domain.init", "Server restart initiated"));
        Collection modules = this.registry.getModules("com.sun.enterprise.osgi-adapter");
        if (modules.size() == 1) {
            Module mgmtAgentModule = (Module)modules.iterator().next();
            mgmtAgentModule.stop();
        } else {
            context.getLogger().warning(modules.size() + " no of primordial modules found");
        }
        System.exit(10);
    }

    boolean isRestartAllowed() {
        String s = System.getProperty("hk2.startup.context.args");
        return s != null && s.indexOf("-watchdog=true") >= 0;
    }
}

