/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.config;

import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.config.ContextMapper;
import com.sun.grizzly.config.ContextRootInfo;
import com.sun.grizzly.config.GrizzlyEmbeddedHttp;
import com.sun.grizzly.config.HttpParserState;
import com.sun.grizzly.config.HttpUtils;
import com.sun.grizzly.http.HttpProtocolChain;
import com.sun.grizzly.http.HttpWorkerThread;
import com.sun.grizzly.http.ProcessorTask;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.StaticResourcesAdapter;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.WorkerThread;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.buf.UDecoder;
import com.sun.grizzly.util.http.HttpRequestURIDecoder;
import com.sun.grizzly.util.http.mapper.Mapper;
import com.sun.grizzly.util.http.mapper.MappingData;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrizzlyMappingAdapter
extends StaticResourcesAdapter {
    protected ContextMapper mapper;
    private GrizzlyEmbeddedHttp grizzlyEmbeddedHttp;
    protected UDecoder urlDecoder = new UDecoder();
    private String defaultHostName = "server";

    @Override
    public String getRootFolder() {
        return GrizzlyEmbeddedHttp.getWebAppRootPath();
    }

    public GrizzlyEmbeddedHttp getGrizzlyEmbeddedHttp() {
        return this.grizzlyEmbeddedHttp;
    }

    public void setGrizzlyEmbeddedHttp(GrizzlyEmbeddedHttp embeddedHttp) {
        this.grizzlyEmbeddedHttp = embeddedHttp;
    }

    public void setDefaultHost(String defaultHost) {
        this.defaultHostName = defaultHost;
    }

    public void setMapper(ContextMapper mapper) {
        this.mapper = mapper;
    }

    public synchronized void configureMapper() {
        this.mapper.setDefaultHostName(this.defaultHostName);
        Mapper.setAllowReplacement(true);
    }

    public boolean map(SelectionKey selectionKey, ByteBuffer byteBuffer, HttpProtocolChain protocolChain, List<ProtocolFilter> defaultProtocolFilters, ContextRootInfo fallbackContextRootInfo) throws Exception {
        HttpParserState state = new HttpParserState();
        state.setBuffer(byteBuffer);
        byte[] contextBytes = null;
        byte[] hostBytes = null;
        contextBytes = HttpUtils.readRequestLine(selectionKey, state, InputReader.getDefaultReadTimeout());
        if (contextBytes != null) {
            state.setState(0);
            hostBytes = HttpUtils.readHost(selectionKey, state, InputReader.getDefaultReadTimeout());
        }
        if (contextBytes == null) {
            return false;
        }
        MessageBytes decodedURI = MessageBytes.newInstance();
        decodedURI.setBytes(contextBytes, 0, contextBytes.length);
        MessageBytes hostMB = MessageBytes.newInstance();
        if (hostBytes != null) {
            hostMB.setBytes(hostBytes, 0, hostBytes.length);
        }
        try {
            HttpRequestURIDecoder.decode(decodedURI, this.urlDecoder, (String)this.grizzlyEmbeddedHttp.getProperty("uriEncoding"), null);
        }
        catch (Exception ex) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.log(Level.WARNING, "Invalid url", ex);
            }
            return false;
        }
        HttpUtils.parseHost(hostMB, ((SocketChannel)selectionKey.channel()).socket());
        MappingData mappingData = new MappingData();
        this.mapper.map(hostMB, decodedURI, mappingData);
        Adapter adapter = null;
        ContextRootInfo contextRootInfo = null;
        if (mappingData.context != null && mappingData.context instanceof ContextRootInfo) {
            contextRootInfo = (ContextRootInfo)mappingData.context;
            adapter = contextRootInfo.getAdapter();
        } else if (mappingData.context != null && "com.sun.enterprise.web.WebModule".equals(mappingData.context.getClass().getName())) {
            MessageBytes fullDecodedUri = MessageBytes.newInstance();
            fullDecodedUri.duplicate(decodedURI);
            fullDecodedUri.toBytes();
            WorkerThread workerThread = (WorkerThread)Thread.currentThread();
            workerThread.getAttachment().setAttribute("mappingData", mappingData);
            workerThread.getAttachment().setAttribute("decodedURI", fullDecodedUri);
            adapter = this.mapper.getAdapter();
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("MAP (" + this + ") contextRoot: " + new String(contextBytes) + " defaultProtocolFilters: " + defaultProtocolFilters + " fallback: " + fallbackContextRootInfo + " adapter: " + adapter + " mappingData.context " + mappingData.context);
        }
        if (adapter == null && fallbackContextRootInfo != null) {
            adapter = fallbackContextRootInfo.getAdapter();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Fallback adapter is taken: " + adapter);
            }
        }
        if (adapter == null) {
            return false;
        }
        this.bindAdapter(adapter);
        this.postMap(protocolChain, defaultProtocolFilters, fallbackContextRootInfo, contextRootInfo);
        return true;
    }

    protected void postMap(HttpProtocolChain protocolChain, List<ProtocolFilter> defaultProtocolFilters, ContextRootInfo fallbackContextRootInfo, ContextRootInfo contextRootInfo) {
    }

    private Adapter bindAdapter(Adapter adapter) {
        this.bindProcessorTask(adapter);
        return adapter;
    }

    private void bindProcessorTask(Adapter adapter) {
        HttpWorkerThread workerThread = (HttpWorkerThread)Thread.currentThread();
        ProcessorTask processorTask = workerThread.getProcessorTask();
        if (processorTask == null) {
            try {
                processorTask = this.grizzlyEmbeddedHttp.getProcessorTask();
            }
            catch (ClassCastException ex) {
                this.logger.log(Level.SEVERE, "Invalid ProcessorTask instance", ex);
            }
            workerThread.setProcessorTask(processorTask);
        }
        processorTask.setAdapter(adapter);
    }
}

