/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SnmpInformRequest;
import com.sun.management.comm.SnmpQManager;

final class SnmpTimerServer
extends Thread {
    private static final String dbgTag = "SnmpTimerServer";
    private SnmpInformRequest req = null;
    SnmpQManager snmpq = null;
    boolean isBeingDestroyed = false;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "SnmpTimerServer");

    public SnmpTimerServer(ThreadGroup grp, SnmpQManager q) {
        super(grp, dbgTag);
        this.setName(dbgTag);
        this.snmpq = q;
        this.start();
    }

    public synchronized void stopTimerServer() {
        if (this.isAlive()) {
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        Thread.currentThread().setPriority(5);
        if (logger.finerOn()) {
            logger.finer("run", "Timer Thread started");
        }
        while (true) {
            try {
                do {
                    if (logger.finerOn()) {
                        logger.finer("run", "Blocking for inform requests");
                    }
                    if (this.req == null) {
                        this.req = this.snmpq.getTimeoutRequests();
                    }
                    if (this.req != null && this.req.inProgress()) {
                        if (logger.finerOn()) {
                            logger.finer("run", "Handle timeout inform request " + this.req.getRequestId());
                        }
                        this.req.action();
                        this.req = null;
                    }
                    if (this.req == null || !this.req.isAborted()) continue;
                    this.req = null;
                } while (!this.isBeingDestroyed);
            }
            catch (Exception e) {
                if (!logger.finestOn()) continue;
                logger.finest("run", e.toString());
                continue;
            }
            catch (ThreadDeath d) {
                if (logger.finestOn()) {
                    logger.finest("run", "Timer server unexpectedly shutting down");
                    logger.finest("run", d);
                }
                throw d;
            }
            catch (OutOfMemoryError ome) {
                if (logger.finestOn()) {
                    logger.finest("run", "Received OutOfMemory");
                }
                SnmpTimerServer.yield();
                continue;
            }
            catch (Error err) {
                if (!logger.finestOn()) continue;
                logger.finest("run", "Received Internal error");
                logger.finest("run", err);
                continue;
            }
            break;
        }
    }
}

