/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.comm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.comm.SnmpQManager;
import com.sun.management.comm.SnmpResponseHandler;
import com.sun.management.comm.SnmpV3AdaptorServer;
import com.sun.management.comm.SnmpV3InformRequest;
import com.sun.management.internal.snmp.SnmpEngineImpl;
import com.sun.management.internal.snmp.SnmpIncomingResponse;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.internal.snmp.SnmpSecurityCache;
import com.sun.management.snmp.SnmpMsg;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpPduRequestType;
import com.sun.management.snmp.SnmpSecurityException;
import java.net.DatagramPacket;

class SnmpV3ResponseHandler
extends SnmpResponseHandler {
    SnmpV3AdaptorServer v3adaptor = null;
    SnmpSecurityCache cache = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.adaptor", "SnmpV3ResponseHandler");

    public SnmpV3ResponseHandler(SnmpV3AdaptorServer adp, SnmpQManager s) {
        super(adp, s);
        this.v3adaptor = adp;
    }

    public void setSecurityCache(SnmpSecurityCache cache) {
        this.cache = cache;
    }

    public synchronized void processDatagram(DatagramPacket dgrm) {
        block12: {
            byte[] data = dgrm.getData();
            int datalen = dgrm.getLength();
            if (logger.finerOn()) {
                logger.finer("processDatagram", "Received from peer " + dgrm.getAddress().toString() + " Length = " + datalen + "\nDump : \n" + SnmpMsg.dumpHexBuffer(data, 0, datalen));
            }
            try {
                SnmpEngineImpl eng = (SnmpEngineImpl)this.v3adaptor.getEngine();
                int version = SnmpMsg.getProtocolVersion(dgrm.getData());
                SnmpPduFactory pduFactory = this.v3adaptor.getPduFactory();
                if (pduFactory == null) {
                    if (logger.finestOn()) {
                        logger.finest("processDatagram", "Dropping packet. Unable to find the pdu factory of the SNMP adaptor server");
                    }
                    break block12;
                }
                SnmpMsgProcessingSubSystem msgsys = eng.getMsgProcessingSubSystem();
                SnmpIncomingResponse resp = msgsys.getIncomingResponse(version, pduFactory);
                int msgId = resp.getRequestId(data);
                SnmpV3InformRequest req = (SnmpV3InformRequest)this.snmpq.removeRequest(msgId);
                resp.setSecurityCache(this.cache);
                try {
                    resp.decodeMessage(data, datalen, dgrm.getAddress(), dgrm.getPort());
                }
                catch (SnmpSecurityException e) {
                    if (logger.finestOn()) {
                        logger.finest("processDatagram", "Security Exception when unmarshalling, status: " + e.status);
                    }
                    req.setErrorStatusAndIndex(e.status, 0);
                    req.invokeOnResponse(null);
                    return;
                }
                SnmpPdu snmpProt = resp.decodeSnmpPdu();
                if (snmpProt == null) {
                    if (logger.finestOn()) {
                        logger.finest("processDatagram", "Dropping packet. Pdu factory returned a null value");
                    }
                    return;
                }
                if (!(snmpProt instanceof SnmpPduRequestType)) {
                    if (logger.finestOn()) {
                        logger.finest("processDatagram", "Dropping packet. The packet does not contain a response");
                    }
                    snmpProt = null;
                    return;
                }
                SnmpPdu pduReq = snmpProt;
                req.invokeOnResponse(pduReq);
            }
            catch (Exception e) {
                if (!logger.finestOn()) break block12;
                logger.finest("processDatagram", "Exception while processsing");
                logger.finest("processDatagram", e);
            }
        }
    }
}

