/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.internal.snmp;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpAccessControlModel;
import com.sun.management.internal.snmp.SnmpModelImpl;
import com.sun.management.internal.snmp.SnmpSubSystem;
import com.sun.management.snmp.InetAddressAcl;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.UserAcl;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SnmpJdmkAcm
extends SnmpModelImpl
implements SnmpAccessControlModel {
    private InetAddressAcl ipacl = null;
    private boolean activatev3 = true;
    private boolean v1v2setrequest = false;
    private UserAcl useracl = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpJdmkAcm");
    String dbgTag = "SnmpJdmkAcm";

    public SnmpJdmkAcm(SnmpSubSystem sys, InetAddressAcl ipacl, UserAcl useracl, boolean activatev3) {
        super(sys, "User based");
        this.ipacl = ipacl;
        this.useracl = useracl;
        sys.addModel(0, this);
        sys.addModel(1, this);
        this.activatev3 = activatev3;
        if (activatev3) {
            sys.addModel(3, this);
        }
    }

    private boolean isV3Activated() {
        return this.activatev3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPduAccess(int version, String principal, int securityLevel, int pduType, int securityModel, byte[] contextName, SnmpPdu pdu) throws SnmpStatusException {
        if (logger.finerOn()) {
            logger.finer("checkPduAccess", "sender is " + principal + " with " + new String(contextName));
        }
        if (contextName == null) {
            throw new SnmpStatusException(16);
        }
        switch (version) {
            case 0: 
            case 1: {
                if (this.isV3Activated()) {
                    if (pduType == 163) {
                        SnmpJdmkAcm snmpJdmkAcm = this;
                        synchronized (snmpJdmkAcm) {
                            if (!this.isSnmpV1V2SetRequestAuthorized()) {
                                if (logger.finerOn()) {
                                    logger.finer("checkPduAccess", "sender is " + principal + " with " + new String(contextName) + " \n SNMP V1 and V2 set requests disable. Access not granted.");
                                }
                                throw new SnmpStatusException(16);
                            }
                        }
                    }
                    this.checkIPAcl(contextName, principal, pduType);
                    break;
                }
                this.checkIPAcl(contextName, principal, pduType);
                break;
            }
            case 3: {
                this.checkUserAcl(contextName, principal, pduType, securityLevel);
                break;
            }
            default: {
                if (logger.finestOn()) {
                    logger.finest("checkPduAccess", "Unsupported protocol version.");
                }
                throw new SnmpStatusException(4);
            }
        }
    }

    public void checkAccess(int version, String principal, int securityLevel, int pduType, int securityModel, byte[] contextName, SnmpOid oid) throws SnmpStatusException {
    }

    private void checkIPAcl(byte[] contextName, String principal, int type) throws SnmpStatusException {
        String community = new String(contextName);
        if (logger.finerOn()) {
            logger.finer("checkIPAcl", "sender is " + principal + " with " + community);
        }
        InetAddress address = null;
        try {
            address = InetAddress.getByName(principal);
        }
        catch (UnknownHostException e) {
            if (logger.finerOn()) {
                logger.finer("checkIPAcl", "sender is " + address + " with " + community);
                logger.finer("checkIPAcl", "Bad IP address");
            }
            throw new SnmpStatusException(4);
        }
        if (this.ipacl != null) {
            if (type == 163) {
                if (!this.ipacl.checkWritePermission(address, community)) {
                    if (logger.finerOn()) {
                        logger.finer("checkIPAcl", "sender is " + address + " with " + community);
                        logger.finer("checkIPAcl", "sender has no write permission");
                    }
                    throw new SnmpStatusException(4);
                }
                if (logger.finerOn()) {
                    logger.finer("checkIPAcl", "sender is " + address + " with " + community);
                    logger.finer("checkIPAcl", "sender has write permission");
                }
            } else {
                if (!this.ipacl.checkReadPermission(address, community)) {
                    if (logger.finerOn()) {
                        logger.finer("checkIPAcl", "sender is " + address + " with " + community);
                        logger.finer("checkIPAcl", "sender has no read permission");
                    }
                    throw new SnmpStatusException(2);
                }
                if (logger.finerOn()) {
                    logger.finer("checkIPAcl", "sender is " + address + " with " + community);
                    logger.finer("checkIPAcl", "sender has read permission");
                }
            }
        }
    }

    private void checkUserAcl(byte[] contextName, String principal, int type, int securityLevel) throws SnmpStatusException {
        String context = null;
        if (contextName.length != 0) {
            context = new String(contextName);
        } else {
            if (logger.finerOn()) {
                logger.finer("checkUserAcl", "Received a null context");
            }
            context = "null";
        }
        if (logger.finerOn()) {
            logger.finer("checkUserAcl", "sender is " + principal + " with [" + context + "], security level : " + securityLevel);
        }
        if (this.useracl != null) {
            if (type == 163) {
                if (!this.useracl.checkWritePermission(principal, context, securityLevel)) {
                    if (logger.finerOn()) {
                        logger.finer("checkUserAcl", "sender is " + principal + " with " + context);
                        logger.finer("checkUserAcl", "sender has no write permission");
                    }
                    throw new SnmpStatusException(16);
                }
                if (logger.finerOn()) {
                    logger.finer("checkUserAcl", "sender is " + principal + " with " + context);
                    logger.finer("checkUserAcl", "sender has write permission");
                }
            } else {
                if (!this.useracl.checkReadPermission(principal, context, securityLevel)) {
                    if (logger.finerOn()) {
                        logger.finer("checkUserAcl", "sender is " + principal + " with " + context);
                        logger.finer("checkUserAcl", "sender has no read permission");
                    }
                    throw new SnmpStatusException(16);
                }
                if (logger.finerOn()) {
                    logger.finer("checkUserAcl", "sender is " + principal + " with " + context);
                    logger.finer("checkUserAcl", "sender has read permission");
                }
            }
        }
    }

    public synchronized boolean enableSnmpV1V2SetRequest() {
        this.v1v2setrequest = true;
        return true;
    }

    public synchronized boolean disableSnmpV1V2SetRequest() {
        this.v1v2setrequest = false;
        return true;
    }

    public synchronized boolean isSnmpV1V2SetRequestAuthorized() {
        return this.v1v2setrequest;
    }
}

