/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.agent;

import com.sun.management.snmp.SnmpEngine;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.agent.SnmpMibAgentMBean;
import com.sun.management.snmp.agent.SnmpMibHandler;
import com.sun.management.snmp.agent.SnmpMibRequest;
import com.sun.management.snmp.agent.SnmpMibRequestImpl;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.ServiceNotFoundException;

public abstract class SnmpMibAgent
implements SnmpMibAgentMBean,
MBeanRegistration,
Serializable {
    protected String mibName;
    protected MBeanServer server;
    private ObjectName adaptorName;
    private transient SnmpMibHandler adaptor;

    public abstract void init() throws IllegalAccessException;

    public abstract ObjectName preRegister(MBeanServer var1, ObjectName var2) throws Exception;

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }

    public void get(SnmpMibRequest req) throws SnmpStatusException {
    }

    public void getNext(SnmpMibRequest req) throws SnmpStatusException {
    }

    public void getBulk(SnmpMibRequest req, int nonRepeat, int maxRepeat) throws SnmpStatusException {
    }

    public void set(SnmpMibRequest req) throws SnmpStatusException {
    }

    public void check(SnmpMibRequest req) throws SnmpStatusException {
    }

    public abstract long[] getRootOid();

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public SnmpMibHandler getSnmpAdaptor() {
        return this.adaptor;
    }

    public void setSnmpAdaptor(SnmpMibHandler stack) {
        if (this.adaptor != null) {
            this.adaptor.removeMib(this);
        }
        this.adaptor = stack;
        if (this.adaptor != null) {
            this.adaptor.addMib(this);
        }
    }

    public void setSnmpAdaptor(SnmpMibHandler stack, SnmpOid[] oids) {
        if (this.adaptor != null) {
            this.adaptor.removeMib(this);
        }
        this.adaptor = stack;
        if (this.adaptor != null) {
            this.adaptor.addMib(this, oids);
        }
    }

    public void setSnmpAdaptor(SnmpMibHandler stack, String contextName) {
        if (this.adaptor != null) {
            this.adaptor.removeMib(this, contextName);
        }
        this.adaptor = stack;
        if (this.adaptor != null) {
            this.adaptor.addMib(this, contextName);
        }
    }

    public void setSnmpAdaptor(SnmpMibHandler stack, String contextName, SnmpOid[] oids) {
        if (this.adaptor != null) {
            this.adaptor.removeMib(this, contextName);
        }
        this.adaptor = stack;
        if (this.adaptor != null) {
            this.adaptor.addMib(this, contextName, oids);
        }
    }

    public ObjectName getSnmpAdaptorName() {
        return this.adaptorName;
    }

    public void setSnmpAdaptorName(ObjectName name) throws InstanceNotFoundException, ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException(this.mibName + " is not registered in the MBean server");
        }
        if (this.adaptor != null) {
            this.adaptor.removeMib(this);
        }
        Object[] params = new Object[]{this};
        String[] signature = new String[]{"com.sun.management.snmp.agent.SnmpMibAgent"};
        try {
            this.adaptor = (SnmpMibHandler)this.server.invoke(name, "addMib", params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new InstanceNotFoundException(name.toString());
        }
        catch (ReflectionException e) {
            throw new ServiceNotFoundException(name.toString());
        }
        catch (MBeanException e) {
            // empty catch block
        }
        this.adaptorName = name;
    }

    public void setSnmpAdaptorName(ObjectName name, SnmpOid[] oids) throws InstanceNotFoundException, ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException(this.mibName + " is not registered in the MBean server");
        }
        if (this.adaptor != null) {
            this.adaptor.removeMib(this);
        }
        Object[] params = new Object[]{this, oids};
        String[] signature = new String[]{"com.sun.management.snmp.agent.SnmpMibAgent", oids.getClass().getName()};
        try {
            this.adaptor = (SnmpMibHandler)this.server.invoke(name, "addMib", params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new InstanceNotFoundException(name.toString());
        }
        catch (ReflectionException e) {
            throw new ServiceNotFoundException(name.toString());
        }
        catch (MBeanException e) {
            // empty catch block
        }
        this.adaptorName = name;
    }

    public void setSnmpAdaptorName(ObjectName name, String contextName) throws InstanceNotFoundException, ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException(this.mibName + " is not registered in the MBean server");
        }
        if (this.adaptor != null) {
            this.adaptor.removeMib(this, contextName);
        }
        Object[] params = new Object[]{this, contextName};
        String[] signature = new String[]{"com.sun.management.snmp.agent.SnmpMibAgent", "java.lang.String"};
        try {
            this.adaptor = (SnmpMibHandler)this.server.invoke(name, "addMib", params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new InstanceNotFoundException(name.toString());
        }
        catch (ReflectionException e) {
            throw new ServiceNotFoundException(name.toString());
        }
        catch (MBeanException e) {
            // empty catch block
        }
        this.adaptorName = name;
    }

    public void setSnmpAdaptorName(ObjectName name, String contextName, SnmpOid[] oids) throws InstanceNotFoundException, ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException(this.mibName + " is not registered in the MBean server");
        }
        if (this.adaptor != null) {
            this.adaptor.removeMib(this, contextName);
        }
        Object[] params = new Object[]{this, contextName, oids};
        String[] signature = new String[]{"com.sun.management.snmp.agent.SnmpMibAgent", "java.lang.String", oids.getClass().getName()};
        try {
            this.adaptor = (SnmpMibHandler)this.server.invoke(name, "addMib", params, signature);
        }
        catch (InstanceNotFoundException e) {
            throw new InstanceNotFoundException(name.toString());
        }
        catch (ReflectionException e) {
            throw new ServiceNotFoundException(name.toString());
        }
        catch (MBeanException e) {
            // empty catch block
        }
        this.adaptorName = name;
    }

    public boolean getBindingState() {
        return this.adaptor != null;
    }

    public String getMibName() {
        return this.mibName;
    }

    public static SnmpMibRequest newMibRequest(SnmpPdu reqPdu, Vector vblist, int version, Object userData) {
        return new SnmpMibRequestImpl(reqPdu, vblist, version, userData);
    }

    public static SnmpMibRequest newMibRequest(SnmpEngine engine, SnmpPdu reqPdu, Vector vblist, int version, Object userData, String principal, int securityLevel, int securityModel, byte[] contextName, byte[] accessContextName) {
        return new SnmpMibRequestImpl(engine, reqPdu, vblist, version, userData, principal, securityLevel, securityModel, contextName, accessContextName);
    }

    void getBulkWithGetNext(SnmpMibRequest req, int nonRepeat, int maxRepeat) throws SnmpStatusException {
        Vector list = req.getSubList();
        int L = list.size();
        int N = Math.max(Math.min(nonRepeat, L), 0);
        int M = Math.max(maxRepeat, 0);
        int R = L - N;
        if (L != 0) {
            this.getNext(req);
            Vector repeaters = this.splitFrom(list, N);
            SnmpMibRequestImpl repeatedReq = new SnmpMibRequestImpl(req.getEngine(), req.getPdu(), repeaters, 1, req.getUserData(), req.getPrincipal(), req.getSecurityLevel(), req.getSecurityModel(), req.getContextName(), req.getAccessContextName());
            for (int i = 2; i <= M; ++i) {
                this.getNext(repeatedReq);
                this.concatVector(req, repeaters);
            }
        }
    }

    private Vector splitFrom(Vector original, int limit) {
        int max = original.size();
        Vector<SnmpVarBind> result = new Vector<SnmpVarBind>(max - limit);
        int i = limit;
        Enumeration e = original.elements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = (SnmpVarBind)e.nextElement();
            if (i <= 0) {
                result.addElement(new SnmpVarBind(var.getOid(), var.getSnmpValue()));
            }
            --i;
        }
        return result;
    }

    private void concatVector(SnmpMibRequest req, Vector source) {
        Enumeration e = source.elements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = (SnmpVarBind)e.nextElement();
            req.addVarBind(new SnmpVarBind(var.getOid(), var.getSnmpValue()));
        }
    }

    private void concatVector(Vector target, Vector source) {
        Enumeration e = source.elements();
        while (e.hasMoreElements()) {
            SnmpVarBind var = (SnmpVarBind)e.nextElement();
            target.addElement(new SnmpVarBind(var.getOid(), var.getSnmpValue()));
        }
    }

    private static Vector vector(Enumeration e) {
        if (e == null) {
            return null;
        }
        Vector v = new Vector();
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
        return v;
    }
}

