/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.manager;

import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpVarBind;
import com.sun.management.snmp.SnmpVarBindList;
import com.sun.management.snmp.manager.SnmpPeer;
import com.sun.management.snmp.manager.SnmpRequest;
import com.sun.management.snmp.manager.SnmpRequestHandler;
import com.sun.management.snmp.manager.SnmpSession;

final class SnmpPollRequest
extends SnmpRequest {
    private static final long serialVersionUID = -9091304849536911338L;
    private SnmpOid oidKey = null;
    private SnmpVarBindList initialVarBindList = null;
    private int freq = -1;
    static int WALK_ROW_INTERVAL = 100;

    public SnmpPollRequest(SnmpSession group, SnmpPeer peer, SnmpRequestHandler requestCB, int cmd) throws SnmpStatusException {
        super(group, peer, requestCB, cmd);
    }

    public final synchronized String toString() {
        StringBuffer sb = new StringBuffer(200);
        sb.append(super.toString() + "\n");
        if (this.oidKey == null) {
            sb.append("Polling Mode. Frequency = " + this.freq);
        } else {
            sb.append("Mib walking facility");
        }
        return sb.toString();
    }

    public final synchronized void setPollFrequency(int sec, int milli) {
        this.freq = sec * 1000 + milli;
    }

    public final synchronized void setPollFrequency(int sec) {
        this.setPollFrequency(sec, 0);
    }

    public synchronized int getPollFrequency() {
        return this.freq;
    }

    public final synchronized void startPoll(SnmpVarBindList vblst, boolean copy, int when) throws SnmpStatusException {
        this.oidKey = null;
        this.initialVarBindList = vblst.cloneWithoutValue();
        this.start(vblst, true, when);
    }

    public final synchronized void startPoll(SnmpVarBindList vblst, SnmpOid key, boolean copy, int when) throws SnmpStatusException {
        this.oidKey = key;
        this.initialVarBindList = vblst.cloneWithoutValue();
        super.start(vblst, true, when);
    }

    synchronized void handleSuccess() {
        SnmpVarBindList nextpollvb = this.initialVarBindList;
        long nextpoll = this.getPollFrequency();
        if (this.oidKey != null) {
            if (!this.checkIfEndOfTable()) {
                nextpollvb = this.getVarBindList();
                nextpoll = WALK_ROW_INTERVAL;
            } else {
                nextpoll = -1L;
            }
        }
        super.handleSuccess();
        if (this.isAborted() || this.inProgress()) {
            return;
        }
        if (nextpoll < 0L) {
            this.deleteRequest();
            return;
        }
        nextpoll += this.getPollTimestamp();
        this.setErrorStatusAndIndex(0, 0);
        try {
            super.start(nextpollvb, true, nextpoll);
        }
        catch (SnmpStatusException e) {
            this.handleInternalError(e.toString() + "  While trying to continue polling.");
        }
    }

    final synchronized boolean checkIfEndOfTable() {
        SnmpVarBind avar = this.varBindList.getVarBindAt(0);
        if (avar.hasVarBindException() || avar.getOid().compareTo(this.oidKey) >= 0) {
            this.errorStatus = 229;
            return true;
        }
        return false;
    }

    private void init() {
        this.oidKey = null;
        this.initialVarBindList = null;
    }
}

