/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.usm.usmmib;

import com.sun.jdmk.defaults.Utils;
import com.sun.management.snmp.SnmpOid;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpString;
import com.sun.management.snmp.SnmpValue;
import com.sun.management.snmp.agent.SnmpIndex;
import com.sun.management.snmp.agent.SnmpMib;
import com.sun.management.snmp.agent.SnmpMibSubRequest;
import com.sun.management.snmp.agent.SnmpMibTable;
import com.sun.management.snmp.agent.SnmpTableSupport;
import com.sun.management.snmp.usm.usmmib.UsmUserEntry;
import com.sun.management.snmp.usm.usmmib.UsmUserEntryMBean;
import java.io.Serializable;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class TableUsmUserTable
extends SnmpTableSupport
implements Serializable {
    private static final long serialVersionUID = -3886886362591700055L;
    protected MBeanServer server;

    public TableUsmUserTable(SnmpMib myMib) {
        super(myMib);
    }

    public TableUsmUserTable(SnmpMib myMib, MBeanServer server) {
        this(myMib);
        this.server = server;
    }

    public void createNewEntry(SnmpMibSubRequest req, SnmpOid rowOid, int depth, SnmpMibTable meta) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(rowOid);
        Vector v = index.getComponents();
        try {
            SnmpOid oid0 = (SnmpOid)v.elementAt(0);
            SnmpOid oid1 = (SnmpOid)v.elementAt(1);
            ObjectName objname = null;
            if (this.server != null) {
                objname = this.buildNameFromIndex(index);
            }
            Object entry = this.createUsmUserEntryMBean(req, rowOid, depth, objname, meta, oid0.toByte(), oid1.toOctetString());
            if (this.server != null) {
                this.server.registerMBean(entry, objname);
            }
            meta.addEntry(rowOid, objname, entry);
        }
        catch (SnmpStatusException e) {
            throw e;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(10);
        }
        catch (Exception e) {
            SnmpStatusException st = new SnmpStatusException(e.getMessage());
            Utils.initCause(st, e);
            throw st;
        }
    }

    protected SnmpMibTable getRegisteredTableMeta(SnmpMib mib) {
        return mib.getRegisteredTableMeta("UsmUserTable");
    }

    public void removeEntryCb(int pos, SnmpOid row, ObjectName name, Object entry, SnmpMibTable meta) throws SnmpStatusException {
        try {
            super.removeEntryCb(pos, row, name, entry, meta);
            if (this.server != null && name != null) {
                this.server.unregisterMBean(name);
            }
        }
        catch (Exception x) {
            // empty catch block
        }
    }

    public synchronized void addEntry(UsmUserEntryMBean entry) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.addEntry(index, entry);
    }

    public synchronized void addEntry(UsmUserEntryMBean entry, ObjectName name) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.addEntry(index, name, entry);
    }

    public synchronized UsmUserEntryMBean[] getEntries() {
        Object[] array = this.getBasicEntries();
        UsmUserEntryMBean[] result = new UsmUserEntryMBean[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public void removeEntry(UsmUserEntryMBean entry) throws SnmpStatusException {
        SnmpIndex index = this.buildSnmpIndex(entry);
        super.removeEntry(index, entry);
    }

    public ObjectName buildNameFromIndex(SnmpIndex index) throws SnmpStatusException {
        Vector v = index.getComponents();
        try {
            SnmpOid oid = (SnmpOid)v.elementAt(0);
            String _keyUsmUserEngineID = oid.toByte().toString();
            oid = (SnmpOid)v.elementAt(1);
            String _keyUsmUserName = oid.toOctetString().toString();
            return new ObjectName("TableUsmUserTable:name=UsmUserEntry,UsmUserEngineID=" + _keyUsmUserEngineID + ",UsmUserName=" + _keyUsmUserName);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(10);
        }
        catch (Exception e) {
            SnmpStatusException st = new SnmpStatusException(e.getMessage());
            Utils.initCause(st, e);
            throw st;
        }
    }

    public SnmpIndex buildSnmpIndex(UsmUserEntryMBean entry) throws SnmpStatusException {
        SnmpOid[] oids = new SnmpOid[2];
        SnmpString val = null;
        val = new SnmpString(entry.getUsmUserEngineID());
        oids[0] = ((SnmpValue)val).toOid();
        val = new SnmpString(entry.getUsmUserName());
        oids[1] = ((SnmpValue)val).toOid();
        return new SnmpIndex(oids);
    }

    public SnmpOid buildOidFromIndex(SnmpIndex index) throws SnmpStatusException {
        SnmpOid oid = new SnmpOid();
        if (index.getNbComponents() != 2) {
            throw new SnmpStatusException(224);
        }
        try {
            Vector v = index.getComponents();
            SnmpString.appendToOid((SnmpOid)v.elementAt(0), oid);
            SnmpString.appendToOid((SnmpOid)v.elementAt(1), oid);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(224);
        }
        return oid;
    }

    public SnmpOid buildOidFromIndexVal(Byte[] aUsmUserEngineID, String aUsmUserName) throws SnmpStatusException {
        SnmpOid oid = new SnmpOid();
        try {
            SnmpString.appendToOid(new SnmpString(aUsmUserEngineID).toOid(), oid);
            SnmpString.appendToOid(new SnmpString(aUsmUserName).toOid(), oid);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpStatusException(224);
        }
        return oid;
    }

    public SnmpIndex buildSnmpIndex(long[] index, int start) throws SnmpStatusException {
        SnmpOid[] oids = new SnmpOid[2];
        int pos = start;
        oids[0] = SnmpString.toOid(index, pos);
        pos = SnmpString.nextOid(index, pos);
        oids[1] = SnmpString.toOid(index, pos);
        return new SnmpIndex(oids);
    }

    public Object createUsmUserEntryMBean(SnmpMibSubRequest req, SnmpOid rowOid, int depth, ObjectName entryObjName, SnmpMibTable meta, Byte[] aUsmUserEngineID, String aUsmUserName) throws SnmpStatusException {
        UsmUserEntry entry = new UsmUserEntry(this.theMib);
        entry.UsmUserEngineID = aUsmUserEngineID;
        entry.UsmUserName = aUsmUserName;
        return entry;
    }
}

