/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.ExtensibleClassLoader;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.Repository;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.common_impl.AbstractRepositoryImpl;
import com.sun.enterprise.module.common_impl.ModuleId;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASMainHelper {
    private Logger logger;
    private static final String DEFAULT_DOMAINS_DIR_PROPNAME = "AS_DEF_DOMAINS_PATH";
    private static final String INSTANCE_ROOT_PROP_NAME = "com.sun.aas.instanceRoot";

    public ASMainHelper(Logger logger) {
        this.logger = logger;
    }

    ClassLoader setupSharedCL(ClassLoader parent, List<URL> classpath, List<Repository> sharedRepos) {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (Repository repo : sharedRepos) {
            uris.addAll(repo.getJarLocations());
        }
        URL[] urls = new URL[uris.size() + classpath.size()];
        int i = 0;
        for (URL url : classpath) {
            urls[i++] = url;
        }
        for (URI uri : uris) {
            try {
                urls[i++] = uri.toURL();
            }
            catch (MalformedURLException e) {
                this.logger.warning("Error while adding library to shared classpath " + e.getMessage());
            }
        }
        return new ExtensibleClassLoader(urls, parent, sharedRepos);
    }

    void parseAsEnv(File installRoot) {
        Properties asenvProps = new Properties();
        asenvProps.putAll((Map<?, ?>)System.getProperties());
        asenvProps.put("com.sun.aas.installRoot", installRoot.getPath());
        File configDir = new File(installRoot, "config");
        File asenv = this.getAsEnvConf(configDir);
        BufferedReader lnReader = null;
        try {
            lnReader = new LineNumberReader(new FileReader(asenv));
            String line = ((LineNumberReader)lnReader).readLine();
            Pattern p = Pattern.compile("[Ss]?[Ee]?[Tt]? *([^=]*)=\"?([^\"]*)\"?");
            while (line != null) {
                Matcher m = p.matcher(line);
                if (m.matches()) {
                    File f = new File(m.group(2));
                    if (!f.isAbsolute()) {
                        f = new File(configDir, m.group(2));
                        if (f.exists()) {
                            asenvProps.put(m.group(1), f.getAbsolutePath());
                        } else {
                            asenvProps.put(m.group(1), m.group(2));
                        }
                    } else {
                        asenvProps.put(m.group(1), m.group(2));
                    }
                }
                line = ((LineNumberReader)lnReader).readLine();
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error opening asenv.conf : ", ioe);
        }
        finally {
            try {
                if (lnReader != null) {
                    lnReader.close();
                }
            }
            catch (IOException ioe) {}
        }
        System.setProperties(asenvProps);
    }

    void addPaths(File dir, String[] jarPrefixes, List<URL> urls) throws MalformedURLException {
        File[] jars = dir.listFiles();
        if (jars != null) {
            for (File f : jars) {
                for (String prefix : jarPrefixes) {
                    String name = f.getName();
                    if (!name.startsWith(prefix) || !name.endsWith(".jar")) continue;
                    urls.add(f.toURI().toURL());
                }
            }
        }
    }

    private File getAsEnvConf(File configDir) {
        String osName = System.getProperty("os.name");
        if (osName.indexOf("Windows") == -1) {
            return new File(configDir, "asenv.conf");
        }
        return new File(configDir, "asenv.bat");
    }

    File getDomainRoot(StartupContext context) {
        Properties args = context.getArguments();
        String domainDir = this.getParam(args, "domaindir");
        if (this.ok(domainDir)) {
            return new File(domainDir);
        }
        File defDomainsRoot = this.getDefaultDomainsDir();
        String domainName = this.getParam(args, "domain");
        if (this.ok(domainName)) {
            return new File(defDomainsRoot, domainName);
        }
        return this.getDefaultDomain(defDomainsRoot);
    }

    void verifyAndSetDomainRoot(File domainRoot) {
        String msg = null;
        if (domainRoot == null) {
            msg = "Internal Error: The domain dir is null.";
        } else if (!domainRoot.exists()) {
            msg = "the domain directory does not exist";
        } else if (!domainRoot.isDirectory()) {
            msg = "the domain directory is not a directory.";
        } else if (!domainRoot.canWrite()) {
            msg = "the domain directory is not writable.";
        } else if (!new File(domainRoot, "config").isDirectory()) {
            msg = "the domain directory is corrupt - there is no config subdirectory.";
        }
        if (msg != null) {
            throw new RuntimeException(msg);
        }
        domainRoot = this.absolutize(domainRoot);
        System.setProperty(INSTANCE_ROOT_PROP_NAME, domainRoot.getPath());
    }

    private File getDefaultDomainsDir() {
        String dirname = System.getProperty(DEFAULT_DOMAINS_DIR_PROPNAME);
        if (!this.ok(dirname)) {
            throw new RuntimeException("AS_DEF_DOMAINS_PATH is not set.");
        }
        File domainsDir = this.absolutize(new File(dirname));
        if (!domainsDir.isDirectory()) {
            throw new RuntimeException("AS_DEF_DOMAINS_PATH[" + dirname + "]" + " is specifying a file that is NOT a directory.");
        }
        return domainsDir;
    }

    private File getDefaultDomain(File domainsDir) {
        File[] domains = domainsDir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        if (domains == null || domains.length == 0) {
            throw new RuntimeException("no domain directories found under " + domainsDir);
        }
        if (domains.length > 1) {
            throw new RuntimeException("More than one domain found under " + domainsDir + " -- you must specify one domain.");
        }
        return domains[0];
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private String getParam(Properties map, String name) {
        String val = map.getProperty("-" + name);
        if (val == null) {
            val = map.getProperty("--" + name);
        }
        return val;
    }

    private File absolutize(File f) {
        try {
            return f.getCanonicalFile();
        }
        catch (Exception e) {
            return f.getAbsoluteFile();
        }
    }

    Repository getJDKToolsRepo() {
        File jdktools = this.getJDKToolsJar();
        if (jdktools != null && jdktools.exists()) {
            PlainJarRepository jdkToolsRepo = new PlainJarRepository("jdktools", jdktools);
            try {
                jdkToolsRepo.initialize();
            }
            catch (IOException e) {
                this.logger.log(Level.SEVERE, "Error while initializing jdk tools.jar", e);
            }
            return jdkToolsRepo;
        }
        return null;
    }

    File getJDKToolsJar() {
        File javaHome = new File(System.getProperty("java.home"));
        File jdktools = null;
        if (javaHome.getParent() != null) {
            jdktools = new File(javaHome.getParent(), "lib" + File.separator + "tools.jar");
        }
        return jdktools;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlainJarRepository
    extends AbstractRepositoryImpl {
        File aFile;

        public PlainJarRepository(String name, File aFile) {
            super(name, aFile.toURI());
            this.aFile = null;
            this.aFile = aFile;
        }

        @Override
        protected void loadModuleDefs(Map<ModuleId, ModuleDefinition> moduleDefs, List<URI> libraries) throws IOException {
            if (this.aFile.exists()) {
                libraries.add(this.aFile.toURI());
            }
        }
    }
}

