/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.BundleImpl;
import org.apache.felix.framework.BundleProtectionDomain;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.searchpolicy.ModuleImpl;
import org.apache.felix.framework.searchpolicy.PackageSource;
import org.apache.felix.framework.searchpolicy.Resolver;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.util.manifestparser.Requirement;
import org.apache.felix.moduleloader.ICapability;
import org.apache.felix.moduleloader.IModule;
import org.apache.felix.moduleloader.IRequirement;
import org.apache.felix.moduleloader.IWire;
import org.osgi.framework.PackagePermission;
import org.osgi.framework.Version;

public class FelixResolverState
implements Resolver.ResolverState {
    private final Logger m_logger;
    private final List m_moduleList = new ArrayList();
    private final Map m_unresolvedPkgIndexMap = new HashMap();
    private final Map m_resolvedPkgIndexMap = new HashMap();
    private final Map m_resolvedCapMap = new HashMap();
    private static final IModule[] m_emptyModules = new IModule[0];
    private static final PackageSource[] m_emptySources = new PackageSource[0];

    public FelixResolverState(Logger logger) {
        this.m_logger = logger;
    }

    public synchronized void addModule(IModule module) {
        this.m_moduleList.add(module);
        ICapability[] caps = module.getCapabilities();
        for (int i = 0; caps != null && i < caps.length; ++i) {
            if (!caps[i].getNamespace().equals("package")) continue;
            this.indexPackageCapability(this.m_unresolvedPkgIndexMap, module, caps[i]);
        }
    }

    public synchronized void removeModule(IModule module) {
        this.m_moduleList.remove(module);
        ICapability[] caps = module.getCapabilities();
        for (int i = 0; caps != null && i < caps.length; ++i) {
            if (!caps[i].getNamespace().equals("package")) continue;
            String pkgName = (String)caps[i].getProperties().get("package");
            IModule[] modules = (IModule[])this.m_unresolvedPkgIndexMap.get(pkgName);
            if (modules != null) {
                modules = FelixResolverState.removeModuleFromArray(modules, module);
                this.m_unresolvedPkgIndexMap.put(pkgName, modules);
            }
            if ((modules = (IModule[])this.m_resolvedPkgIndexMap.get(pkgName)) == null) continue;
            modules = FelixResolverState.removeModuleFromArray(modules, module);
            this.m_resolvedPkgIndexMap.put(pkgName, modules);
        }
        try {
            ((ModuleImpl)module).attachFragments(null);
        }
        catch (Exception ex) {
            this.m_logger.log(1, "Error detaching fragments.", ex);
        }
        ((ModuleImpl)module).setWires(null);
        ((ModuleImpl)module).close();
        this.m_resolvedCapMap.remove(module);
    }

    synchronized void refreshSystemBundleModule(IModule module) {
        ICapability[] caps = module.getCapabilities();
        for (int i = 0; caps != null && i < caps.length; ++i) {
            ICapability[] resolvedCaps = (ICapability[])this.m_resolvedCapMap.get(module);
            resolvedCaps = FelixResolverState.addCapabilityToArray(resolvedCaps, caps[i]);
            this.m_resolvedCapMap.put(module, resolvedCaps);
            if (!caps[i].getNamespace().equals("package")) continue;
            this.indexPackageCapability(this.m_resolvedPkgIndexMap, module, caps[i]);
        }
    }

    private void dumpPackageIndexMap(Map pkgIndexMap) {
        Iterator i = pkgIndexMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            IModule[] modules = (IModule[])entry.getValue();
            if (modules == null || modules.length <= 0 || modules.length == 1 && modules[0].getId().equals("0")) continue;
            System.out.println("  " + entry.getKey());
            for (int j = 0; j < modules.length; ++j) {
                System.out.println("    " + modules[j]);
            }
        }
    }

    public synchronized IModule[] getModules() {
        return this.m_moduleList.toArray(new IModule[this.m_moduleList.size()]);
    }

    private static Version getBundleVersion(IModule module) {
        ICapability[] caps = module.getCapabilities();
        for (int capIdx = 0; caps != null && capIdx < caps.length; ++capIdx) {
            if (!caps[capIdx].getNamespace().equals("module")) continue;
            return (Version)caps[capIdx].getProperties().get("bundle-version");
        }
        return Version.emptyVersion;
    }

    public synchronized void moduleResolved(IModule module) {
        if (module.isResolved()) {
            int capIdx;
            ICapability[] capsCopy;
            ICapability[] caps = module.getCapabilities();
            for (int capIdx2 = 0; caps != null && capIdx2 < caps.length; ++capIdx2) {
                if (!caps[capIdx2].getNamespace().equals("package")) continue;
                String pkgName = (String)caps[capIdx2].getProperties().get("package");
                this.m_unresolvedPkgIndexMap.put(pkgName, FelixResolverState.removeModuleFromArray((IModule[])this.m_unresolvedPkgIndexMap.get(pkgName), module));
            }
            ICapability[] iCapabilityArray = capsCopy = caps == null ? null : new ICapability[caps.length];
            if (capsCopy != null) {
                System.arraycopy(caps, 0, capsCopy, 0, caps.length);
            }
            IWire[] wires = module.getWires();
            block1: for (capIdx = 0; capsCopy != null && capIdx < capsCopy.length; ++capIdx) {
                for (int wireIdx = 0; wires != null && wireIdx < wires.length; ++wireIdx) {
                    if (!wires[wireIdx].getRequirement().isSatisfied(capsCopy[capIdx])) continue;
                    capsCopy[capIdx] = null;
                    continue block1;
                }
            }
            for (capIdx = 0; capsCopy != null && capIdx < capsCopy.length; ++capIdx) {
                if (capsCopy[capIdx] == null) continue;
                ICapability[] resolvedCaps = (ICapability[])this.m_resolvedCapMap.get(module);
                resolvedCaps = FelixResolverState.addCapabilityToArray(resolvedCaps, capsCopy[capIdx]);
                this.m_resolvedCapMap.put(module, resolvedCaps);
                if (!capsCopy[capIdx].getNamespace().equals("package")) continue;
                this.indexPackageCapability(this.m_resolvedPkgIndexMap, module, capsCopy[capIdx]);
            }
        }
    }

    public synchronized List getPotentialHosts(IModule fragment) {
        ArrayList<IModule> hostList = new ArrayList<IModule>();
        IRequirement[] reqs = fragment.getRequirements();
        IRequirement hostReq = null;
        for (int reqIdx = 0; reqIdx < reqs.length; ++reqIdx) {
            if (!reqs[reqIdx].getNamespace().equals("host")) continue;
            hostReq = reqs[reqIdx];
            break;
        }
        IModule[] modules = this.getModules();
        block1: for (int modIdx = 0; hostReq != null && modIdx < modules.length; ++modIdx) {
            if (fragment.equals(modules[modIdx]) || modules[modIdx].isResolved()) continue;
            ICapability[] caps = modules[modIdx].getCapabilities();
            for (int capIdx = 0; caps != null && capIdx < caps.length; ++capIdx) {
                if (!caps[capIdx].getNamespace().equals("host") || !hostReq.isSatisfied(caps[capIdx]) || ((BundleImpl)modules[modIdx].getBundle()).isStale()) continue;
                hostList.add(modules[modIdx]);
                continue block1;
            }
        }
        return hostList;
    }

    public synchronized Map getPotentialFragments(IModule host) {
        HashMap fragmentMap = new HashMap();
        ICapability[] caps = host.getCapabilities();
        ICapability bundleCap = null;
        for (int capIdx = 0; capIdx < caps.length; ++capIdx) {
            if (!caps[capIdx].getNamespace().equals("host")) continue;
            bundleCap = caps[capIdx];
            break;
        }
        IModule[] modules = this.getModules();
        block1: for (int modIdx = 0; bundleCap != null && modIdx < modules.length; ++modIdx) {
            if (host.equals(modules[modIdx])) continue;
            IRequirement[] reqs = modules[modIdx].getRequirements();
            for (int reqIdx = 0; reqs != null && reqIdx < reqs.length; ++reqIdx) {
                if (!reqs[reqIdx].getNamespace().equals("host") || !reqs[reqIdx].isSatisfied(bundleCap) || ((BundleImpl)modules[modIdx].getBundle()).isStale() || ((BundleImpl)modules[modIdx].getBundle()).isRemovalPending()) continue;
                this.indexFragment(fragmentMap, modules[modIdx]);
                continue block1;
            }
        }
        return fragmentMap;
    }

    public synchronized PackageSource[] getResolvedCandidates(IRequirement req) {
        Object[] candidates = m_emptySources;
        if (req.getNamespace().equals("package") && ((Requirement)req).getPackageName() != null) {
            String pkgName = ((Requirement)req).getPackageName();
            IModule[] modules = (IModule[])this.m_resolvedPkgIndexMap.get(pkgName);
            for (int modIdx = 0; modules != null && modIdx < modules.length; ++modIdx) {
                ICapability resolvedCap = Util.getSatisfyingCapability(modules[modIdx], req);
                if (resolvedCap == null) continue;
                if (System.getSecurityManager() != null && !((BundleProtectionDomain)modules[modIdx].getSecurityContext()).impliesDirect(new PackagePermission(pkgName, "export"))) {
                    this.m_logger.log(4, "PackagePermission.EXPORT denied for " + pkgName + "from " + modules[modIdx].getId());
                    continue;
                }
                PackageSource[] tmp = new PackageSource[candidates.length + 1];
                System.arraycopy(candidates, 0, tmp, 0, candidates.length);
                tmp[candidates.length] = new PackageSource(modules[modIdx], resolvedCap);
                candidates = tmp;
            }
        } else {
            Iterator i = this.m_resolvedCapMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                IModule module = (IModule)entry.getKey();
                ICapability[] resolvedCaps = (ICapability[])entry.getValue();
                for (int capIdx = 0; capIdx < resolvedCaps.length; ++capIdx) {
                    if (!req.isSatisfied(resolvedCaps[capIdx])) continue;
                    if (resolvedCaps[capIdx].getNamespace().equals("package") && System.getSecurityManager() != null && !((BundleProtectionDomain)module.getSecurityContext()).impliesDirect(new PackagePermission((String)resolvedCaps[capIdx].getProperties().get("package"), "export"))) {
                        this.m_logger.log(4, "PackagePermission.EXPORT denied for " + resolvedCaps[capIdx].getProperties().get("package") + "from " + module.getId());
                        continue;
                    }
                    PackageSource[] tmp = new PackageSource[candidates.length + 1];
                    System.arraycopy(candidates, 0, tmp, 0, candidates.length);
                    tmp[candidates.length] = new PackageSource(module, resolvedCaps[capIdx]);
                    candidates = tmp;
                }
            }
        }
        Arrays.sort(candidates);
        return candidates;
    }

    public synchronized PackageSource[] getUnresolvedCandidates(IRequirement req) {
        IModule[] modules = null;
        modules = req.getNamespace().equals("package") && ((Requirement)req).getPackageName() != null ? (IModule[])this.m_unresolvedPkgIndexMap.get(((Requirement)req).getPackageName()) : this.getModules();
        Object[] candidates = m_emptySources;
        for (int modIdx = 0; modules != null && modIdx < modules.length; ++modIdx) {
            ICapability cap = Util.getSatisfyingCapability(modules[modIdx], req);
            if (cap == null || modules[modIdx].isResolved()) continue;
            PackageSource[] tmp = new PackageSource[candidates.length + 1];
            System.arraycopy(candidates, 0, tmp, 0, candidates.length);
            tmp[candidates.length] = new PackageSource(modules[modIdx], cap);
            candidates = tmp;
        }
        Arrays.sort(candidates);
        return candidates;
    }

    private void indexPackageCapability(Map map, IModule module, ICapability capability) {
        if (capability.getNamespace().equals("package")) {
            String pkgName = (String)capability.getProperties().get("package");
            IModule[] modules = (IModule[])map.get(pkgName);
            if (modules == null) {
                modules = new IModule[]{module};
            } else {
                Version version = (Version)capability.getProperties().get("version");
                Version middleVersion = null;
                int top = 0;
                int bottom = modules.length - 1;
                int middle = 0;
                while (top <= bottom) {
                    middle = (bottom - top) / 2 + top;
                    middleVersion = (Version)FelixResolverState.getExportPackageCapability(modules[middle], pkgName).getProperties().get("version");
                    int cmp = middleVersion.compareTo(version);
                    if (cmp < 0) {
                        bottom = middle - 1;
                        continue;
                    }
                    if (cmp == 0) {
                        long exportId;
                        long middleId = Util.getBundleIdFromModuleId(modules[middle].getId());
                        if (middleId < (exportId = Util.getBundleIdFromModuleId(module.getId()))) {
                            top = middle + 1;
                            continue;
                        }
                        bottom = middle - 1;
                        continue;
                    }
                    top = middle + 1;
                }
                if (top >= modules.length || modules[top] != module) {
                    IModule[] newMods = new IModule[modules.length + 1];
                    System.arraycopy(modules, 0, newMods, 0, top);
                    System.arraycopy(modules, top, newMods, top + 1, modules.length - top);
                    newMods[top] = module;
                    modules = newMods;
                }
            }
            map.put(pkgName, modules);
        }
    }

    private void indexFragment(Map map, IModule module) {
        IModule[] modules = (IModule[])map.get(module.getSymbolicName());
        if (modules == null) {
            modules = new IModule[]{module};
        } else {
            Version version = FelixResolverState.getBundleVersion(module);
            Version middleVersion = null;
            int top = 0;
            int bottom = modules.length - 1;
            int middle = 0;
            while (top <= bottom) {
                middle = (bottom - top) / 2 + top;
                middleVersion = FelixResolverState.getBundleVersion(modules[middle]);
                int cmp = middleVersion.compareTo(version);
                if (cmp < 0) {
                    bottom = middle - 1;
                    continue;
                }
                if (cmp == 0) {
                    long exportId;
                    long middleId = Util.getBundleIdFromModuleId(modules[middle].getId());
                    if (middleId < (exportId = Util.getBundleIdFromModuleId(module.getId()))) {
                        top = middle + 1;
                        continue;
                    }
                    bottom = middle - 1;
                    continue;
                }
                top = middle + 1;
            }
            if (top >= modules.length || modules[top] != module) {
                IModule[] newMods = new IModule[modules.length + 1];
                System.arraycopy(modules, 0, newMods, 0, top);
                System.arraycopy(modules, top, newMods, top + 1, modules.length - top);
                newMods[top] = module;
                modules = newMods;
            }
        }
        map.put(module.getSymbolicName(), modules);
    }

    private static IModule[] removeModuleFromArray(IModule[] modules, IModule m) {
        if (modules == null) {
            return m_emptyModules;
        }
        int idx = -1;
        do {
            idx = -1;
            for (int i = 0; i < modules.length; ++i) {
                if (modules[i] != m) continue;
                idx = i;
                break;
            }
            if (idx < 0) continue;
            if (modules.length - 1 == 0) {
                modules = m_emptyModules;
                continue;
            }
            IModule[] newModules = new IModule[modules.length - 1];
            System.arraycopy(modules, 0, newModules, 0, idx);
            if (idx < newModules.length) {
                System.arraycopy(modules, idx + 1, newModules, idx, newModules.length - idx);
            }
            modules = newModules;
        } while (idx >= 0);
        return modules;
    }

    public static ICapability getExportPackageCapability(IModule m, String pkgName) {
        ICapability[] caps = m.getCapabilities();
        for (int i = 0; caps != null && i < caps.length; ++i) {
            if (!caps[i].getNamespace().equals("package") || !caps[i].getProperties().get("package").equals(pkgName)) continue;
            return caps[i];
        }
        return null;
    }

    private static ICapability[] addCapabilityToArray(ICapability[] caps, ICapability cap) {
        for (int i = 0; caps != null && i < caps.length; ++i) {
            if (!caps[i].equals(cap)) continue;
            return caps;
        }
        if (caps != null) {
            ICapability[] newCaps = new ICapability[caps.length + 1];
            System.arraycopy(caps, 0, newCaps, 0, caps.length);
            newCaps[caps.length] = cap;
            caps = newCaps;
        } else {
            caps = new ICapability[]{cap};
        }
        return caps;
    }
}

