/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.config.Named;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="list-app-refs")
@Scoped(value=PerLookup.class)
public class ListAppRefsCommand
implements AdminCommand {
    @Param(optional=true)
    String target = "server";
    @Param(optional=true)
    String type = null;
    @Param(optional=true, defaultValue="all")
    String state;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListAppRefsCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        part.setMessage(this.target);
        part.setChildrenType("application");
        List appRefs = ConfigBeansUtilities.getApplicationRefsInServer((String)this.target);
        for (ApplicationRef appRef : appRefs) {
            if (!this.state.equals("all") && (!this.state.equals("running") || !Boolean.valueOf(appRef.getEnabled()).booleanValue()) && (!this.state.equals("non-running") || Boolean.valueOf(appRef.getEnabled()).booleanValue()) || !this.isApplicationOfThisType(appRef.getRef(), this.type)) continue;
            ActionReport.MessagePart childPart = part.addChild();
            childPart.setMessage(appRef.getRef());
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private boolean isApplicationOfThisType(String name, String type) {
        if (type == null) {
            return true;
        }
        Named named = ConfigBeansUtilities.getModule((String)name);
        Application app = null;
        if (named instanceof Application) {
            app = (Application)named;
        }
        if (app != null) {
            if (Boolean.valueOf(app.getDeployProperties().getProperty("isComposite")).booleanValue()) {
                return type.equals("ear");
            }
            for (Module module : app.getModule()) {
                List engineList = module.getEngines();
                for (Engine engine : engineList) {
                    if (!engine.getSniffer().equals(type)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

