/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.deploy.shared;

import com.sun.enterprise.deployment.deploy.shared.Util;
import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ReadableArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JarArchive
implements Archive {
    protected ReadableArchive parentArchive;

    public Enumeration<String> entries(String prefix) {
        Enumeration allEntries = this.entries();
        Vector<String> entries = new Vector<String>();
        while (allEntries.hasMoreElements()) {
            String name = (String)allEntries.nextElement();
            if (name == null || !name.startsWith(prefix)) continue;
            entries.add(name);
        }
        return entries.elements();
    }

    public String getName() {
        return JarArchive.getName(this.getURI());
    }

    protected abstract JarEntry getJarEntry(String var1);

    public boolean exists(String name) throws IOException {
        return this.getJarEntry(name) != null;
    }

    public boolean isDirectory(String name) {
        JarEntry entry = this.getJarEntry(name);
        if (entry == null) {
            throw new IllegalArgumentException(name);
        }
        return entry.isDirectory();
    }

    static String getName(URI uri) {
        String path = Util.getURIName(uri);
        int lastDot = path.lastIndexOf(46);
        int endOfName = lastDot != -1 ? lastDot : path.length();
        String name = path.substring(0, endOfName);
        return name;
    }

    public void setParentArchive(ReadableArchive parentArchive) {
        this.parentArchive = parentArchive;
    }

    public ReadableArchive getParentArchive() {
        return this.parentArchive;
    }
}

