/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.deployment.deploy.shared.Util;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.glassfish.api.deployment.archive.ReadableArchive;

public class DeploymentUtils {
    private static final String WEB_XML = "WEB-INF/web.xml";
    private static final String WEB_INF_CLASSES = "WEB-INF/classes";
    private static final String WEB_INF_LIB = "WEB-INF/lib";
    private static final String JSP_SUFFIX = ".jsp";
    private static final String RA_XML = "META-INF/ra.xml";
    private static final String APPLICATION_XML = "META-INF/application.xml";
    private static final String EAR_EXTENSION = ".ear";
    private static final String WAR_EXTENSION = ".war";
    private static final String RAR_EXTENSION = ".rar";
    private static final String EXPANDED_WAR_SUFFIX = "_war";
    private static final String EXPANDED_RAR_SUFFIX = "_rar";
    private static final String EXPANDED_JAR_SUFFIX = "_jar";

    public static boolean isWebArchive(ReadableArchive archive) {
        try {
            if (Util.getURIName(archive.getURI()).endsWith(WAR_EXTENSION)) {
                return true;
            }
            if (archive.exists(WEB_XML) || archive.exists(WEB_INF_CLASSES) || archive.exists(WEB_INF_LIB)) {
                return true;
            }
            Enumeration entries = archive.entries();
            while (entries.hasMoreElements()) {
                String entryName = (String)entries.nextElement();
                if (!entryName.endsWith(JSP_SUFFIX)) continue;
                return true;
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String getDefaultEEName(String pathName) {
        if (pathName == null) {
            return null;
        }
        if (pathName.endsWith(".jar") || pathName.endsWith(WAR_EXTENSION) || pathName.endsWith(RAR_EXTENSION)) {
            return pathName.substring(0, pathName.length() - 4);
        }
        return pathName;
    }

    public static boolean isRAR(ReadableArchive archive) {
        boolean isRar = false;
        try {
            if (Util.getURIName(archive.getURI()).endsWith(RAR_EXTENSION)) {
                return true;
            }
            isRar = archive.exists(RA_XML);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isRar;
    }

    public static boolean isEAR(ReadableArchive archive) {
        boolean isEar = false;
        try {
            if (Util.getURIName(archive.getURI()).endsWith(EAR_EXTENSION)) {
                return true;
            }
            isEar = archive.exists(APPLICATION_XML);
            if (!isEar) {
                isEar = DeploymentUtils.isEARFromIntrospecting(archive);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isEar;
    }

    private static boolean isEARFromIntrospecting(ReadableArchive archive) throws IOException {
        for (String entryName : archive.getDirectories()) {
            if (!entryName.endsWith(EXPANDED_WAR_SUFFIX) && !entryName.endsWith(EXPANDED_RAR_SUFFIX) && !entryName.endsWith(EXPANDED_JAR_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    public static String getRelativeEmbeddedModulePath(String appRootPath, String moduleUri) {
        if (FileUtils.safeIsDirectory((File)new File(appRootPath, moduleUri = FileUtils.makeLegalNoBlankFileName((String)moduleUri)))) {
            return moduleUri;
        }
        return FileUtils.makeFriendlyFilename((String)moduleUri);
    }

    public static String getEmbeddedModulePath(String appRootPath, String moduleUri) {
        return appRootPath + File.separator + DeploymentUtils.getRelativeEmbeddedModulePath(appRootPath, moduleUri);
    }
}

