/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validation.engine;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintDescriptor;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.ConstraintViolation;
import javax.validation.UnexpectedTypeException;
import javax.validation.ValidationException;
import org.hibernate.validation.engine.ConstraintValidatorContextImpl;
import org.hibernate.validation.engine.ExecutionContext;
import org.hibernate.validation.jtype.TypeUtils;
import org.hibernate.validation.util.LoggerFactory;
import org.hibernate.validation.util.ValidatorTypeHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintTree<A extends Annotation> {
    private static final Logger log = LoggerFactory.make();
    private final ConstraintTree<?> parent;
    private final List<ConstraintTree<?>> children;
    private final ConstraintDescriptor<A> descriptor;

    public ConstraintTree(ConstraintDescriptor<A> descriptor) {
        this(descriptor, null);
    }

    private ConstraintTree(ConstraintDescriptor<A> descriptor, ConstraintTree<?> parent) {
        this.parent = parent;
        this.descriptor = descriptor;
        Set<ConstraintDescriptor<?>> composingConstraints = descriptor.getComposingConstraints();
        this.children = new ArrayList(composingConstraints.size());
        for (ConstraintDescriptor<?> composingDescriptor : composingConstraints) {
            ConstraintTree<?> treeNode = this.createConstraintTree(composingDescriptor);
            this.children.add(treeNode);
        }
    }

    private <U extends Annotation> ConstraintTree<U> createConstraintTree(ConstraintDescriptor<U> composingDescriptor) {
        return new ConstraintTree<U>(composingDescriptor, this);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public ConstraintTree getParent() {
        return this.parent;
    }

    public List<ConstraintTree<?>> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public ConstraintDescriptor<A> getDescriptor() {
        return this.descriptor;
    }

    public <T, V> void validateConstraints(V value, Type type, ExecutionContext<T> executionContext, List<ConstraintViolation<T>> constraintViolations) {
        ConstraintValidatorContextImpl constraintValidatorContext;
        ConstraintValidator<A, V> validator;
        for (ConstraintTree<?> tree : this.getChildren()) {
            tree.validateConstraints(value, type, executionContext, constraintViolations);
        }
        if (log.isTraceEnabled()) {
            log.trace("Validating value {} against constraint defined by {}", value, this.descriptor);
        }
        if (!(validator = this.getInitalizedValidator(value, type, executionContext.getConstraintValidatorFactory())).isValid(value, constraintValidatorContext = new ConstraintValidatorContextImpl(executionContext.peekParentPath(), executionContext.peekProperty(), this.descriptor))) {
            constraintViolations.addAll(executionContext.createConstraintViolations(value, constraintValidatorContext));
        }
        if (this.reportAsSingleViolation() && constraintViolations.size() > 0) {
            constraintViolations.clear();
            String message = (String)this.getParent().getDescriptor().getAttributes().get("message");
            String property = executionContext.peekPropertyPath();
            ConstraintValidatorContextImpl constraintValidatorContextImpl = constraintValidatorContext;
            constraintValidatorContextImpl.getClass();
            ConstraintValidatorContextImpl.ErrorMessage error = new ConstraintValidatorContextImpl.ErrorMessage(constraintValidatorContextImpl, message, property);
            constraintViolations.add(executionContext.createConstraintViolation(value, error, this.descriptor));
        }
    }

    private boolean reportAsSingleViolation() {
        return this.getParent() != null && this.getParent().getDescriptor().isReportAsSingleViolation();
    }

    private <V> ConstraintValidator<A, V> getInitalizedValidator(V value, Type type, ConstraintValidatorFactory constraintFactory) {
        Class<ConstraintValidator<?, ?>> validatorClass = this.findMatchingValidatorClass(value, type);
        ConstraintValidator<?, ?> constraintValidator = constraintFactory.getInstance(validatorClass);
        this.initializeConstraint(this.descriptor, constraintValidator);
        return constraintValidator;
    }

    private Class<? extends ConstraintValidator<?, ?>> findMatchingValidatorClass(Object value, Type type) {
        Map<Type, Class<ConstraintValidator<?, ?>>> validatorsTypes = ValidatorTypeHelper.getValidatorsTypes(this.descriptor.getConstraintValidatorClasses());
        ArrayList<Type> suitableTypes = new ArrayList<Type>();
        this.findSuitableValidatorTypes(type, validatorsTypes, suitableTypes);
        if (value != null) {
            this.findSuitableValidatorTypes(this.determineValueClass(value), validatorsTypes, suitableTypes);
        }
        this.resolveAssignableTypes(suitableTypes);
        this.verifyResolveWasUnique(type, suitableTypes);
        return validatorsTypes.get(suitableTypes.get(0));
    }

    private Class determineValueClass(Object value) {
        Class<Object> valueClass = value.getClass();
        if (valueClass.isArray()) {
            valueClass = Array.class;
        }
        return valueClass;
    }

    private void verifyResolveWasUnique(Type valueClass, List<Type> assignableClasses) {
        if (assignableClasses.size() == 0) {
            throw new UnexpectedTypeException("No validator could be found for type: " + valueClass);
        }
        if (assignableClasses.size() > 1) {
            StringBuilder builder = new StringBuilder();
            builder.append("There are multiple validators which could validate the type ");
            builder.append(valueClass);
            builder.append(". The validator classes are: ");
            for (Type clazz : assignableClasses) {
                builder.append(clazz);
                builder.append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
            throw new UnexpectedTypeException(builder.toString());
        }
    }

    private void findSuitableValidatorTypes(Type type, Map<Type, Class<? extends ConstraintValidator<?, ?>>> validatorsTypes, List<Type> suitableTypes) {
        for (Type validatorType : validatorsTypes.keySet()) {
            if (!TypeUtils.isAssignable(validatorType, type) || suitableTypes.contains(validatorType)) continue;
            suitableTypes.add(validatorType);
        }
    }

    private void resolveAssignableTypes(List<Type> assignableTypes) {
        if (assignableTypes.size() == 0 || assignableTypes.size() == 1) {
            return;
        }
        ArrayList<Type> typesToRemove = new ArrayList<Type>();
        do {
            typesToRemove.clear();
            Type type = assignableTypes.get(0);
            for (int i = 1; i < assignableTypes.size(); ++i) {
                if (TypeUtils.isAssignable(type, assignableTypes.get(i))) {
                    typesToRemove.add(type);
                    continue;
                }
                if (!TypeUtils.isAssignable(assignableTypes.get(i), type)) continue;
                typesToRemove.add(assignableTypes.get(i));
            }
            assignableTypes.removeAll(typesToRemove);
        } while (typesToRemove.size() > 0);
    }

    private <V> void initializeConstraint(ConstraintDescriptor<A> descriptor, ConstraintValidator<A, V> constraintValidator) {
        try {
            constraintValidator.initialize(descriptor.getAnnotation());
        }
        catch (RuntimeException e) {
            throw new ValidationException("Unable to intialize " + constraintValidator.getClass().getName(), e);
        }
    }
}

