/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.xml;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MiniXmlParser {
    private static final String DEFAULT_ADMIN_VS_ID = "__asadmin";
    private static final String DEFAULT_VS_ID = "server";
    private LoggingConfigImpl loggingConfig = new LoggingConfigImpl();
    private List<Map<String, String>> listenerAttributes = new ArrayList<Map<String, String>>();
    private List<Map<String, String>> vsAttributes = new ArrayList<Map<String, String>>();
    private Document document;
    private String configRef;
    private List<String> jvmOptions = new ArrayList<String>();
    private List<String> profilerJvmOptions = new ArrayList<String>();
    private Map<String, String> javaConfig;
    private Map<String, String> profilerConfig = Collections.emptyMap();
    private Map<String, String> sysProps = new HashMap<String, String>();
    private Map<String, String> profilerSysProps = new HashMap<String, String>();
    private boolean valid = false;
    private Set<Integer> adminPorts = new HashSet<Integer>();
    private String domainName;
    private String logFilename;
    private static final LocalStringsImpl strings = new LocalStringsImpl(MiniXmlParser.class);
    private String serverName;

    public MiniXmlParser(File domainXml) throws MiniXmlParserException {
        this(domainXml, DEFAULT_VS_ID);
    }

    public MiniXmlParser(File domainXml, String serverName) throws MiniXmlParserException {
        this.serverName = serverName;
        try {
            this.document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(domainXml);
            this.read();
            this.valid = true;
        }
        catch (Exception e) {
            throw new MiniXmlParserException(strings.get("toplevel", e), e);
        }
    }

    public Map<String, String> getJavaConfig() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.javaConfig;
    }

    public List<String> getJvmOptions() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.jvmOptions;
    }

    public Map<String, String> getProfilerConfig() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.profilerConfig;
    }

    public List<String> getProfilerJvmOptions() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.profilerJvmOptions;
    }

    public Map<String, String> getProfilerSystemProperties() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.profilerSysProps;
    }

    public Map<String, String> getSystemProperties() throws MiniXmlParserException {
        if (!this.valid) {
            throw new MiniXmlParserException(strings.get("invalid"));
        }
        return this.sysProps;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Set<Integer> getAdminPorts() {
        return this.adminPorts;
    }

    public void setupConfigDir(File configDir) {
        this.loggingConfig.setupConfigDir(configDir);
    }

    public String getLogFilename() {
        try {
            Map<String, String> map = this.loggingConfig.getLoggingProperties();
            this.logFilename = map.get("com.sun.enterprise.server.logging.GFFileHandler.file");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.logFilename;
    }

    private void read() throws XMLStreamException {
        this.getConfigRefName();
        this.getConfig();
        this.findDomainName();
    }

    private Node get(String path) {
        String[] elements = path.split("/");
        Node root = this.document;
        for (String element : elements) {
            root = this.find(root, element);
        }
        return root;
    }

    private Node find(Node root, String element) {
        Node node = null;
        if (root != null) {
            NodeList childNodes = root.getChildNodes();
            int length = childNodes.getLength();
            for (int i = 0; node == null && i < length; ++i) {
                Node child = childNodes.item(i);
                if (!element.equals(child.getNodeName())) continue;
                node = child;
            }
        }
        return node;
    }

    private void getConfigRefName() throws XMLStreamException {
        Node servers = this.get("domain/servers");
        new ChildNodeIterator(servers){

            public boolean process(Node node) {
                Map map = MiniXmlParser.this.parseAttributes(node);
                if (MiniXmlParser.this.serverName.equals(map.get("name"))) {
                    MiniXmlParser.this.configRef = (String)map.get("config-ref");
                    MiniXmlParser.this.parseSysPropsFromServer(node);
                    return true;
                }
                return false;
            }
        };
        if (this.configRef == null) {
            throw new XMLStreamException("server " + this.serverName + " not found");
        }
    }

    private void getConfig() throws XMLStreamException {
        Node configs = this.get("domain/configs");
        final boolean[] found = new boolean[]{false};
        new ChildNodeIterator(configs){

            public boolean process(Node node) {
                String name = node.getAttributes().getNamedItem("name").getNodeValue();
                if (MiniXmlParser.this.configRef.equals(name)) {
                    MiniXmlParser.this.parseConfig(node);
                    found[0] = true;
                    return true;
                }
                return false;
            }
        };
        if (!found[0]) {
            throw new XMLStreamException("configuration " + this.configRef + " not found");
        }
    }

    private void parseConfig(Node node) {
        new ChildNodeIterator(node){

            public boolean process(Node node) {
                String name = node.getNodeName();
                if ("system-property".equals(name)) {
                    MiniXmlParser.this.parseSystemPropertyNoOverride(node);
                } else if ("java-config".equals(name)) {
                    MiniXmlParser.this.parseJavaConfig(node);
                } else if ("http-service".equals(name)) {
                    MiniXmlParser.this.parseHttpService(node);
                } else if ("network-config".equals(name)) {
                    MiniXmlParser.this.parseNetworkConfig(node);
                } else if ("log-service".equals(name)) {
                    MiniXmlParser.this.parseLogService(node);
                }
                return false;
            }
        };
        String[] listenerNames = this.getListenerNamesForVS(DEFAULT_ADMIN_VS_ID, this.vsAttributes);
        if (listenerNames == null || listenerNames.length == 0) {
            listenerNames = this.getListenerNamesForVS(DEFAULT_VS_ID, this.vsAttributes);
        }
        if (listenerNames == null || listenerNames.length <= 0) {
            return;
        }
        this.addPortsForListeners(this.listenerAttributes, listenerNames);
    }

    private void parseSysPropsFromServer(Node server) {
        Node node = this.find(server, "system-property");
        if (node != null) {
            this.parseSystemPropertyWithOverride(node);
        }
    }

    private void parseSystemPropertyNoOverride(Node node) {
        this.parseSystemProperty(node, false);
    }

    private void parseSystemPropertyWithOverride(Node node) {
        this.parseSystemProperty(node, true);
    }

    private void parseSystemProperty(Node node, boolean override) {
        NamedNodeMap map = node.getAttributes();
        String name = map.getNamedItem("name").getNodeValue();
        if (name != null && (override || !this.sysProps.containsKey(name))) {
            this.sysProps.put(name, map.getNamedItem("value").getNodeValue());
        }
    }

    private void parseJavaConfig(Node node) {
        this.javaConfig = this.parseAttributes(node);
        this.parseJvmAndProfilerOptions(node);
    }

    private void parseJvmAndProfilerOptions(Node node) {
        new ChildNodeIterator(node){

            public boolean process(Node node) {
                if ("jvm-options".equals(node.getNodeName())) {
                    MiniXmlParser.this.jvmOptions.add(node.getTextContent());
                } else {
                    MiniXmlParser.this.parseProfiler(node);
                }
                return false;
            }
        };
    }

    private void parseProfiler(Node node) {
        this.profilerConfig = this.parseAttributes(node);
        new ChildNodeIterator(node){

            public boolean process(Node child) {
                if ("jvm-options".equals(child.getNodeName())) {
                    MiniXmlParser.this.profilerJvmOptions.add(child.getTextContent());
                } else {
                    MiniXmlParser.this.parseProperty(child, MiniXmlParser.this.profilerSysProps);
                }
                return false;
            }
        };
    }

    private void parseProperty(Node node, Map<String, String> map) {
        Map<String, String> prop = this.parseAttributes(node);
        String name = prop.get("name");
        if (name != null) {
            map.put(name, prop.get("value"));
        }
    }

    private void findDomainName() {
        try {
            new ChildNodeIterator(this.get("domain")){

                public boolean process(Node node) {
                    if ("property".equals(node.getNodeName())) {
                        MiniXmlParser.this.parseDomainName(node);
                    }
                    return false;
                }
            };
            if (this.domainName == null) {
                Logger.getLogger(MiniXmlParser.class.getName()).log(Level.INFO, strings.get("noDomainName"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(strings.get("noDomainEnd"));
        }
    }

    private void parseDomainName(Node node) {
        Map<String, String> map = this.parseAttributes(node);
        String name = map.get("name");
        String value = map.get("value");
        if (name == null || value == null) {
            return;
        }
        if ("administrative.domain.name".equals(name)) {
            this.domainName = value;
        }
    }

    private void parseLogService(Node node) {
        this.logFilename = this.parseAttributes(node).get("file");
    }

    private void parseHttpService(Node node) {
        new ChildNodeIterator(node){

            public boolean process(Node node) {
                String name = node.getNodeName();
                if ("virtual-server".equals(name)) {
                    MiniXmlParser.this.vsAttributes.add(MiniXmlParser.this.parseAttributes(node));
                }
                if ("http-listener".equals(name)) {
                    MiniXmlParser.this.listenerAttributes.add(MiniXmlParser.this.parseAttributes(node));
                }
                return false;
            }
        };
    }

    private void parseNetworkConfig(Node node) {
        new ChildNodeIterator(node){

            public boolean process(Node node) {
                String name = node.getNodeName();
                if ("network-listeners".equals(name)) {
                    new ChildNodeIterator(node){

                        public boolean process(Node node) {
                            String name = node.getNodeName();
                            if ("network-listener".equals(name)) {
                                MiniXmlParser.this.listenerAttributes.add(MiniXmlParser.this.parseAttributes(node));
                            }
                            return false;
                        }
                    };
                    return true;
                }
                return false;
            }
        };
    }

    private String[] getListenerNamesForVS(String vsid, List<Map<String, String>> vsAttributes) {
        String listeners = null;
        String[] listenerArray = null;
        for (Map<String, String> atts : vsAttributes) {
            String id = atts.get("id");
            if (id == null || !id.equals(vsid)) continue;
            listeners = atts.get("network-listeners");
            if (listeners != null) break;
            listeners = atts.get("http-listeners");
            break;
        }
        if (GFLauncherUtils.ok(listeners) && (listenerArray = listeners.split(",")) != null && listenerArray.length <= 0) {
            listenerArray = null;
        }
        if (listenerArray == null) {
            listenerArray = new String[]{};
        }
        return listenerArray;
    }

    private void addPortsForListeners(List<Map<String, String>> listenerAttributes, String[] listenerNames) {
        block0: for (Map<String, String> atts : listenerAttributes) {
            String id = atts.get("name");
            if (id == null) {
                id = atts.get("id");
            }
            if (id == null) continue;
            for (String listenerName : listenerNames) {
                if (!id.equals(listenerName)) continue;
                this.addPort(atts.get("port"));
                continue block0;
            }
        }
    }

    private void addPort(String portString) {
        try {
            this.adminPorts.add(Integer.parseInt(portString));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map<String, String> parseAttributes(Node node) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            int num = attrs.getLength();
            for (int i = 0; i < num; ++i) {
                Node item = attrs.item(i);
                map.put(item.getNodeName(), item.getNodeValue());
            }
        }
        return map;
    }

    private static abstract class ChildNodeIterator {
        public ChildNodeIterator(Node node) {
            NodeList list = node.getChildNodes();
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = list.item(i);
                if (child instanceof Text || !this.process(child)) continue;
                return;
            }
        }

        public abstract boolean process(Node var1);
    }
}

