/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.statistics.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.api.statistics.CountStatistic;
import org.glassfish.api.statistics.impl.StatisticImpl;

public class CountStatisticImpl
extends StatisticImpl
implements CountStatistic,
InvocationHandler {
    private AtomicLong count = new AtomicLong(Long.MIN_VALUE);
    private CountStatistic cs = (CountStatistic)Proxy.newProxyInstance(CountStatistic.class.getClassLoader(), new Class[]{CountStatistic.class}, (InvocationHandler)this);

    public CountStatisticImpl(long countVal, String name, String unit, String desc, long sampleTime, long startTime) {
        super(name, unit, desc, startTime, sampleTime);
        this.count.set(countVal);
    }

    public synchronized CountStatistic getStatistic() {
        return this.cs;
    }

    public synchronized Map getStaticAsMap() {
        Map m = super.getStaticAsMap();
        m.put("count", this.getCount());
        return m;
    }

    public String toString() {
        return super.toString() + NEWLINE + "Count: " + this.getCount();
    }

    public long getCount() {
        return this.count.get();
    }

    public void setCount(long countVal) {
        this.count.set(countVal);
    }

    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result;
        try {
            result = m.invoke((Object)this, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            throw new RuntimeException("unexpected invocation exception: " + e.getMessage());
        }
        return result;
    }
}

