/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.module.bootstrap.ArgumentManager;
import com.sun.enterprise.module.bootstrap.PlatformMain;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ASMain {
    static final Logger logger = Logger.getAnonymousLogger();
    private static final String PLATFORM_PROPERTY_KEY = "GlassFish_Platform";
    private static final String ARGS_KEY = "hk2.startup.context.args";
    private static final String ORIGINAL_CP = "-startup-classpath";
    private static final String ORIGINAL_CN = "-startup-classname";
    private static final String ORIGINAL_ARGS = "-startup-args";
    private static final String ARG_SEP = ",,,";

    public static void main(String[] args) {
        PlatformMain delegate;
        ASMain.setStartupContextProperties(args);
        String platform = Platform.Felix.toString();
        String temp = System.getProperty(PLATFORM_PROPERTY_KEY);
        if (temp == null || temp.trim().length() <= 0) {
            temp = System.getenv(PLATFORM_PROPERTY_KEY);
        }
        if (temp != null && temp.trim().length() != 0) {
            platform = temp.trim();
        }
        if ((delegate = ASMain.getMain(platform)) != null) {
            logger.info("Launching GlassFish on " + platform + " platform");
            System.setProperty(PLATFORM_PROPERTY_KEY, platform);
            try {
                delegate.setLogger(logger);
                delegate.start(args);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        } else {
            logger.severe("Cannot launch GlassFish on the unkown " + platform + " platform");
        }
    }

    private static PlatformMain getMain(String platform) {
        ServiceLoader<PlatformMain> loader = ServiceLoader.load(PlatformMain.class, ASMain.class.getClassLoader());
        for (PlatformMain main : loader) {
            if (!main.getName().equalsIgnoreCase(platform)) continue;
            return main;
        }
        return null;
    }

    private static void setStartupContextProperties(String ... args) {
        Properties p = ArgumentManager.argsToMap(args);
        p.put("__time_zero", new Long(System.currentTimeMillis()).toString());
        ASMain.addRawStartupInfo(args, p);
        try {
            StringWriter writer = new StringWriter();
            p.store(writer, null);
            System.setProperty(ARGS_KEY, ((Object)writer).toString());
        }
        catch (IOException e) {
            logger.info("Could not save startup parameters, will start with none");
            System.setProperty(ARGS_KEY, "");
        }
    }

    private static void addRawStartupInfo(String[] args, Properties p) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(ARG_SEP);
            }
            sb.append(args[i]);
        }
        if (!ASMain.wasStartedByCLI(p)) {
            p.put(ORIGINAL_CP, System.getProperty("java.class.path"));
            p.put(ORIGINAL_CN, ASMain.class.getName());
            p.put(ORIGINAL_ARGS, sb.toString());
        }
    }

    private static boolean wasStartedByCLI(Properties props) {
        return props.getProperty("-asadmin-classpath") != null && props.getProperty("-asadmin-classname") != null && props.getProperty("-asadmin-args") != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Platform {
        Felix,
        Knopflerfish,
        Equinox,
        Static;

    }
}

