/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.admin.ncli;

import java.io.File;
import org.glassfish.api.admin.cli.OptionType;
import org.glassfish.enterprise.admin.ncli.metadata.OperandDesc;

final class Operand {
    private final OperandDesc metadata;
    private final String[] givenValues;

    Operand(OperandDesc metadata, String[] values) {
        if (metadata == null || values == null) {
            throw new IllegalArgumentException("null arg");
        }
        for (String ov : values) {
            if (ov != null) continue;
            throw new IllegalArgumentException("null value specified for an operand");
        }
        this.metadata = metadata;
        this.givenValues = new String[values.length];
        System.arraycopy(values, 0, this.givenValues, 0, values.length);
        this.initializeEffectiveValues();
    }

    String getName() {
        return this.metadata.getName();
    }

    String getEffectiveType() {
        if (this.metadata.getOverridingType() == null) {
            return this.metadata.getType();
        }
        return this.metadata.getOverridingType().getType();
    }

    boolean hasOneValue() {
        String c = this.metadata.getCardinality();
        return "ONE".equals(c);
    }

    boolean hasManyValues() {
        return !this.hasOneValue();
    }

    String[] getEffectiveValues() {
        String[] copy = new String[this.givenValues.length];
        System.arraycopy(this.givenValues, 0, copy, 0, this.givenValues.length);
        return copy;
    }

    private void initializeEffectiveValues() {
        int i;
        String type = this.getEffectiveType();
        if (OptionType.FILE.name().equals(type) || OptionType.DIRECTORY.name().equals(type) || OptionType.FILE_PATH.name().equals(type)) {
            i = 0;
            for (String v : this.givenValues) {
                this.givenValues[i++] = new File(v).getAbsolutePath();
            }
        }
        if (OptionType.BOOLEAN.name().equals(type)) {
            i = 0;
            for (String v : this.givenValues) {
                this.givenValues[i++] = v.toLowerCase();
            }
        }
    }
}

