/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.admin.ncli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.api.admin.cli.OptionType;
import org.glassfish.enterprise.admin.ncli.Option;
import org.glassfish.enterprise.admin.ncli.metadata.OptionDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ParseUtilities {
    static final String NEG_LONG_PREFIX = "--no-";
    static final String CMD_NAME_REGEX = "^[a-zA-Z]([-_\\w]*)?$";
    static final String SHORT_BOOLEAN_OPTION_REGEX = "^-[a-zA-Z](=([t][r][u][e]|[f][a][l][s][e]))?$";
    static final String SHORT_BOOLEAN_OPTION_LIST_REGEX = "^-[a-zA-Z][a-zA-Z]+$";
    static final String LONG_BOOLEAN_OPTION_REGEX = "^--[\\w && \\D][_\\w]+(=([t][r][u][e]|[f][a][l][s][e]))?$";
    static final String NEG_LONG_BOOLEAN_OPTION_REGEX = "^--no-[\\w &&\\D][_\\w]+$";
    static final String SHORT_NON_BOOLEAN_OPTION_REGEX = "^-[a-zA-Z](=(.)+)?$";
    static final String LONG_NON_BOOLEAN_OPTION_REGEX = "^--[\\w && \\D][_\\w]+(=(.)+)?$";
    static final String REMAINDER_ARE_OPERANDS_INDICATOR_REGEX = "^--$";
    static final String OPTION_NAME_VALUE_SEPARATOR = "=";

    private ParseUtilities() {
    }

    static boolean indicatesCommandName(String s) {
        return ParseUtilities.matches(s, CMD_NAME_REGEX);
    }

    static boolean indicatesOption(String s) {
        return ParseUtilities.indicatesShortOption(s) || ParseUtilities.indicatesLongOption(s);
    }

    static boolean indicatesBooleanOptionList(String s) {
        return ParseUtilities.matches(s, SHORT_BOOLEAN_OPTION_LIST_REGEX);
    }

    static boolean indicatesShortOption(String s) {
        return ParseUtilities.indicatesShortBooleanOption(s) || ParseUtilities.indicatesShortNonBooleanOption(s);
    }

    static boolean indicatesLongOption(String s) {
        return ParseUtilities.indicatesLongBooleanOption(s) || ParseUtilities.indicatesNegativeLongBooleanOption(s) || ParseUtilities.indicatesLongNonBooleanOption(s);
    }

    static boolean indicatesShortBooleanOption(String s) {
        return ParseUtilities.matches(s, SHORT_BOOLEAN_OPTION_REGEX);
    }

    static boolean indicatesLongBooleanOption(String s) {
        return ParseUtilities.matches(s, LONG_BOOLEAN_OPTION_REGEX);
    }

    static boolean indicatesNegativeLongBooleanOption(String s) {
        return ParseUtilities.matches(s, NEG_LONG_BOOLEAN_OPTION_REGEX);
    }

    static boolean indicatesShortNonBooleanOption(String s) {
        return ParseUtilities.matches(s, SHORT_NON_BOOLEAN_OPTION_REGEX);
    }

    static boolean indicatesLongNonBooleanOption(String s) {
        return ParseUtilities.matches(s, LONG_NON_BOOLEAN_OPTION_REGEX);
    }

    static boolean indicatesEndOfOptions(String s) {
        return ParseUtilities.matches(s, REMAINDER_ARE_OPERANDS_INDICATOR_REGEX);
    }

    static String getOptionNameFromLongOption(String s) {
        if (!(ParseUtilities.indicatesLongBooleanOption(s) || ParseUtilities.indicatesLongNonBooleanOption(s) || ParseUtilities.indicatesNegativeLongBooleanOption(s))) {
            throw new IllegalArgumentException(s + " does not specify a long option");
        }
        if (ParseUtilities.indicatesLongBooleanOption(s) || ParseUtilities.indicatesLongNonBooleanOption(s)) {
            int start = 2;
            int equalsIndex = s.indexOf(OPTION_NAME_VALUE_SEPARATOR);
            int end = equalsIndex == -1 ? s.length() : equalsIndex;
            return s.substring(start, end);
        }
        return s.substring(NEG_LONG_PREFIX.length(), s.length());
    }

    static char getOptionSymbolFromShortOption(String s) {
        if (!ParseUtilities.indicatesShortBooleanOption(s) && !ParseUtilities.indicatesShortNonBooleanOption(s)) {
            throw new IllegalArgumentException(s + " does not specify a long option");
        }
        return s.charAt(1);
    }

    static boolean hasOptionNameAndValue(String s) {
        if (!ParseUtilities.indicatesOption(s)) {
            return false;
        }
        return s.indexOf(OPTION_NAME_VALUE_SEPARATOR) != -1;
    }

    static String getOptionValue(String s) {
        if (ParseUtilities.hasOptionNameAndValue(s)) {
            return s.substring(s.indexOf(OPTION_NAME_VALUE_SEPARATOR) + 1);
        }
        return null;
    }

    static void booleanOptionListToOptionMap(String s, Map<Character, String> trueOptions) {
        if (ParseUtilities.indicatesBooleanOptionList(s)) {
            String optionMnemonicsCombined = s.substring(1);
            for (char ch : optionMnemonicsCombined.toCharArray()) {
                trueOptions.put(Character.valueOf(ch), "true");
            }
        }
    }

    static OptionDesc getOptionDescForName(String s, Set<OptionDesc> som) {
        for (OptionDesc od : som) {
            if (!od.getName().equals(s)) continue;
            return od;
        }
        return null;
    }

    static OptionDesc getOptionDescForSymbol(char c, Set<OptionDesc> som) {
        String sc = Character.toString(c);
        for (OptionDesc od : som) {
            if (!od.getSymbol().equals(sc)) continue;
            return od;
        }
        return null;
    }

    static OptionDesc getOptionDescForBooleanOptionForName(String s, Set<OptionDesc> som) {
        for (OptionDesc od : som) {
            if (!od.getName().equals(s) || !od.getType().equals(OptionType.BOOLEAN.name())) continue;
            return od;
        }
        return null;
    }

    static OptionDesc getOptionDescForBooleanOptionForSymbol(char c, Set<OptionDesc> som) {
        String sc = Character.toString(c);
        for (OptionDesc od : som) {
            if (!od.getSymbol().equals(sc) || !od.getType().equals(OptionType.BOOLEAN.name())) continue;
            return od;
        }
        return null;
    }

    static OptionDesc getMetadataFor(String s, Set<OptionDesc> som) {
        for (OptionDesc od : som) {
            if (!od.getName().equals(s)) continue;
            return od;
        }
        return null;
    }

    static Set<OptionDesc> getAllOptionMetadataExcluding(Set<OptionDesc> som, Set<String> names) {
        if (names == null || names.isEmpty()) {
            return som;
        }
        HashSet<OptionDesc> remaining = new HashSet<OptionDesc>(som);
        HashSet<OptionDesc> exclude = new HashSet<OptionDesc>();
        block0: for (String name : names) {
            for (OptionDesc od : som) {
                if (!od.getName().equals(name)) continue;
                exclude.add(od);
                continue block0;
            }
        }
        remaining.removeAll(exclude);
        return remaining;
    }

    static boolean nonNullValueValidFor(OptionDesc po, String value) {
        if (value == null) {
            return true;
        }
        if (po == null) {
            throw new IllegalArgumentException("null arg");
        }
        value = value.trim();
        if (OptionType.FILE.name().equals(po.getType())) {
            File f = new File(value);
            return f.isFile() || f.canRead();
        }
        if (OptionType.BOOLEAN.name().equals(po.getType())) {
            return "true".equals(value.toLowerCase()) || "false".equals(value.toLowerCase());
        }
        return true;
    }

    static char getSymbol(String name, Map<Character, String> symbolToName) {
        for (char symbol : symbolToName.keySet()) {
            String aName = symbolToName.get(Character.valueOf(symbol));
            if (!aName.equals(name)) continue;
            return symbol;
        }
        return '\u0000';
    }

    static String getName(char symbol, Map<Character, String> symbolToName) {
        return symbolToName.get(Character.valueOf(symbol));
    }

    static Map<Character, String> getSymbolToNameMap(Set<OptionDesc> som) {
        HashMap<Character, String> s2n = new HashMap<Character, String>();
        for (OptionDesc od : som) {
            s2n.put(Character.valueOf(od.getSymbol().charAt(0)), od.getName());
        }
        return s2n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void file2Set(String file, Set<String> set) {
        BufferedReader reader = null;
        try {
            String line;
            InputStream is = ParseUtilities.class.getClassLoader().getResourceAsStream(file);
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                StringTokenizer tok = new StringTokenizer(line, " ");
                String cmd = tok.nextToken();
                set.add(cmd);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static Option getOptionNamed(Set<Option> ops, String name) {
        for (Option op : ops) {
            if (!op.getName().equals(name)) continue;
            return op;
        }
        return null;
    }

    static boolean isPassword(OptionDesc od) {
        return OptionType.PASSWORD.name().equals(od.getType());
    }

    private static boolean matches(String s, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(s);
        return m.matches();
    }
}

