/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.admin.ncli;

import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.enterprise.admin.ncli.FirstPassResult;
import org.glassfish.enterprise.admin.ncli.Option;
import org.glassfish.enterprise.admin.ncli.ParseUtilities;
import org.glassfish.enterprise.admin.ncli.ParserException;
import org.glassfish.enterprise.admin.ncli.ProgramOptionBuilder;
import org.glassfish.enterprise.admin.ncli.SecondPassResult;
import org.glassfish.enterprise.admin.ncli.metadata.CommandDesc;
import org.glassfish.enterprise.admin.ncli.metadata.OptionDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Parser {
    private static final ProgramOptionBuilder POB = ProgramOptionBuilder.getInstance();
    private final Set<String> slc = new HashSet<String>();
    private final Set<String> uslc = new HashSet<String>();
    private final String[] args;
    private final PrintStream out;
    private final PrintStream err;
    private static final LocalStringsImpl lsm = new LocalStringsImpl(Parser.class);

    Parser(String[] args, PrintStream out, PrintStream err) {
        if (args == null || out == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.args = new String[args.length];
        System.arraycopy(args, 0, this.args, 0, args.length);
        this.out = out;
        this.err = err;
        this.initialize();
    }

    Parser(String[] args) {
        this(args, System.out, System.err);
    }

    FirstPassResult firstPass() throws ParserException {
        Set<OptionDesc> known = POB.getAllOptionMetadata();
        HashMap<String, String> givenProgramOptions = new HashMap<String, String>();
        if (ParseUtilities.indicatesCommandName(this.args[0])) {
            FirstPassResult fpr;
            String cmd = this.args[0];
            this.handleUnsupportedLegacyCommand(cmd);
            int length = this.args.length - 1;
            String[] argsToParse = new String[length];
            System.arraycopy(this.args, 1, argsToParse, 0, length);
            String[] cmdArgs = Parser.splitUsingMetadata(argsToParse, known, givenProgramOptions);
            if (givenProgramOptions.size() > 0 && this.slc.contains(cmd)) {
                Set names = givenProgramOptions.keySet();
                Object[] nameArray = names.toArray(new String[names.size()]);
                this.warn("deprecated.syntax", cmd, Arrays.toString(nameArray));
                fpr = new FirstPassResult(cmd, givenProgramOptions, cmdArgs, true);
            } else {
                fpr = new FirstPassResult(cmd, givenProgramOptions, cmdArgs);
            }
            return fpr;
        }
        if (ParseUtilities.indicatesOption(this.args[0])) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        throw new ParserException(lsm.get("parser.invalid.start", new Object[]{this.args[0]}));
    }

    SecondPassResult secondPass(CommandDesc desc, String[] commandArguments) throws ParserException {
        return null;
    }

    private void initialize() {
        this.initializeLegacyCommands();
    }

    private void initializeLegacyCommands() {
        ParseUtilities.file2Set("supported-legacy-command-names", this.slc);
        ParseUtilities.file2Set("unsupported-legacy-command-names", this.uslc);
    }

    private void handleUnsupportedLegacyCommand(String cmd) throws ParserException {
        for (String c : this.uslc) {
            if (!c.equals(cmd)) continue;
            throw new ParserException(lsm.get("unsupported.legacy.command", new Object[]{cmd}));
        }
    }

    private static String[] splitUsingMetadata(String[] argsToParse, Set<OptionDesc> known, Map<String, String> optionMap) throws ParserException {
        int si = 0;
        ArrayList<String> remainingArgs = new ArrayList<String>();
        while (si < argsToParse.length) {
            String argument = argsToParse[si];
            if (ParseUtilities.indicatesOption(argument)) {
                OptionDesc lod;
                OptionDesc od;
                if (ParseUtilities.indicatesNegativeLongBooleanOption(argument)) {
                    Parser.handleNegativeLongBooleanOption(known, argument, optionMap, remainingArgs);
                    ++si;
                    continue;
                }
                if (ParseUtilities.indicatesShortOption(argument)) {
                    if (ParseUtilities.hasOptionNameAndValue(argument)) {
                        Parser.handleOptionGivenNameValue(known, argument, optionMap, remainingArgs);
                        ++si;
                        continue;
                    }
                    char c = ParseUtilities.getOptionSymbolFromShortOption(argument);
                    od = ParseUtilities.getOptionDescForBooleanOptionForSymbol(c, known);
                    if (od != null) {
                        Parser.putHandlingConstraints(od, optionMap, "true");
                        ++si;
                        continue;
                    }
                    if (si == argsToParse.length - 1) {
                        throw new ParserException(lsm.get("option.needs.value.symbol", new Object[]{Character.toString(c)}));
                    }
                    lod = ParseUtilities.getOptionDescForSymbol(c, known);
                    if (lod != null) {
                        Parser.putHandlingConstraints(lod, optionMap, argsToParse[si + 1]);
                        si += 2;
                        continue;
                    }
                    throw new ParserException(lsm.get("current.limitation.symbol", new Object[]{Character.toString(c)}));
                }
                assert (ParseUtilities.indicatesLongOption(argument)) : "Programming Error: option should be a long option: " + argument;
                if (ParseUtilities.hasOptionNameAndValue(argument)) {
                    Parser.handleOptionGivenNameValue(known, argument, optionMap, remainingArgs);
                    ++si;
                    continue;
                }
                String name = ParseUtilities.getOptionNameFromLongOption(argument);
                od = ParseUtilities.getOptionDescForBooleanOptionForName(name, known);
                if (od != null) {
                    Parser.putHandlingConstraints(od, optionMap, "true");
                    ++si;
                    continue;
                }
                if (si == argsToParse.length - 1) {
                    throw new ParserException(lsm.get("option.needs.value.name", new Object[]{name}));
                }
                lod = ParseUtilities.getOptionDescForName(name, known);
                if (lod != null) {
                    Parser.putHandlingConstraints(lod, optionMap, argsToParse[si + 1]);
                    si += 2;
                    continue;
                }
                throw new ParserException(lsm.get("current.limitation.name", new Object[]{name}));
            }
            if (ParseUtilities.indicatesBooleanOptionList(argument)) {
                Parser.handleBooleanOptionList(known, argument, optionMap, remainingArgs);
                ++si;
                continue;
            }
            if (ParseUtilities.indicatesEndOfOptions(argument)) {
                Parser.fillOperandsFromArgs(si + 1, remainingArgs, argsToParse);
                break;
            }
            remainingArgs.add(argument);
            ++si;
        }
        return remainingArgs.toArray(new String[remainingArgs.size()]);
    }

    private String splitMetadataForNewSyntax(String[] args2Parse, Set<OptionDesc> known, List<String> remaining) throws ParserException {
        String cmd = null;
        int si = 0;
        while (si < args2Parse.length) {
            String argument = args2Parse[si];
            if (ParseUtilities.indicatesOption(argument) || ParseUtilities.indicatesCommandName(argument)) continue;
            throw new ParserException("Encountered an argument that is neither a program option nor command name. This is a logic error.");
        }
        if (cmd == null) {
            throw new ParserException(lsm.get("no.command.specified"));
        }
        return cmd;
    }

    private static void handleOptionGivenNameValue(Set<OptionDesc> known, String argument, Map<String, String> filtrate, List<String> unknown) throws ParserException {
        String name;
        OptionDesc pod;
        if (ParseUtilities.indicatesShortOption(argument)) {
            char symbol = ParseUtilities.getOptionSymbolFromShortOption(argument);
            pod = ParseUtilities.getOptionDescForSymbol(symbol, known);
            name = pod != null ? pod.getName() : Character.toString(symbol);
        } else {
            name = ParseUtilities.getOptionNameFromLongOption(argument);
            pod = ParseUtilities.getOptionDescForName(name, known);
        }
        String value = ParseUtilities.getOptionValue(argument);
        if (pod != null) {
            if (!ParseUtilities.nonNullValueValidFor(pod, value)) {
                throw new ParserException(lsm.get("invalid.value.for.known.option", new Object[]{name, value}));
            }
            Parser.putHandlingConstraints(pod, filtrate, value);
        } else {
            unknown.add(argument);
        }
    }

    private static void handleNegativeLongBooleanOption(Set<OptionDesc> known, String argument, Map<String, String> filtrate, List<String> unknown) throws ParserException {
        String name = ParseUtilities.getOptionNameFromLongOption(argument);
        String value = "false";
        OptionDesc od = ParseUtilities.getOptionDescForName(name, known);
        if (od != null) {
            Parser.putHandlingConstraints(od, filtrate, value);
        } else {
            unknown.add(Option.toString(name, value));
        }
    }

    private static void fillOperandsFromArgs(int si, List<String> unknown, String[] from) {
        while (si < from.length) {
            unknown.add(from[si]);
            ++si;
        }
    }

    private static void handleBooleanOptionList(Set<OptionDesc> known, String argument, Map<String, String> filtrate, List<String> unknown) throws ParserException {
        Map<Character, String> symbol2Name = ParseUtilities.getSymbolToNameMap(known);
        HashMap<Character, String> trueOptions = new HashMap<Character, String>();
        ParseUtilities.booleanOptionListToOptionMap(argument, trueOptions);
        Set symbols = trueOptions.keySet();
        Iterator i$ = symbols.iterator();
        while (i$.hasNext()) {
            char c = ((Character)i$.next()).charValue();
            String optName = symbol2Name.get(Character.valueOf(c));
            if (optName == null) {
                unknown.add(Option.toString(optName, "true"));
                continue;
            }
            OptionDesc od = ParseUtilities.getOptionDescForName(optName, known);
            Parser.putHandlingConstraints(od, filtrate, "true");
        }
    }

    private static void putHandlingConstraints(OptionDesc od, Map<String, String> filtrate, String value) throws ParserException {
        String name;
        if (!Boolean.valueOf(od.getRepeats().toLowerCase()).booleanValue() && filtrate.containsKey(name = od.getName())) {
            throw new ParserException(lsm.get("repeats.not.allowed", new Object[]{name}));
        }
        if (ParseUtilities.isPassword(od)) {
            throw new ParserException(lsm.get("password.not.allowed.on.command.line", new Object[]{od.getName()}));
        }
        filtrate.put(od.getName(), value);
    }

    private void warn(String key, String ... args) {
        this.out.println(lsm.get(key, (Object[])args));
    }
}

