/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.admin.ncli;

import org.glassfish.enterprise.admin.ncli.CommandExecutionResult;
import org.glassfish.enterprise.admin.ncli.CommandMetadataCache;
import org.glassfish.enterprise.admin.ncli.FirstPassResult;
import org.glassfish.enterprise.admin.ncli.GenericCommandException;
import org.glassfish.enterprise.admin.ncli.NewCommand;
import org.glassfish.enterprise.admin.ncli.Parser;
import org.glassfish.enterprise.admin.ncli.ParserException;
import org.glassfish.enterprise.admin.ncli.SecondPassResult;
import org.glassfish.enterprise.admin.ncli.comm.TargetServer;
import org.glassfish.enterprise.admin.ncli.metadata.CommandDesc;

public class RemoteCommandDriver {
    private final String[] args;
    private final Parser parser;
    private final CommandMetadataCache cache;

    public RemoteCommandDriver(String[] args) {
        this.args = args;
        this.parser = new Parser(args);
        this.cache = new CommandMetadataCache();
    }

    public static void main(String ... args) throws ParserException, GenericCommandException {
        new RemoteCommandDriver(args).run();
    }

    private void run() throws ParserException, GenericCommandException {
        FirstPassResult fpr = this.parser.firstPass();
        String cmdName = fpr.getCommandName();
        TargetServer ts = fpr.getTargetServer();
        RemoteCommandDriver.debug("command is: " + cmdName);
        CommandDesc desc = this.cache.get(cmdName, ts);
        NewCommand command = null;
        if (desc == null) {
            desc = this.getCommandMetadata(cmdName, fpr.getTargetServer());
            SecondPassResult spr = this.parser.secondPass(desc, fpr.getCommandArguments());
            command = spr.getFinalCommand();
        }
        assert (command != null) : "Command is null!";
        CommandExecutionResult er = command.execute(ts);
        this.cache.put(cmdName, ts, desc);
    }

    private static void debug(String s) {
        System.out.println("Debug output: " + s);
    }

    private CommandDesc getCommandMetadata(String cmdName, TargetServer from) {
        return null;
    }
}

