/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.admin.ncli.comm;

public final class TargetServer {
    private final String host;
    private final int port;
    private final String user;
    private final String password;
    private final boolean secure;

    public TargetServer(String host, int port, String user, String password, boolean secure) {
        if (host == null) {
            throw new IllegalArgumentException("host can't be null");
        }
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.secure = secure;
    }

    public TargetServer(String host, int port, String user, String password) {
        this(host, port, user, password, false);
    }

    public TargetServer(String host, int port) {
        this(host, port, "anonymous", null);
    }

    public TargetServer() {
        this("localhost", 4848, "anonymous", null);
    }

    public boolean equals(Object ts) {
        if (ts instanceof TargetServer) {
            TargetServer that = (TargetServer)ts;
            boolean nonNullSame = this.host.equals(that.host) && this.port == that.port && this.secure == that.secure;
            boolean userSame = this.isUserSame(that);
            boolean passwordSame = this.isPasswordSame(that);
            return nonNullSame && userSame && passwordSame;
        }
        return false;
    }

    public int hashCode() {
        int hc = this.secure ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
        hc = 11 * this.host.hashCode() + 13 * this.port + 17 * hc;
        hc = this.user == null ? hc : hc + 19 * this.user.hashCode();
        hc = this.password == null ? hc : hc + 23 * this.password.hashCode();
        return hc;
    }

    private boolean isUserSame(TargetServer that) {
        boolean userSame = this.user == null && that.user == null ? true : (this.user != null && that.user == null || this.user == null && that.user != null ? false : this.user.equals(that.user));
        return userSame;
    }

    private boolean isPasswordSame(TargetServer that) {
        boolean passwordSame = this.password == null && that.password == null ? true : (this.password != null && that.password == null || this.password == null && that.password != null ? false : this.password.equals(that.password));
        return passwordSame;
    }
}

